/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.primitive;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.values.primitive.V8ValueBigNumber;
import java.math.BigInteger;
import java.util.Objects;

public final class V8ValueBigInteger
extends V8ValueBigNumber<BigInteger> {
    private static final int BYTE_COUNT_PER_WORD = 8;

    public V8ValueBigInteger(V8Runtime v8Runtime) throws JavetException {
        this(v8Runtime, BigInteger.ZERO);
    }

    public V8ValueBigInteger(V8Runtime v8Runtime, BigInteger value) throws JavetException {
        super(v8Runtime, Objects.requireNonNull(value));
    }

    public V8ValueBigInteger(V8Runtime v8Runtime, String value) throws JavetException {
        this(v8Runtime, new BigInteger(Objects.requireNonNull(value)));
    }

    V8ValueBigInteger(V8Runtime v8Runtime, int signum, long[] longArray) throws JavetException {
        this(v8Runtime, V8ValueBigInteger.toBigInteger(signum, longArray));
    }

    static BigInteger toBigInteger(int signum, long[] longArray) {
        if (signum == 0 || signum > 1 || signum < -1 || ArrayUtils.isEmpty(longArray)) {
            return BigInteger.ZERO;
        }
        int longLength = longArray.length;
        int byteLength = longLength * 8;
        byte[] bytes = new byte[byteLength];
        for (int i = 0; i < longLength; ++i) {
            int startIndex = (longLength - 1 - i) * 8;
            int endIndex = startIndex + 8;
            long l = longArray[i];
            for (int j = startIndex; j < endIndex; ++j) {
                bytes[j] = (byte)(0xFFL & l >> (endIndex - 1 - j) * 8);
            }
        }
        return new BigInteger(signum, bytes);
    }

    static long[] toLongArray(int signum, byte[] bytes) {
        int i;
        if (signum == 0) {
            return null;
        }
        int byteLength = bytes.length;
        int longLength = (byteLength + 8 - 1) / 8;
        long[] longArray = new long[longLength];
        for (i = 0; i < longLength; ++i) {
            int startIndex = byteLength - (i + 1) * 8;
            int endIndex = startIndex + 8;
            long longValue = 0L;
            for (int j = Math.max(0, startIndex); j < endIndex; ++j) {
                long l = 0xFF & (signum < 0 ? ~bytes[j] : bytes[j]);
                longValue |= l << (endIndex - 1 - j) * 8;
            }
            longArray[i] = longValue;
        }
        if (signum < 0) {
            for (i = 0; i < longLength; ++i) {
                int n = i;
                longArray[n] = longArray[n] + 1L;
                if (longArray[i] != 0L) break;
            }
        }
        return longArray;
    }

    @Override
    public boolean asBoolean() {
        return !BigInteger.ZERO.equals(this.value);
    }

    @Override
    public double asDouble() {
        return ((BigInteger)this.value).doubleValue();
    }

    @Override
    public int asInt() {
        return ((BigInteger)this.value).intValue();
    }

    @Override
    public long asLong() {
        return ((BigInteger)this.value).longValue();
    }

    long[] getLongArray() {
        return V8ValueBigInteger.toLongArray(((BigInteger)this.value).signum(), ((BigInteger)this.value).toByteArray());
    }

    int getSignum() {
        return ((BigInteger)this.value).signum();
    }

    public V8ValueBigInteger toClone(boolean referenceCopy) throws JavetException {
        return this;
    }

    public BigInteger toPrimitive() {
        return (BigInteger)this.value;
    }
}

