/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.JavetVirtualObject;
import com.caoccao.javet.values.V8Value;
import java.util.StringJoiner;

public final class V8ValueUtils {
    private V8ValueUtils() {
    }

    public static String concat(String delimiter, V8Value ... v8Values) {
        if (ArrayUtils.isEmpty(v8Values)) {
            return "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringJoiner stringJoiner = new StringJoiner(delimiter);
        for (V8Value v8Value : v8Values) {
            stringJoiner.add(v8Value.toString());
        }
        return stringJoiner.toString();
    }

    public static JavetVirtualObject[] convertToVirtualObjects(V8Value ... v8Values) {
        int length = v8Values == null ? 0 : v8Values.length;
        JavetVirtualObject[] javetVirtualObjects = new JavetVirtualObject[length];
        for (int i = 0; i < length; ++i) {
            javetVirtualObjects[i] = new JavetVirtualObject(v8Values[i]);
        }
        return javetVirtualObjects;
    }

    public static Object[] toArray(V8Runtime v8Runtime, V8Value ... v8Values) throws JavetException {
        int length = v8Values == null ? 0 : v8Values.length;
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            objects[i] = v8Runtime.toObject(v8Values[i]);
        }
        return objects;
    }

    public static String trimAnonymousFunction(String sourceCode) {
        int length;
        if (sourceCode != null && (length = sourceCode.length()) > 0) {
            int endPosition = length;
            boolean completed = false;
            block3: while (!completed && endPosition > 0) {
                switch (sourceCode.charAt(endPosition - 1)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ';': {
                        --endPosition;
                        continue block3;
                    }
                }
                completed = true;
            }
            if (endPosition == length) {
                return sourceCode;
            }
            return sourceCode.substring(0, endPosition);
        }
        return null;
    }
}

