/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.loader;

import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.loader.IJavetLibLoadingListener;
import com.caoccao.javet.interop.loader.JavetLibLoadingListener;
import com.caoccao.javet.utils.JavetDefaultLogger;
import com.caoccao.javet.utils.JavetOSUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Objects;

public final class JavetLibLoader {
    public static final String LIB_VERSION = "3.0.3";
    private static final String ANDROID_ABI_ARM = "armeabi-v7a";
    private static final String ANDROID_ABI_ARM64 = "arm64-v8a";
    private static final String ANDROID_ABI_X86 = "x86";
    private static final String ANDROID_ABI_X86_64 = "x86_64";
    private static final String ARCH_ARM = "arm";
    private static final String ARCH_ARM64 = "arm64";
    private static final String ARCH_X86 = "x86";
    private static final String ARCH_X86_64 = "x86_64";
    private static final int BUFFER_LENGTH = 4096;
    private static final String CHMOD = "chmod";
    private static final String DOT = ".";
    private static final String LIB_FILE_EXTENSION_ANDROID = "so";
    private static final String LIB_FILE_EXTENSION_LINUX = "so";
    private static final String LIB_FILE_EXTENSION_MACOS = "dylib";
    private static final String LIB_FILE_EXTENSION_WINDOWS = "dll";
    private static final String LIB_FILE_NAME_FORMAT = "libjavet-{0}-{1}-{2}.v.{3}.{4}";
    private static final String LIB_FILE_NAME_FOR_ANDROID_FORMAT = "libjavet-{0}-{1}.v.{2}.{3}";
    private static final String LIB_FILE_NAME_PREFIX = "lib";
    private static final IJavetLogger LOGGER = new JavetDefaultLogger(JavetLibLoader.class.getName());
    private static final long MIN_LAST_MODIFIED_GAP_IN_MILLIS = 60000L;
    private static final String OS_ANDROID = "android";
    private static final String OS_LINUX = "linux";
    private static final String OS_MACOS = "macos";
    private static final String OS_WINDOWS = "windows";
    private static final String RESOURCE_NAME_FORMAT = "/{0}";
    private static final String XRR = "755";
    private static IJavetLibLoadingListener libLoadingListener = new JavetLibLoadingListener();
    private final JSRuntimeType jsRuntimeType;
    private volatile boolean loaded;

    public JavetLibLoader(JSRuntimeType jsRuntimeType) {
        Objects.requireNonNull(jsRuntimeType);
        this.jsRuntimeType = jsRuntimeType;
        this.loaded = false;
    }

    public static IJavetLibLoadingListener getLibLoadingListener() {
        return libLoadingListener;
    }

    public static void setLibLoadingListener(IJavetLibLoadingListener libLoadingListener) {
        JavetLibLoader.libLoadingListener = Objects.requireNonNull(libLoadingListener);
    }

    private void deployLibFile(String resourceFileName, File libFile) {
        boolean isLibFileLocked = false;
        if (libFile.exists() && libFile.canWrite()) {
            try {
                libFile.delete();
            }
            catch (Throwable t) {
                isLibFileLocked = true;
                LOGGER.logWarn("Failed to delete {0} because it is locked.", libFile.getAbsolutePath());
            }
        }
        if (!isLibFileLocked) {
            byte[] buffer = new byte[4096];
            try (InputStream inputStream = JavetLibLoader.class.getResourceAsStream(resourceFileName);
                 FileOutputStream outputStream = new FileOutputStream(libFile.getAbsolutePath());){
                if (inputStream != null) {
                    int length;
                    while ((length = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, length);
                    }
                    if (JavetOSUtils.IS_LINUX || JavetOSUtils.IS_MACOS || JavetOSUtils.IS_ANDROID) {
                        try {
                            Runtime.getRuntime().exec(new String[]{CHMOD, XRR, libFile.getAbsolutePath()}).waitFor();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.logWarn("Failed to write to {0} because it is locked.", libFile.getAbsolutePath());
            }
        }
    }

    private String getAndroidABI() {
        if (JavetOSUtils.IS_ANDROID) {
            if (JavetOSUtils.IS_ARM) {
                return ANDROID_ABI_ARM;
            }
            if (JavetOSUtils.IS_ARM64) {
                return ANDROID_ABI_ARM64;
            }
            if (JavetOSUtils.IS_X86) {
                return "x86";
            }
            if (JavetOSUtils.IS_X86_64) {
                return "x86_64";
            }
        }
        return null;
    }

    private String getFileExtension() {
        if (JavetOSUtils.IS_WINDOWS) {
            return LIB_FILE_EXTENSION_WINDOWS;
        }
        if (JavetOSUtils.IS_LINUX) {
            return "so";
        }
        if (JavetOSUtils.IS_MACOS) {
            return LIB_FILE_EXTENSION_MACOS;
        }
        if (JavetOSUtils.IS_ANDROID) {
            return "so";
        }
        return null;
    }

    public JSRuntimeType getJSRuntimeType() {
        return this.jsRuntimeType;
    }

    public String getLibFileName() throws JavetException {
        String fileExtension = this.getFileExtension();
        String osName = this.getOSName();
        if (fileExtension == null || osName == null) {
            throw new JavetException(JavetError.OSNotSupported, SimpleMap.of("OS", JavetOSUtils.OS_NAME));
        }
        if (JavetOSUtils.IS_ANDROID) {
            return MessageFormat.format(LIB_FILE_NAME_FOR_ANDROID_FORMAT, this.jsRuntimeType.getName(), osName, LIB_VERSION, fileExtension);
        }
        String osArch = this.getOSArch();
        if (osArch == null) {
            throw new JavetException(JavetError.OSNotSupported, SimpleMap.of("OS", JavetOSUtils.OS_ARCH));
        }
        return MessageFormat.format(LIB_FILE_NAME_FORMAT, this.jsRuntimeType.getName(), osName, osArch, LIB_VERSION, fileExtension);
    }

    private String getNormalizedLibFilePath(String libFilePath) {
        boolean prefixToBeNormalized = false;
        if (JavetOSUtils.IS_LINUX) {
            prefixToBeNormalized = true;
            if (libFilePath.endsWith(".so")) {
                libFilePath = libFilePath.substring(0, libFilePath.length() - DOT.length() - "so".length());
            }
        } else if (JavetOSUtils.IS_ANDROID) {
            prefixToBeNormalized = true;
            if (libFilePath.endsWith(".so")) {
                libFilePath = libFilePath.substring(0, libFilePath.length() - DOT.length() - "so".length());
            }
        } else if (JavetOSUtils.IS_MACOS) {
            prefixToBeNormalized = true;
            if (libFilePath.endsWith(".dylib")) {
                libFilePath = libFilePath.substring(0, libFilePath.length() - DOT.length() - LIB_FILE_EXTENSION_MACOS.length());
            }
        }
        if (prefixToBeNormalized && libFilePath.startsWith(LIB_FILE_NAME_PREFIX)) {
            libFilePath = libFilePath.substring(LIB_FILE_NAME_PREFIX.length());
        }
        return libFilePath;
    }

    private String getOSArch() {
        if (JavetOSUtils.IS_WINDOWS) {
            return "x86_64";
        }
        if (JavetOSUtils.IS_LINUX) {
            return JavetOSUtils.IS_ARM64 ? ARCH_ARM64 : "x86_64";
        }
        if (JavetOSUtils.IS_MACOS) {
            return JavetOSUtils.IS_ARM64 ? ARCH_ARM64 : "x86_64";
        }
        if (JavetOSUtils.IS_ANDROID) {
            if (JavetOSUtils.IS_ARM) {
                return ARCH_ARM;
            }
            if (JavetOSUtils.IS_ARM64) {
                return ARCH_ARM64;
            }
            if (JavetOSUtils.IS_X86) {
                return "x86";
            }
            if (JavetOSUtils.IS_X86_64) {
                return "x86_64";
            }
        }
        return null;
    }

    private String getOSName() {
        if (JavetOSUtils.IS_WINDOWS) {
            return OS_WINDOWS;
        }
        if (JavetOSUtils.IS_LINUX) {
            return OS_LINUX;
        }
        if (JavetOSUtils.IS_MACOS) {
            return OS_MACOS;
        }
        if (JavetOSUtils.IS_ANDROID) {
            return OS_ANDROID;
        }
        return null;
    }

    public String getResourceFileName() throws JavetException {
        String resourceFileName = MessageFormat.format(RESOURCE_NAME_FORMAT, JavetOSUtils.IS_ANDROID ? StringUtils.join((CharSequence)"/", LIB_FILE_NAME_PREFIX, this.getAndroidABI(), this.getLibFileName()) : this.getLibFileName());
        if (JavetLibLoader.class.getResource(resourceFileName) == null) {
            throw new JavetException(JavetError.LibraryNotFound, SimpleMap.of("path", resourceFileName));
        }
        return resourceFileName;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void load() throws JavetException {
        block13: {
            if (!this.loaded) {
                String libFilePath = null;
                try {
                    File libPath;
                    boolean isLibInSystemPath = libLoadingListener.isLibInSystemPath(this.jsRuntimeType);
                    boolean isDeploy = libLoadingListener.isDeploy(this.jsRuntimeType);
                    if (isLibInSystemPath) {
                        libFilePath = this.getLibFileName();
                    } else if (isDeploy) {
                        libPath = libLoadingListener.getLibPath(this.jsRuntimeType);
                        Objects.requireNonNull(libPath, "Lib path cannot be null");
                        String resourceFileName = this.getResourceFileName();
                        File rootLibPath = JavetOSUtils.IS_ANDROID ? libPath : new File(libPath, Long.toString(JavetOSUtils.PROCESS_ID));
                        if (!rootLibPath.exists() && !rootLibPath.mkdirs()) {
                            LOGGER.logError("Failed to create {0}.", rootLibPath.getAbsolutePath());
                        }
                        this.purge(libPath);
                        File libFile = new File(rootLibPath, this.getLibFileName()).getAbsoluteFile();
                        this.deployLibFile(resourceFileName, libFile);
                        libFilePath = libFile.getAbsolutePath();
                    } else {
                        libPath = libLoadingListener.getLibPath(this.jsRuntimeType);
                        Objects.requireNonNull(libPath, "Lib path cannot be null");
                        libFilePath = new File(libPath, this.getLibFileName()).getAbsolutePath();
                    }
                    try {
                        if (isLibInSystemPath) {
                            System.loadLibrary(this.getNormalizedLibFilePath(libFilePath));
                        } else {
                            System.load(libFilePath);
                        }
                        this.loaded = true;
                    }
                    catch (Throwable t) {
                        if (libLoadingListener.isSuppressingError(this.jsRuntimeType)) {
                            LOGGER.warn(t.getMessage());
                            this.loaded = true;
                            break block13;
                        }
                        throw t;
                    }
                }
                catch (Throwable t) {
                    LOGGER.logError(t, t.getMessage(), new Object[0]);
                    throw new JavetException(JavetError.FailedToReadPath, SimpleMap.of("path", libFilePath), t);
                }
            }
        }
    }

    private void purge(File rootLibPath) {
        block14: {
            try {
                if (!rootLibPath.exists()) break block14;
                if (rootLibPath.isDirectory()) {
                    File[] files = rootLibPath.listFiles();
                    if (files == null || files.length <= 0) break block14;
                    for (File libFileOrPath : files) {
                        boolean toBeDeleted;
                        block15: {
                            if (libFileOrPath.lastModified() + 60000L > System.currentTimeMillis()) continue;
                            toBeDeleted = false;
                            if (libFileOrPath.isDirectory()) {
                                try {
                                    File[] libFiles = libFileOrPath.listFiles();
                                    if (libFiles != null && libFiles.length > 0) {
                                        for (File libFile : libFiles) {
                                            if (!libFile.delete()) {
                                                LOGGER.logDebug("{0} is locked.", libFile.getAbsolutePath());
                                                toBeDeleted = true;
                                                break block15;
                                            }
                                            LOGGER.logDebug("Deleted {0}.", libFile.getAbsolutePath());
                                        }
                                        break block15;
                                    }
                                    toBeDeleted = true;
                                }
                                catch (Throwable t) {
                                    LOGGER.logError(t, "Failed to delete {0}.", libFileOrPath.getAbsolutePath());
                                }
                            } else if (libFileOrPath.isFile()) {
                                toBeDeleted = true;
                            }
                        }
                        if (!toBeDeleted) continue;
                        if (libFileOrPath.delete()) {
                            LOGGER.logDebug("Deleted {0}.", libFileOrPath.getAbsolutePath());
                            continue;
                        }
                        LOGGER.logDebug("{0} is locked.", libFileOrPath.getAbsolutePath());
                    }
                    break block14;
                }
                if (!rootLibPath.delete()) {
                    LOGGER.logError("Failed to delete {0}.", rootLibPath.getAbsolutePath());
                }
            }
            catch (Throwable t) {
                LOGGER.logError(t, "Failed to clean up {0}.", rootLibPath.getAbsolutePath());
            }
        }
    }
}

