/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.JavetClassLoader;
import com.caoccao.javet.interop.NodeRuntime;
import com.caoccao.javet.interop.V8Notifier;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.monitoring.V8SharedMemoryStatistics;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.utils.JavetDefaultLogger;
import com.caoccao.javet.utils.SimpleMap;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public final class V8Host
implements AutoCloseable {
    private static final long INVALID_HANDLE = 0L;
    private static boolean libraryReloadable = false;
    private static volatile double memoryUsageThresholdRatio = 0.7;
    private final JSRuntimeType jsRuntimeType;
    private final IJavetLogger logger;
    private final V8Notifier v8Notifier;
    private final ConcurrentHashMap<Long, V8Runtime> v8RuntimeMap;
    private boolean isolateCreated;
    private JavetClassLoader javetClassLoader;
    private JavetException lastException;
    private volatile boolean libraryLoaded;
    private IV8Native v8Native;

    private V8Host(JSRuntimeType jsRuntimeType) {
        Objects.requireNonNull(jsRuntimeType);
        this.javetClassLoader = null;
        this.lastException = null;
        this.libraryLoaded = false;
        this.logger = new JavetDefaultLogger(this.getClass().getName());
        this.v8RuntimeMap = new ConcurrentHashMap();
        this.v8Native = null;
        this.isolateCreated = false;
        this.jsRuntimeType = jsRuntimeType;
        this.loadLibrary();
        this.v8Notifier = new V8Notifier(this.v8RuntimeMap);
    }

    public static V8Host getInstance(JSRuntimeType jsRuntimeType) {
        Objects.requireNonNull(jsRuntimeType);
        if (jsRuntimeType.isV8()) {
            return V8Host.getV8Instance();
        }
        if (jsRuntimeType.isNode()) {
            return V8Host.getNodeInstance();
        }
        return null;
    }

    public static double getMemoryUsageThresholdRatio() {
        return memoryUsageThresholdRatio;
    }

    public static V8Host getNodeInstance() {
        return NodeInstanceHolder.INSTANCE;
    }

    public static V8Host getV8Instance() {
        return V8InstanceHolder.INSTANCE;
    }

    public static boolean isLibraryReloadable() {
        return libraryReloadable;
    }

    public static void setLibraryReloadable(boolean libraryReloadable) {
        V8Host.libraryReloadable = libraryReloadable;
    }

    private static void setMemoryUsageThreshold() {
        if (memoryUsageThresholdRatio > 0.0) {
            MemoryPoolMXBean heapMemoryPoolMXBean = null;
            List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
                if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
                heapMemoryPoolMXBean = memoryPoolMXBean;
                break;
            }
            if (heapMemoryPoolMXBean != null) {
                long memoryUsageThreshold = (long)Math.floor((double)heapMemoryPoolMXBean.getUsage().getMax() * memoryUsageThresholdRatio);
                heapMemoryPoolMXBean.setUsageThreshold(memoryUsageThreshold);
            }
        }
    }

    public static void setMemoryUsageThresholdRatio(double memoryUsageThresholdRatio) {
        assert (0.0 <= memoryUsageThresholdRatio && memoryUsageThresholdRatio < 1.0);
        V8Host.memoryUsageThresholdRatio = memoryUsageThresholdRatio;
    }

    public void clearInternalStatistic() {
        this.v8Native.clearInternalStatistic();
    }

    @Override
    public void close() throws JavetException {
        int v8RuntimeCount = this.getV8RuntimeCount();
        if (v8RuntimeCount != 0) {
            throw new JavetException(JavetError.RuntimeLeakageDetected, SimpleMap.of("count", v8RuntimeCount));
        }
        this.disableGCNotification();
    }

    public void closeV8Runtime(V8Runtime v8Runtime) {
        long handle;
        if (!this.libraryLoaded) {
            return;
        }
        if (v8Runtime != null && (handle = v8Runtime.getHandle()) != 0L && this.v8RuntimeMap.containsKey(handle)) {
            this.v8Native.closeV8Runtime(handle);
            this.v8RuntimeMap.remove(handle);
        }
    }

    public <R extends V8Runtime> R createV8Runtime() throws JavetException {
        return this.createV8Runtime((RuntimeOptions<?>)this.getJSRuntimeType().getRuntimeOptions());
    }

    public <R extends V8Runtime> R createV8Runtime(RuntimeOptions<?> runtimeOptions) throws JavetException {
        return this.createV8Runtime(false, runtimeOptions);
    }

    public <R extends V8Runtime> R createV8Runtime(boolean pooled, RuntimeOptions<?> runtimeOptions) throws JavetException {
        assert (this.getJSRuntimeType().isRuntimeOptionsValid(runtimeOptions));
        if (!this.libraryLoaded) {
            if (this.lastException == null) {
                throw new JavetException(JavetError.LibraryNotLoaded, SimpleMap.of("reason", "there are unknown errors"));
            }
            throw this.lastException;
        }
        long handle = this.v8Native.createV8Runtime(runtimeOptions);
        this.isolateCreated = true;
        V8Runtime v8Runtime = this.jsRuntimeType.isNode() ? new NodeRuntime(this, handle, pooled, this.v8Native, runtimeOptions) : new V8Runtime(this, handle, pooled, this.v8Native, runtimeOptions);
        this.v8Native.registerV8Runtime(handle, v8Runtime);
        this.v8RuntimeMap.put(handle, v8Runtime);
        return (R)v8Runtime;
    }

    public V8Host disableGCNotification() {
        this.v8Notifier.unregisterListener();
        return this;
    }

    public V8Host enableGCNotification() {
        V8Host.setMemoryUsageThreshold();
        this.v8Notifier.registerListeners();
        return this;
    }

    public long[] getInternalStatistic() {
        return this.v8Native.getInternalStatistic();
    }

    public JSRuntimeType getJSRuntimeType() {
        return this.jsRuntimeType;
    }

    public String getJavetVersion() {
        return "3.0.1";
    }

    public JavetException getLastException() {
        return this.lastException;
    }

    public IJavetLogger getLogger() {
        return this.logger;
    }

    IV8Native getV8Native() {
        return this.v8Native;
    }

    public int getV8RuntimeCount() {
        return this.v8RuntimeMap.size();
    }

    public V8SharedMemoryStatistics getV8SharedMemoryStatistics() {
        return (V8SharedMemoryStatistics)this.v8Native.getV8SharedMemoryStatistics();
    }

    public boolean isIsolateCreated() {
        return this.isolateCreated;
    }

    public boolean isLibraryLoaded() {
        return this.libraryLoaded;
    }

    public synchronized boolean loadLibrary() {
        if (!this.libraryLoaded) {
            try {
                this.logger.logDebug("[{0}] Loading library.", this.jsRuntimeType.getName());
                this.javetClassLoader = new JavetClassLoader(this.getClass().getClassLoader(), this.jsRuntimeType);
                this.javetClassLoader.load();
                this.v8Native = this.javetClassLoader.getNative();
                this.libraryLoaded = true;
                this.isolateCreated = false;
            }
            catch (JavetException e) {
                this.logger.logError(e, "Failed to load Javet lib with error {0}.", e.getMessage());
                this.lastException = e;
            }
        }
        return this.libraryLoaded;
    }

    public synchronized boolean unloadLibrary() {
        if (this.libraryLoaded && this.v8RuntimeMap.isEmpty()) {
            this.logger.logDebug("[{0}] Unloading library.", this.jsRuntimeType.getName());
            this.isolateCreated = false;
            this.v8Native = null;
            this.javetClassLoader = null;
            System.gc();
            System.runFinalization();
            this.libraryLoaded = false;
            this.lastException = null;
        }
        return !this.libraryLoaded;
    }

    private static class V8InstanceHolder {
        private static final V8Host INSTANCE = new V8Host(JSRuntimeType.V8);

        private V8InstanceHolder() {
        }
    }

    private static class NodeInstanceHolder {
        private static final V8Host INSTANCE = new V8Host(JSRuntimeType.Node);

        private NodeInstanceHolder() {
        }
    }
}

