/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import java.util.Map;

public final class SimpleFreeMarkerFormat {
    public static final String STRING_NULL = "<null>";
    private static final char CHAR_DOLLAR = '$';
    private static final char CHAR_VARIABLE_CLOSE = '}';
    private static final char CHAR_VARIABLE_OPEN = '{';

    public static String format(String format, Map<String, Object> parameters) {
        if (format == null || format.length() == 0 || parameters == null || parameters.isEmpty()) {
            return format;
        }
        int length = format.length();
        StringBuilder stringBuilderMessage = new StringBuilder();
        StringBuilder stringBuilderVariable = new StringBuilder();
        State state = State.Text;
        block22: for (int i = 0; i < length; ++i) {
            char c = format.charAt(i);
            switch (c) {
                case '$': {
                    switch (state) {
                        case Text: {
                            state = State.Dollar;
                            break;
                        }
                        case Dollar: {
                            state = State.Text;
                            stringBuilderMessage.append('$').append(c);
                            break;
                        }
                        case Variable: {
                            stringBuilderVariable.append(c);
                        }
                    }
                    continue block22;
                }
                case '{': {
                    switch (state) {
                        case Dollar: {
                            state = State.Variable;
                            continue block22;
                        }
                        case Variable: {
                            stringBuilderVariable.append(c);
                            continue block22;
                        }
                    }
                    state = State.Text;
                    stringBuilderMessage.append(c);
                    continue block22;
                }
                case '}': {
                    if (state == State.Variable) {
                        String variableName = stringBuilderVariable.toString();
                        Object parameter = parameters.get(variableName);
                        if (parameter == null) {
                            parameter = STRING_NULL;
                        }
                        stringBuilderMessage.append(parameter);
                        stringBuilderVariable.setLength(0);
                        state = State.Text;
                        continue block22;
                    }
                    stringBuilderMessage.append(c);
                    continue block22;
                }
                default: {
                    switch (state) {
                        case Dollar: {
                            state = State.Text;
                            stringBuilderMessage.append('$').append(c);
                            continue block22;
                        }
                        case Variable: {
                            stringBuilderVariable.append(c);
                            continue block22;
                        }
                    }
                    stringBuilderMessage.append(c);
                }
            }
        }
        switch (state) {
            case Dollar: {
                stringBuilderMessage.append('$');
                break;
            }
            case Variable: {
                stringBuilderMessage.append('$').append('{').append((CharSequence)stringBuilderVariable);
            }
        }
        return stringBuilderMessage.toString();
    }

    static enum State {
        Text,
        Dollar,
        Variable;

    }
}

