/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.Objects;

public class V8ValueWeakSet
extends V8ValueObject {
    V8ValueWeakSet(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    public void add(IV8ValueObject key) throws JavetException {
        Objects.requireNonNull(key);
        this.invokeVoid("add", key);
    }

    @Override
    public boolean delete(Object key) throws JavetException {
        Objects.requireNonNull(key);
        if (!(key instanceof IV8ValueObject)) {
            throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", key.toString()));
        }
        this.invokeVoid("delete", key);
        return true;
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.WeakSet;
    }

    @Override
    public boolean has(Object key) throws JavetException {
        Objects.requireNonNull(key);
        if (!(key instanceof IV8ValueObject)) {
            throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", key.toString()));
        }
        return this.invokeBoolean("has", key);
    }
}

