/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy.plugins;

import com.caoccao.javet.entities.JavetEntityPropertyDescriptor;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetEntityPropertyDescriptor;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.plugins.BaseJavetProxyPluginSingle;
import com.caoccao.javet.utils.ArrayUtils;
import com.caoccao.javet.utils.SimpleList;
import com.caoccao.javet.utils.SimpleSet;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.virtual.V8VirtualIterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class JavetProxyPluginSet
extends BaseJavetProxyPluginSingle<Set<Object>> {
    public static final String NAME = Set.class.getName();
    protected static final String ADD = "add";
    protected static final String CLEAR = "clear";
    protected static final String DELETE = "delete";
    protected static final String ENTRIES = "entries";
    protected static final String ERROR_TARGET_OBJECT_MUST_BE_AN_INSTANCE_OF_SET = "Target object must be an instance of Set.";
    protected static final String FOR_EACH = "forEach";
    protected static final String HAS = "has";
    protected static final String KEYS = "keys";
    protected static final String OBJECT_SET = "[object Set]";
    protected static final String SIZE = "size";
    protected static final String[] DEFAULT_PROXYABLE_METHODS = new String[]{"add", "clear", "forEach", "size", "toString"};
    protected static final String VALUES = "values";
    private static final JavetProxyPluginSet instance = new JavetProxyPluginSet();
    protected final Set<String> proxyableMethods = SimpleSet.of(DEFAULT_PROXYABLE_METHODS);

    public JavetProxyPluginSet() {
        this.proxyGetByStringMap.put(ADD, this::add);
        this.proxyGetByStringMap.put(CLEAR, this::clear);
        this.proxyGetByStringMap.put(DELETE, this::delete);
        this.proxyGetByStringMap.put(ENTRIES, this::entries);
        this.proxyGetByStringMap.put(FOR_EACH, this::forEach);
        this.proxyGetByStringMap.put(HAS, this::has);
        this.proxyGetByStringMap.put(KEYS, this::values);
        this.proxyGetByStringMap.put(SIZE, this::size);
        this.proxyGetByStringMap.put("toJSON", this::toJSON);
        this.proxyGetByStringMap.put("toString", this::toString);
        this.proxyGetByStringMap.put("valueOf", this::valueOf);
        this.proxyGetByStringMap.put(VALUES, this::values);
        this.proxyGetBySymbolMap.put("Symbol.iterator", this::values);
    }

    public static JavetProxyPluginSet getInstance() {
        return instance;
    }

    public V8Value add(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(ADD, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginSet.lambda$add$fe1790a4$1((Set)set, v8Runtime, arg_0, arg_1)));
    }

    public V8Value clear(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(CLEAR, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginSet.lambda$clear$ef6e1705$1((Set)set, v8Runtime, arg_0)));
    }

    @Override
    protected V8Value createTargetObject(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return v8Runtime.createV8ValueSet();
    }

    public V8Value delete(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(DELETE, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginSet.lambda$delete$ef6e1705$1((Set)set, v8Runtime, arg_0)));
    }

    public V8Value entries(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        List entries = set.stream().map(o -> SimpleList.of(o, o)).collect(Collectors.toList());
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(ENTRIES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(entries.iterator()))));
    }

    public V8Value forEach(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(FOR_EACH, targetObject, JavetCallbackType.DirectCallThisAndResult, (arg_0, arg_1) -> JavetProxyPluginSet.lambda$forEach$d2edeea4$1(v8Runtime, (Set)set, arg_0, arg_1)));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Object[] getProxyOwnKeys(Object targetObject) {
        Object set = this.validateTargetObject(targetObject);
        return set.toArray();
    }

    @Override
    public <T> IJavetEntityPropertyDescriptor<T> getProxyOwnPropertyDescriptor(Object targetObject, Object propertyName) {
        return new JavetEntityPropertyDescriptor(true, true, true);
    }

    public V8Value has(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        return v8Runtime.createV8ValueFunction(new JavetCallbackContext(HAS, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginSet.lambda$has$ef6e1705$1((Set)set, v8Runtime, arg_0)));
    }

    @Override
    public boolean hasByObject(Object targetObject, Object propertyKey) {
        Object set = this.validateTargetObject(targetObject);
        return set.contains(propertyKey);
    }

    @Override
    public boolean isHasSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isMethodProxyable(String methodName, Class<?> targetClass) {
        return this.proxyableMethods.contains(methodName);
    }

    @Override
    public boolean isOwnKeysSupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public boolean isProxyable(Class<?> targetClass) {
        return targetClass != null && Set.class.isAssignableFrom(targetClass);
    }

    @Override
    public boolean isUniqueKeySupported(Class<?> targetClass) {
        return true;
    }

    @Override
    public void populateUniqueKeys(Set<String> uniqueKeySet, Object targetObject) {
        Object set = this.validateTargetObject(targetObject);
        set.stream().map(Object::toString).filter(Objects::nonNull).forEach(Objects.requireNonNull(uniqueKeySet)::add);
    }

    public V8Value size(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueInteger(set.size());
    }

    public V8Value toJSON(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("toJSON", targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> v8Runtime.createV8ValueObject()));
    }

    public V8Value toString(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("toString", targetObject, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> v8Runtime.createV8ValueString(OBJECT_SET)));
    }

    @Override
    protected Set<Object> validateTargetObject(Object targetObject) {
        assert (targetObject instanceof Set) : "Target object must be an instance of Set.";
        return (Set)targetObject;
    }

    public V8Value valueOf(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext("valueOf", targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginSet.lambda$valueOf$c4447505$1(v8Runtime, (Set)set, arg_0)));
    }

    public V8Value values(V8Runtime v8Runtime, Object targetObject) throws JavetException {
        Object set = this.validateTargetObject(targetObject);
        return Objects.requireNonNull(v8Runtime).createV8ValueFunction(new JavetCallbackContext(VALUES, targetObject, JavetCallbackType.DirectCallNoThisAndResult, arg_0 -> JavetProxyPluginSet.lambda$values$c4447505$1(v8Runtime, (Set)set, arg_0)));
    }

    private static /* synthetic */ V8Value lambda$values$c4447505$1(V8Runtime v8Runtime, Set set, V8Value[] v8Values) throws JavetException, Exception {
        return PROXY_CONVERTER.toV8Value(v8Runtime, new V8VirtualIterator(set.iterator()));
    }

    private static /* synthetic */ V8Value lambda$valueOf$c4447505$1(V8Runtime v8Runtime, Set set, V8Value[] v8Values) throws JavetException, Exception {
        return V8ValueUtils.createV8ValueSet(v8Runtime, set.toArray());
    }

    private static /* synthetic */ V8Value lambda$has$ef6e1705$1(Set set, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        boolean result = false;
        if (ArrayUtils.isNotEmpty(v8Values)) {
            result = set.contains(v8Runtime.toObject(v8Values[0]));
        }
        return v8Runtime.createV8ValueBoolean(result);
    }

    private static /* synthetic */ V8Value lambda$forEach$d2edeea4$1(V8Runtime v8Runtime, Set set, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        V8ValueFunction v8ValueFunction = V8ValueUtils.asV8ValueFunctionWithError(v8Runtime, v8Values, 0);
        if (v8ValueFunction != null) {
            V8ValueObject v8ValueObject = V8ValueUtils.asV8ValueObject(v8Values, 1);
            for (Object key : set) {
                Object v8ValueResult = v8ValueFunction.call((V8Value)v8ValueObject, key, key, thisObject);
                Throwable throwable = null;
                if (v8ValueResult == null) continue;
                if (throwable != null) {
                    try {
                        ((V8Value)v8ValueResult).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                ((V8Value)v8ValueResult).close();
            }
        }
        return v8Runtime.createV8ValueUndefined();
    }

    private static /* synthetic */ V8Value lambda$delete$ef6e1705$1(Set set, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        boolean removed = false;
        if (ArrayUtils.isNotEmpty(v8Values)) {
            removed = set.remove(v8Runtime.toObject(v8Values[0]));
        }
        return v8Runtime.createV8ValueBoolean(removed);
    }

    private static /* synthetic */ V8Value lambda$clear$ef6e1705$1(Set set, V8Runtime v8Runtime, V8Value[] v8Values) throws JavetException, Exception {
        set.clear();
        return v8Runtime.createV8ValueUndefined();
    }

    private static /* synthetic */ V8Value lambda$add$fe1790a4$1(Set set, V8Runtime v8Runtime, V8Value thisObject, V8Value[] v8Values) throws JavetException, Exception {
        if (ArrayUtils.isNotEmpty(v8Values)) {
            set.add(v8Runtime.toObject(v8Values[0]));
        }
        return thisObject;
    }
}

