/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueTypedArray;
import com.caoccao.javet.values.reference.V8ValueArrayBuffer;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.virtual.V8VirtualValue;
import java.util.Objects;

public class V8ValueTypedArray
extends V8ValueObject
implements IV8ValueTypedArray {
    public static final String PROPERTY_BYTE_LENGTH = "byteLength";
    public static final String PROPERTY_BUFFER = "buffer";
    public static final String PROPERTY_BYTE_OFFSET = "byteOffset";
    public static final String PROPERTY_NAME = "Name";
    public static final int ONE_BYTE_PER_VALUE = 1;
    public static final int TWO_BYTES_PER_VALUE = 2;
    public static final int FOUR_BYTES_PER_VALUE = 4;
    public static final int EIGHT_BYTES_PER_VALUE = 8;
    public static final int ZERO_BYTE_PER_VALUE = 0;
    protected int sizeInBytes;
    protected V8ValueReferenceType type;

    V8ValueTypedArray(V8Runtime v8Runtime, long handle, int type) throws JavetException {
        super(v8Runtime, handle);
        this.setType(V8ValueReferenceType.parse(type));
    }

    public boolean fromBytes(byte[] bytes) throws JavetException {
        Objects.requireNonNull(bytes);
        if (this.getType() == V8ValueReferenceType.Int8Array || this.getType() == V8ValueReferenceType.Uint8Array || this.getType() == V8ValueReferenceType.Uint8ClampedArray) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                boolean bl = v8ValueArrayBuffer.fromBytes(bytes);
                return bl;
            }
        }
        return false;
    }

    public boolean fromDoubles(double[] doubles) throws JavetException {
        Objects.requireNonNull(doubles);
        if (this.getType() == V8ValueReferenceType.Float64Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                boolean bl = v8ValueArrayBuffer.fromDoubles(doubles);
                return bl;
            }
        }
        return false;
    }

    public boolean fromFloats(float[] floats) throws JavetException {
        Objects.requireNonNull(floats);
        if (this.getType() == V8ValueReferenceType.Float32Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                boolean bl = v8ValueArrayBuffer.fromFloats(floats);
                return bl;
            }
        }
        return false;
    }

    public boolean fromIntegers(int[] integers) throws JavetException {
        Objects.requireNonNull(integers);
        if (this.getType() == V8ValueReferenceType.Int32Array || this.getType() == V8ValueReferenceType.Uint32Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                boolean bl = v8ValueArrayBuffer.fromIntegers(integers);
                return bl;
            }
        }
        return false;
    }

    public boolean fromLongs(long[] longs) throws JavetException {
        Objects.requireNonNull(longs);
        if (this.getType() == V8ValueReferenceType.BigInt64Array || this.getType() == V8ValueReferenceType.BigUint64Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                boolean bl = v8ValueArrayBuffer.fromLongs(longs);
                return bl;
            }
        }
        return false;
    }

    public boolean fromShorts(short[] shorts) throws JavetException {
        Objects.requireNonNull(shorts);
        if (this.getType() == V8ValueReferenceType.Int16Array || this.getType() == V8ValueReferenceType.Uint16Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                boolean bl = v8ValueArrayBuffer.fromShorts(shorts);
                return bl;
            }
        }
        return false;
    }

    @Override
    public <T extends V8Value> T get(Object key) throws JavetException {
        try (V8VirtualValue virtualKey = new V8VirtualValue(this.checkV8Runtime(), OBJECT_CONVERTER, Objects.requireNonNull(key));){
            Object t = this.v8Runtime.getV8Internal().objectGet(this, (V8Value)virtualKey.get());
            return t;
        }
    }

    @Override
    public V8ValueArrayBuffer getBuffer() throws JavetException {
        return (V8ValueArrayBuffer)this.get(PROPERTY_BUFFER);
    }

    @Override
    public int getByteLength() throws JavetException {
        return this.getInteger(PROPERTY_BYTE_LENGTH);
    }

    @Override
    public int getByteOffset() throws JavetException {
        return this.getInteger(PROPERTY_BYTE_OFFSET);
    }

    @Override
    public int getLength() throws JavetException {
        return this.checkV8Runtime().getV8Internal().arrayGetLength(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public V8ValueReferenceType getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        return this.type != V8ValueReferenceType.Invalid;
    }

    protected void setType(V8ValueReferenceType type) {
        switch (type) {
            case Int8Array: 
            case Uint8Array: 
            case Uint8ClampedArray: {
                this.sizeInBytes = 1;
                break;
            }
            case Int16Array: 
            case Uint16Array: {
                this.sizeInBytes = 2;
                break;
            }
            case Int32Array: 
            case Uint32Array: 
            case Float32Array: {
                this.sizeInBytes = 4;
                break;
            }
            case Float64Array: 
            case BigInt64Array: 
            case BigUint64Array: {
                this.sizeInBytes = 8;
                break;
            }
            default: {
                type = V8ValueReferenceType.Invalid;
                this.sizeInBytes = 0;
            }
        }
        this.type = type;
    }

    public byte[] toBytes() throws JavetException {
        if (this.getType() == V8ValueReferenceType.Int8Array || this.getType() == V8ValueReferenceType.Uint8Array || this.getType() == V8ValueReferenceType.Uint8ClampedArray) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                byte[] byArray = v8ValueArrayBuffer.toBytes();
                return byArray;
            }
        }
        return null;
    }

    public double[] toDoubles() throws JavetException {
        if (this.getType() == V8ValueReferenceType.Float64Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                double[] dArray = v8ValueArrayBuffer.toDoubles();
                return dArray;
            }
        }
        return null;
    }

    public float[] toFloats() throws JavetException {
        if (this.getType() == V8ValueReferenceType.Float32Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                float[] fArray = v8ValueArrayBuffer.toFloats();
                return fArray;
            }
        }
        return null;
    }

    public int[] toIntegers() throws JavetException {
        if (this.getType() == V8ValueReferenceType.Int32Array || this.getType() == V8ValueReferenceType.Uint32Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                int[] nArray = v8ValueArrayBuffer.toIntegers();
                return nArray;
            }
        }
        return null;
    }

    public long[] toLongs() throws JavetException {
        if (this.getType() == V8ValueReferenceType.BigInt64Array || this.getType() == V8ValueReferenceType.BigUint64Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                long[] lArray = v8ValueArrayBuffer.toLongs();
                return lArray;
            }
        }
        return null;
    }

    public short[] toShorts() throws JavetException {
        if (this.getType() == V8ValueReferenceType.Int16Array || this.getType() == V8ValueReferenceType.Uint16Array) {
            try (V8ValueArrayBuffer v8ValueArrayBuffer = this.getBuffer();){
                short[] sArray = v8ValueArrayBuffer.toShorts();
                return sArray;
            }
        }
        return null;
    }
}

