/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetUniConsumer;
import com.caoccao.javet.interfaces.IJavetUniIndexedConsumer;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.reference.IV8ValueObject;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public interface IV8ValueArray
extends IV8ValueObject {
    public int batchGet(V8Value[] var1, int var2, int var3) throws JavetException;

    default public <T extends V8Value> T[] batchGet() throws JavetException {
        int length = this.getLength();
        Object[] v8Values = new V8Value[length];
        if (length > 0) {
            try {
                this.batchGet((V8Value[])v8Values, 0, length);
            }
            catch (Throwable t) {
                JavetResourceUtils.safeClose((V8Value[])v8Values);
                Arrays.fill(v8Values, null);
                throw t;
            }
        }
        return v8Values;
    }

    public <Value extends V8Value, E extends Throwable> int forEach(IJavetUniConsumer<Value, E> var1, int var2) throws JavetException, E;

    public <Value extends V8Value, E extends Throwable> int forEach(IJavetUniIndexedConsumer<Value, E> var1, int var2) throws JavetException, E;

    public <T extends V8Value> T get(int var1) throws JavetException;

    public List<Integer> getKeys() throws JavetException;

    public int getLength() throws JavetException;

    public <T extends V8Value> T pop() throws JavetException;

    default public BigInteger popBigInteger() throws JavetException {
        return (BigInteger)this.popPrimitive();
    }

    default public Boolean popBoolean() throws JavetException {
        return (Boolean)this.popPrimitive();
    }

    default public Double popDouble() throws JavetException {
        return (Double)this.popPrimitive();
    }

    default public Integer popInteger() throws JavetException {
        return (Integer)this.popPrimitive();
    }

    default public Long popLong() throws JavetException {
        return (Long)this.popPrimitive();
    }

    default public V8ValueNull popNull() throws JavetException {
        return (V8ValueNull)this.pop();
    }

    default public <T> T popObject() throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.pop(), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R popPrimitive() throws JavetException {
        try (T v8Value = this.pop();){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public String popString() throws JavetException {
        return (String)this.popPrimitive();
    }

    default public V8ValueUndefined popUndefined() throws JavetException {
        return (V8ValueUndefined)this.pop();
    }

    public int push(Object ... var1) throws JavetException;

    default public int pushNull() throws JavetException {
        return this.push(this.getV8Runtime().createV8ValueNull());
    }

    default public int pushUndefined() throws JavetException {
        return this.push(this.getV8Runtime().createV8ValueUndefined());
    }

    default public V8Value[] toArray() throws JavetException {
        return this.batchGet();
    }
}

