/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.IV8Convertible;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import java.math.BigInteger;
import java.time.ZonedDateTime;

public interface IV8Executable
extends IV8Convertible {
    default public <T extends V8Value> T execute() throws JavetException {
        return this.execute(true);
    }

    public <T extends V8Value> T execute(boolean var1) throws JavetException;

    default public BigInteger executeBigInteger() throws JavetException {
        return (BigInteger)this.executePrimitive();
    }

    default public Boolean executeBoolean() throws JavetException {
        return (Boolean)this.executePrimitive();
    }

    default public Double executeDouble() throws JavetException {
        return (Double)this.executePrimitive();
    }

    default public Integer executeInteger() throws JavetException {
        return (Integer)this.executePrimitive();
    }

    default public Long executeLong() throws JavetException {
        return (Long)this.executePrimitive();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T executeObject() throws JavetException {
        try (T v8Value = this.execute();){
            Object t = this.toObject(v8Value);
            return t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R executePrimitive() throws JavetException {
        try (T v8Value = this.execute();){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable throwable6) {
            return null;
        }
    }

    default public String executeString() throws JavetException {
        return (String)this.executePrimitive();
    }

    default public void executeVoid() throws JavetException {
        this.execute(false);
    }

    default public ZonedDateTime executeZonedDateTime() throws JavetException {
        return (ZonedDateTime)this.executePrimitive();
    }
}

