/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.enums.V8ConversionMode;
import com.caoccao.javet.enums.V8ProxyMode;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.binding.ClassDescriptor;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.BaseJavetReflectionProxyHandler;
import com.caoccao.javet.interop.proxy.IJavetReflectionObjectFactory;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.ThreadSafeMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;

public class JavetReflectionProxyClassHandler<T extends Class<?>, E extends Exception>
extends BaseJavetReflectionProxyHandler<T, E> {
    protected static final String METHOD_NAME_CONSTRUCTOR = "constructor";
    protected static final ThreadSafeMap<Class<?>, ClassDescriptor> classDescriptorMap = new ThreadSafeMap();

    public JavetReflectionProxyClassHandler(V8Runtime v8Runtime, IJavetReflectionObjectFactory reflectionObjectFactory, T targetObject) {
        super(v8Runtime, reflectionObjectFactory, targetObject);
    }

    @Override
    public V8Value construct(V8Value target, V8ValueArray arguments, V8Value newTarget) throws JavetException {
        if (!this.classDescriptor.getConstructors().isEmpty()) {
            V8Value[] v8Values = null;
            try {
                v8Values = arguments.toArray();
                Object v = this.v8Runtime.toV8Value(JavetReflectionProxyClassHandler.execute(this.reflectionObjectFactory, null, (V8ValueObject)target, this.classDescriptor.getConstructors(), V8ValueUtils.convertToVirtualObjects(v8Values)));
                return v;
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", METHOD_NAME_CONSTRUCTOR, "message", t.getMessage()), t);
            }
            finally {
                if (v8Values != null) {
                    JavetResourceUtils.safeClose(v8Values);
                }
            }
        }
        return this.v8Runtime.createV8ValueUndefined();
    }

    @Override
    public V8Value get(V8Value target, V8Value property, V8Value receiver) throws JavetException {
        V8Value result = this.getFromField(property);
        result = result == null ? this.getFromMethod(target, property) : result;
        result = result == null ? this.getFromGetter(property) : result;
        return result == null ? this.v8Runtime.createV8ValueUndefined() : result;
    }

    @Override
    public JavetCallbackContext[] getCallbackContexts() {
        if (this.callbackContexts == null) {
            this.callbackContexts = new JavetCallbackContext[]{new JavetCallbackContext("construct", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.construct(v8Values[0], (V8ValueArray)v8Values[1], v8Values[2])), new JavetCallbackContext("get", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.get(v8Values[0], v8Values[1], v8Values[2])), new JavetCallbackContext("has", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.has(v8Values[0], v8Values[1])), new JavetCallbackContext("ownKeys", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.ownKeys(v8Values[0])), new JavetCallbackContext("set", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.set(v8Values[0], v8Values[1], v8Values[2], v8Values[3]))};
        }
        return this.callbackContexts;
    }

    @Override
    public ThreadSafeMap<Class<?>, ClassDescriptor> getClassDescriptorCache() {
        return classDescriptorMap;
    }

    @Override
    public V8ValueBoolean has(V8Value target, V8Value property) throws JavetException {
        boolean isFound = this.hasFromRegular(property);
        isFound = isFound || this.hasFromGeneric(property);
        return this.v8Runtime.createV8ValueBoolean(isFound);
    }

    @Override
    protected void initialize() {
        this.classDescriptor = classDescriptorMap.get((Class<?>)this.targetObject);
        if (this.classDescriptor == null) {
            this.classDescriptor = new ClassDescriptor(V8ProxyMode.Class, (Class)this.targetObject);
            Class<?> targetClass = ((Class)this.targetObject).getClass();
            this.initializeFieldsAndMethods((Class)this.targetObject, true);
            this.initializeFieldsAndMethods(targetClass, false);
            classDescriptorMap.put((Class<?>)this.targetObject, this.classDescriptor);
        }
    }

    protected void initializeFieldsAndMethods(Class<?> currentClass, boolean staticMode) {
        V8ConversionMode conversionMode = this.classDescriptor.getConversionMode();
        if (staticMode) {
            this.initializeConstructors(currentClass, conversionMode);
        }
        do {
            this.initializePublicFields(currentClass, conversionMode, staticMode);
            this.initializePublicMethods(currentClass, conversionMode, staticMode);
        } while (currentClass != Object.class && (currentClass = currentClass.getSuperclass()) != null);
    }

    @Override
    public V8ValueArray ownKeys(V8Value target) throws JavetException {
        return (V8ValueArray)this.v8Runtime.toV8Value(this.classDescriptor.getUniqueKeySet().toArray());
    }

    @Override
    public V8ValueBoolean set(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException {
        boolean isSet = this.setToField(propertyKey, propertyValue);
        isSet = isSet || this.setToSetter(target, propertyKey, propertyValue);
        return this.v8Runtime.createV8ValueBoolean(isSet);
    }
}

