/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.annotations.V8Allow;
import com.caoccao.javet.annotations.V8Block;
import com.caoccao.javet.annotations.V8Function;
import com.caoccao.javet.annotations.V8Getter;
import com.caoccao.javet.annotations.V8Property;
import com.caoccao.javet.annotations.V8ProxyFunctionApply;
import com.caoccao.javet.annotations.V8Setter;
import com.caoccao.javet.enums.V8ConversionMode;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.binding.ClassDescriptor;
import com.caoccao.javet.interop.proxy.BaseJavetProxyHandler;
import com.caoccao.javet.interop.proxy.IJavetReflectionObjectFactory;
import com.caoccao.javet.interop.proxy.JavetProxySymbolToPrimitiveConverter;
import com.caoccao.javet.interop.proxy.JavetReflectionProxyInterceptor;
import com.caoccao.javet.interop.proxy.ScoredExecutable;
import com.caoccao.javet.utils.JavetReflectionUtils;
import com.caoccao.javet.utils.JavetTypeUtils;
import com.caoccao.javet.utils.JavetVirtualObject;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.ThreadSafeMap;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class BaseJavetReflectionProxyHandler<T, E extends Exception>
extends BaseJavetProxyHandler<T, E> {
    protected static final String[] GETTER_PREFIX_ARRAY = new String[]{"get", "is"};
    protected static final Pattern PATTERN_CAPITALIZED_PREFIX = Pattern.compile("^[A-Z]+");
    protected static final String[] SETTER_PREFIX_ARRAY = new String[]{"set", "put"};
    protected ClassDescriptor classDescriptor;
    protected IJavetReflectionObjectFactory reflectionObjectFactory;

    public BaseJavetReflectionProxyHandler(V8Runtime v8Runtime, IJavetReflectionObjectFactory reflectionObjectFactory, T targetObject) {
        super(v8Runtime, targetObject);
        this.reflectionObjectFactory = reflectionObjectFactory;
        this.initialize();
    }

    protected static <E extends AccessibleObject> Object execute(IJavetReflectionObjectFactory reflectionObjectFactory, Object targetObject, V8ValueObject thisObject, List<E> executables, JavetVirtualObject[] javetVirtualObjects) throws Throwable {
        ArrayList<ScoredExecutable> scoredExecutables = new ArrayList<ScoredExecutable>();
        for (AccessibleObject executable : executables) {
            ScoredExecutable scoredExecutable = new ScoredExecutable(reflectionObjectFactory, targetObject, thisObject, executable, javetVirtualObjects);
            scoredExecutable.calculateScore();
            double score = scoredExecutable.getScore();
            if (!(score > 0.0)) continue;
            scoredExecutables.add(scoredExecutable);
        }
        if (!scoredExecutables.isEmpty()) {
            scoredExecutables.sort((o1, o2) -> Double.compare(o2.getScore(), o1.getScore()));
            Throwable lastException = null;
            for (ScoredExecutable scoredExecutable : scoredExecutables) {
                try {
                    return scoredExecutable.execute();
                }
                catch (Throwable t) {
                    lastException = t;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }
        return null;
    }

    protected void addMethod(Method method, int startIndex, Map<String, List<Method>> map) {
        if (method.isAnnotationPresent(V8Function.class)) {
            String methodName = method.getName();
            String aliasMethodName = method.getAnnotation(V8Function.class).name();
            if (aliasMethodName.length() > 0) {
                methodName = aliasMethodName;
            }
            List methods = map.computeIfAbsent(methodName, k -> new ArrayList());
            methods.add(method);
        } else {
            String methodName = method.getName();
            String aliasMethodName = methodName.substring(startIndex);
            Matcher matcher = PATTERN_CAPITALIZED_PREFIX.matcher(aliasMethodName);
            if (matcher.find()) {
                int capitalizedPrefixLength = matcher.group().length();
                if (capitalizedPrefixLength == 1) {
                    aliasMethodName = methodName.substring(startIndex, startIndex + capitalizedPrefixLength).toLowerCase(Locale.ROOT) + methodName.substring(startIndex + capitalizedPrefixLength);
                    List methods = map.computeIfAbsent(aliasMethodName, k -> new ArrayList());
                    methods.add(method);
                } else {
                    for (int i = 1; i < capitalizedPrefixLength; ++i) {
                        aliasMethodName = methodName.substring(startIndex, startIndex + i).toLowerCase(Locale.ROOT) + methodName.substring(startIndex + i);
                        List methods = map.computeIfAbsent(aliasMethodName, k -> new ArrayList());
                        methods.add(method);
                    }
                }
            } else {
                List methods = map.computeIfAbsent(aliasMethodName, k -> new ArrayList());
                methods.add(method);
            }
        }
    }

    public abstract ThreadSafeMap<Class<?>, ClassDescriptor> getClassDescriptorCache();

    protected V8Value getFromField(V8Value property) throws JavetException {
        if (!this.classDescriptor.getFieldMap().isEmpty() && property instanceof V8ValueString) {
            String propertyName = ((V8ValueString)property).toPrimitive();
            Field field = this.classDescriptor.getFieldMap().get(propertyName);
            if (field != null) {
                try {
                    Object callee = Modifier.isStatic(field.getModifiers()) ? null : this.targetObject;
                    Object value = field.get(callee);
                    if (value != null) {
                        return this.v8Runtime.toV8Value(value);
                    }
                }
                catch (JavetException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
                }
            }
        }
        return null;
    }

    protected V8Value getFromGetter(V8Value property) throws JavetException {
        if (!this.classDescriptor.getGenericGetters().isEmpty()) {
            try {
                Object propertyObject = this.v8Runtime.toObject(property);
                if (propertyObject != null && !(propertyObject instanceof V8Value)) {
                    for (Method method : this.classDescriptor.getGenericGetters()) {
                        Object callee;
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class<?> parameterType = parameterTypes[0];
                        Object key = null;
                        if (V8Value.class.isAssignableFrom(parameterType) && parameterType.isAssignableFrom(property.getClass())) {
                            key = property;
                        }
                        if (key == null && parameterType.isAssignableFrom(propertyObject.getClass())) {
                            key = propertyObject;
                        }
                        if (key == null && parameterType.isPrimitive()) {
                            key = JavetTypeUtils.toExactPrimitive(parameterType, propertyObject);
                        }
                        if (key == null) {
                            key = JavetTypeUtils.toApproximatePrimitive(parameterType, propertyObject);
                        }
                        if (key == null) continue;
                        Object object = callee = Modifier.isStatic(method.getModifiers()) ? null : this.targetObject;
                        Object value = method.invoke(callee, key);
                        if (value == null) continue;
                        return this.v8Runtime.toV8Value(value);
                    }
                }
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
            }
        }
        return null;
    }

    protected V8Value getFromMethod(V8Value target, V8Value property) throws JavetException {
        if (property instanceof V8ValueString) {
            String propertyName = ((V8ValueString)property).toPrimitive();
            List<Method> methods = this.classDescriptor.getMethodsMap().get(propertyName);
            if (methods != null && !methods.isEmpty()) {
                JavetReflectionProxyInterceptor reflectionProxyInterceptor = new JavetReflectionProxyInterceptor(this.reflectionObjectFactory, this.targetObject, propertyName, methods);
                return this.v8Runtime.createV8ValueFunction(reflectionProxyInterceptor.getCallbackContext());
            }
            methods = this.classDescriptor.getGettersMap().get(propertyName);
            if (methods != null && !methods.isEmpty()) {
                JavetReflectionProxyInterceptor reflectionProxyInterceptor = new JavetReflectionProxyInterceptor(this.reflectionObjectFactory, this.targetObject, propertyName, methods);
                return this.v8Runtime.toV8Value(reflectionProxyInterceptor.invoke((V8ValueObject)target, new V8Value[0]));
            }
            if ("toV8Value".equals(propertyName)) {
                return new JavetProxySymbolToPrimitiveConverter<Object>(this.v8Runtime, this.targetObject).getV8ValueFunction();
            }
        }
        return null;
    }

    protected int getGetterPrefixLength(Method method) {
        String methodName = method.getName();
        for (String prefix : GETTER_PREFIX_ARRAY) {
            if (!methodName.startsWith(prefix) || methodName.length() <= prefix.length() || method.getParameterCount() != 0) continue;
            return prefix.length();
        }
        return 0;
    }

    protected int getSetterPrefixLength(Method method) {
        String methodName = method.getName();
        for (String prefix : SETTER_PREFIX_ARRAY) {
            if (!methodName.startsWith(prefix) || methodName.length() <= prefix.length() || method.getParameterCount() != 1) continue;
            return prefix.length();
        }
        return 0;
    }

    protected boolean hasFromGeneric(V8Value property) throws JavetException {
        if (!this.classDescriptor.getGenericGetters().isEmpty()) {
            try {
                Object propertyObject = this.v8Runtime.toObject(property);
                if (propertyObject != null && !(propertyObject instanceof V8Value)) {
                    for (Method method : this.classDescriptor.getGenericGetters()) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class<?> parameterType = parameterTypes[0];
                        Object key = null;
                        if (V8Value.class.isAssignableFrom(parameterType) && parameterType.isAssignableFrom(property.getClass())) {
                            key = property;
                        }
                        if (key == null && parameterType.isAssignableFrom(propertyObject.getClass())) {
                            key = propertyObject;
                        }
                        if (key == null && parameterType.isPrimitive()) {
                            key = JavetTypeUtils.toExactPrimitive(parameterType, propertyObject);
                        }
                        if (key == null) {
                            key = JavetTypeUtils.toApproximatePrimitive(parameterType, propertyObject);
                        }
                        if (key == null) continue;
                        Object callee = Modifier.isStatic(method.getModifiers()) ? null : this.targetObject;
                        try {
                            return method.invoke(callee, key) != null;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean hasFromRegular(V8Value property) {
        if (property instanceof V8ValueString) {
            String propertyName = ((V8ValueString)property).toPrimitive();
            return this.classDescriptor.getFieldMap().containsKey(propertyName) || this.classDescriptor.getMethodsMap().containsKey(propertyName) || this.classDescriptor.getGettersMap().containsKey(propertyName) || this.classDescriptor.getSettersMap().containsKey(propertyName);
        }
        return false;
    }

    protected abstract void initialize();

    protected void initializeConstructors(Class<?> currentClass, V8ConversionMode conversionMode) {
        for (Constructor<?> constructor : currentClass.getConstructors()) {
            if (!this.isAllowed(conversionMode, constructor)) continue;
            this.classDescriptor.getConstructors().add(constructor);
        }
    }

    protected void initializePublicFields(Class<?> currentClass, V8ConversionMode conversionMode, boolean staticMode) {
        for (Field field : currentClass.getFields()) {
            String aliasFieldName;
            int fieldModifiers = field.getModifiers();
            if (staticMode && !Modifier.isStatic(fieldModifiers) || !Modifier.isPublic(fieldModifiers) || !this.isAllowed(conversionMode, field)) continue;
            String fieldName = field.getName();
            if (field.isAnnotationPresent(V8Property.class) && (aliasFieldName = field.getAnnotation(V8Property.class).name()).length() > 0) {
                fieldName = aliasFieldName;
            }
            if (this.classDescriptor.getFieldMap().containsKey(fieldName)) continue;
            JavetReflectionUtils.safeSetAccessible(field);
            this.classDescriptor.getFieldMap().put(fieldName, field);
            if (this.classDescriptor.isTargetTypeMap() || this.classDescriptor.isTargetTypeSet()) continue;
            this.classDescriptor.getUniqueKeySet().add(fieldName);
        }
    }

    protected void initializePublicMethods(Class<?> currentClass, V8ConversionMode conversionMode, boolean staticMode) {
        for (Method method : currentClass.getMethods()) {
            int methodModifiers = method.getModifiers();
            if (staticMode && !Modifier.isStatic(methodModifiers) || !Modifier.isPublic(methodModifiers) || !this.isAllowed(conversionMode, method)) continue;
            JavetReflectionUtils.safeSetAccessible(method);
            if (this.isGenericGetter(method)) {
                this.classDescriptor.getGenericGetters().add(method);
            } else if (this.isGenericSetter(method)) {
                this.classDescriptor.getGenericSetters().add(method);
            } else if (this.isApplyFunction(method)) {
                this.classDescriptor.getApplyFunctions().add(method);
            } else {
                int getterPrefixLength = this.getGetterPrefixLength(method);
                if (getterPrefixLength > 0) {
                    String aliasMethodName;
                    Matcher matcher;
                    this.addMethod(method, getterPrefixLength, this.classDescriptor.getGettersMap());
                    if (!this.classDescriptor.isTargetTypeMap() && !this.classDescriptor.isTargetTypeSet() && (matcher = PATTERN_CAPITALIZED_PREFIX.matcher(aliasMethodName = method.getName().substring(getterPrefixLength))).find()) {
                        int capitalizedPrefixLength = matcher.group().length();
                        if (capitalizedPrefixLength == 1) {
                            this.classDescriptor.getUniqueKeySet().add(aliasMethodName.substring(0, capitalizedPrefixLength).toLowerCase(Locale.ROOT) + aliasMethodName.substring(capitalizedPrefixLength));
                        } else {
                            this.classDescriptor.getUniqueKeySet().add(aliasMethodName.substring(0, capitalizedPrefixLength - 1).toLowerCase(Locale.ROOT) + aliasMethodName.substring(capitalizedPrefixLength - 1));
                        }
                    }
                } else {
                    int setterPrefixLength = this.getSetterPrefixLength(method);
                    if (setterPrefixLength > 0) {
                        this.addMethod(method, setterPrefixLength, this.classDescriptor.getSettersMap());
                    }
                }
            }
            this.addMethod(method, 0, this.classDescriptor.getMethodsMap());
        }
    }

    protected boolean isAllowed(V8ConversionMode conversionMode, AccessibleObject accessibleObject) {
        switch (conversionMode) {
            case AllowOnly: {
                return accessibleObject.isAnnotationPresent(V8Allow.class);
            }
            case BlockOnly: {
                return !accessibleObject.isAnnotationPresent(V8Block.class);
            }
        }
        return true;
    }

    protected boolean isApplyFunction(Method method) {
        return method.isAnnotationPresent(V8ProxyFunctionApply.class);
    }

    protected boolean isGenericGetter(Method method) {
        if (method.isAnnotationPresent(V8Getter.class)) {
            return true;
        }
        String methodName = method.getName();
        for (String prefix : GETTER_PREFIX_ARRAY) {
            if (!methodName.equals(prefix) || method.getParameterCount() != 1 || method.isVarArgs()) continue;
            return true;
        }
        return false;
    }

    protected boolean isGenericSetter(Method method) {
        if (method.isAnnotationPresent(V8Setter.class)) {
            return true;
        }
        String methodName = method.getName();
        for (String prefix : SETTER_PREFIX_ARRAY) {
            if (!methodName.equals(prefix) || method.getParameterCount() != 2 || method.isVarArgs()) continue;
            return true;
        }
        return false;
    }

    protected boolean setToField(V8Value propertyKey, V8Value propertyValue) throws JavetException {
        if (!this.classDescriptor.getFieldMap().isEmpty() && propertyKey instanceof V8ValueString) {
            int fieldModifiers;
            String propertyName = ((V8ValueString)propertyKey).toPrimitive();
            Field field = this.classDescriptor.getFieldMap().get(propertyName);
            if (field != null && !Modifier.isFinal(fieldModifiers = field.getModifiers())) {
                try {
                    Object callee = Modifier.isStatic(fieldModifiers) ? null : this.targetObject;
                    field.set(callee, this.v8Runtime.toObject(propertyValue));
                    return true;
                }
                catch (JavetException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
                }
            }
        }
        return false;
    }

    protected boolean setToSetter(V8Value target, V8Value propertyKey, V8Value propertyValue) throws JavetException {
        if (!this.classDescriptor.getGenericSetters().isEmpty() || !this.classDescriptor.getSettersMap().isEmpty()) {
            Object valueObject;
            Object keyObject;
            try {
                keyObject = this.v8Runtime.toObject(propertyKey);
                valueObject = this.v8Runtime.toObject(propertyValue);
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
            }
            if (!this.classDescriptor.getGenericSetters().isEmpty() && keyObject != null && !(keyObject instanceof V8Value)) {
                try {
                    for (Method method : this.classDescriptor.getGenericSetters()) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class<?> keyParameterType = parameterTypes[0];
                        Class<?> valueParameterType = parameterTypes[1];
                        Object key = null;
                        Object value = null;
                        if (V8Value.class.isAssignableFrom(keyParameterType) && keyParameterType.isAssignableFrom(propertyKey.getClass())) {
                            key = propertyKey;
                        }
                        if (V8Value.class.isAssignableFrom(valueParameterType) && valueParameterType.isAssignableFrom(propertyValue.getClass())) {
                            value = propertyValue;
                        }
                        if (key == null && keyParameterType.isAssignableFrom(keyObject.getClass())) {
                            key = keyObject;
                        }
                        if (value == null && valueParameterType.isAssignableFrom(valueObject.getClass())) {
                            value = valueObject;
                        }
                        if (key == null && keyParameterType.isPrimitive()) {
                            key = JavetTypeUtils.toExactPrimitive(keyParameterType, keyObject);
                        }
                        if (value == null && valueParameterType.isPrimitive()) {
                            value = JavetTypeUtils.toExactPrimitive(valueParameterType, valueObject);
                        }
                        if (key == null) {
                            key = JavetTypeUtils.toApproximatePrimitive(keyParameterType, keyObject);
                        }
                        if (value == null) {
                            value = JavetTypeUtils.toApproximatePrimitive(valueParameterType, valueObject);
                        }
                        if (key == null) continue;
                        Object callee = Modifier.isStatic(method.getModifiers()) ? null : this.targetObject;
                        method.invoke(callee, key, value);
                        return true;
                    }
                }
                catch (Throwable t) {
                    throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
                }
            }
            if (keyObject instanceof String) {
                String propertyName = (String)keyObject;
                List<Method> methods = this.classDescriptor.getSettersMap().get(propertyName);
                if (methods != null) {
                    JavetReflectionProxyInterceptor reflectionProxyInterceptor = new JavetReflectionProxyInterceptor(this.reflectionObjectFactory, this.targetObject, propertyName, methods);
                    reflectionProxyInterceptor.invoke((V8ValueObject)target, propertyValue);
                    return true;
                }
            }
        }
        return false;
    }
}

