/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.loader;

import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.interop.loader.IJavetLibLoadingListener;
import com.caoccao.javet.utils.JavetOSUtils;
import java.io.File;

public final class JavetLibLoadingListener
implements IJavetLibLoadingListener {
    public static final String JAVET_LIB_LOADING_TYPE_DEFAULT = "default";
    public static final String JAVET_LIB_LOADING_TYPE_CUSTOM = "custom";
    public static final String JAVET_LIB_LOADING_TYPE_SYSTEM = "system";
    public static final String PROPERTY_KEY_JAVET_LIB_LOADING_PATH = "javet.lib.loading.path";
    public static final String PROPERTY_KEY_JAVET_LIB_LOADING_TYPE = "javet.lib.loading.type";
    public static final String PROPERTY_KEY_JAVET_LIB_LOADING_SUPPRESS_ERROR = "javet.lib.loading.suppress.error";
    private static final String TEMP_ROOT_NAME = "javet";
    private final String javetLibLoadingPath = System.getProperty("javet.lib.loading.path");
    private final String javetLibLoadingSuppressError = System.getProperty("javet.lib.loading.suppress.error", null);
    private final String javetLibLoadingType = System.getProperty("javet.lib.loading.type", "default");

    @Override
    public File getLibPath(JSRuntimeType jsRuntimeType) {
        if (this.javetLibLoadingPath == null) {
            return new File(JavetOSUtils.TEMP_DIRECTORY, TEMP_ROOT_NAME);
        }
        return new File(this.javetLibLoadingPath);
    }

    @Override
    public boolean isDeploy(JSRuntimeType jsRuntimeType) {
        if (JavetOSUtils.IS_ANDROID) {
            return false;
        }
        if (JAVET_LIB_LOADING_TYPE_SYSTEM.equals(this.javetLibLoadingType)) {
            return false;
        }
        return !JAVET_LIB_LOADING_TYPE_CUSTOM.equals(this.javetLibLoadingType);
    }

    @Override
    public boolean isLibInSystemPath(JSRuntimeType jsRuntimeType) {
        if (JavetOSUtils.IS_ANDROID) {
            return true;
        }
        return JAVET_LIB_LOADING_TYPE_SYSTEM.equals(this.javetLibLoadingType);
    }

    @Override
    public boolean isSuppressingError(JSRuntimeType jsRuntimeType) {
        if (JavetOSUtils.IS_ANDROID) {
            return true;
        }
        return this.javetLibLoadingSuppressError != null;
    }
}

