/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.node.modules;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.node.modules.INodeModule;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.Objects;

public abstract class BaseNodeModule
implements INodeModule {
    protected V8ValueObject moduleObject;
    protected String name;

    public BaseNodeModule(V8ValueObject moduleObject, String name) {
        this.moduleObject = Objects.requireNonNull(moduleObject);
        this.name = name;
    }

    @Override
    public void close() throws JavetException {
        JavetResourceUtils.safeClose((Object)this.moduleObject);
        this.moduleObject = null;
    }

    @Override
    public V8ValueObject getModuleObject() {
        return this.moduleObject;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isClosed() {
        return this.moduleObject == null || this.moduleObject.isClosed();
    }
}

