/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.enums.V8ConversionMode;
import com.caoccao.javet.enums.V8ProxyMode;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.interop.binding.ClassDescriptor;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.BaseJavetReflectionProxyHandler;
import com.caoccao.javet.interop.proxy.IJavetReflectionObjectFactory;
import com.caoccao.javet.interop.proxy.JavetProxySymbolIterableConverter;
import com.caoccao.javet.interop.proxy.JavetProxySymbolToPrimitiveConverter;
import com.caoccao.javet.utils.JavetStringUtils;
import com.caoccao.javet.utils.ThreadSafeMap;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JavetReflectionProxyObjectHandler<T, E extends Exception>
extends BaseJavetReflectionProxyHandler<T, E> {
    protected static final String FUNCTION_NAME_LENGTH = "length";
    protected static final ThreadSafeMap<Class<?>, ClassDescriptor> classDescriptorMap = new ThreadSafeMap();

    public JavetReflectionProxyObjectHandler(V8Runtime v8Runtime, IJavetReflectionObjectFactory reflectionObjectFactory, T targetObject) {
        super(v8Runtime, reflectionObjectFactory, Objects.requireNonNull(targetObject));
    }

    @Override
    public V8Value get(V8Value target, V8Value property, V8Value receiver) throws JavetException {
        V8Value result = this.getFromCollection(property);
        result = result == null ? this.getFromField(property) : result;
        result = result == null ? this.getFromMethod(target, property) : result;
        result = result == null ? this.getFromSymbol(property) : result;
        result = result == null ? this.getFromGetter(property) : result;
        return result == null ? this.v8Runtime.createV8ValueUndefined() : result;
    }

    @Override
    public JavetCallbackContext[] getCallbackContexts() {
        if (this.callbackContexts == null) {
            this.callbackContexts = new JavetCallbackContext[]{new JavetCallbackContext("get", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.get(v8Values[0], v8Values[1], v8Values[2])), new JavetCallbackContext("has", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.has(v8Values[0], v8Values[1])), new JavetCallbackContext("ownKeys", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.ownKeys(v8Values[0])), new JavetCallbackContext("set", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.set(v8Values[0], v8Values[1], v8Values[2], v8Values[3]))};
        }
        return this.callbackContexts;
    }

    @Override
    public ThreadSafeMap<Class<?>, ClassDescriptor> getClassDescriptorCache() {
        return classDescriptorMap;
    }

    protected V8Value getFromCollection(V8Value property) throws JavetException {
        if (property instanceof V8ValueString) {
            String propertyString = ((V8ValueString)property).toPrimitive();
            if (JavetStringUtils.isDigital(propertyString)) {
                int index = Integer.parseInt(propertyString);
                if (index >= 0) {
                    List list;
                    if (this.classDescriptor.getTargetClass().isArray()) {
                        if (index < Array.getLength(this.targetObject)) {
                            return this.v8Runtime.toV8Value(Array.get(this.targetObject, index));
                        }
                    } else if (List.class.isAssignableFrom(this.classDescriptor.getTargetClass()) && index < (list = (List)this.targetObject).size()) {
                        return this.v8Runtime.toV8Value(list.get(index));
                    }
                }
            } else if (this.classDescriptor.getTargetClass().isArray() && FUNCTION_NAME_LENGTH.equals(propertyString)) {
                return this.v8Runtime.toV8Value(Array.getLength(this.targetObject));
            }
        }
        return null;
    }

    protected V8Value getFromSymbol(V8Value property) throws JavetException {
        if (property instanceof V8ValueSymbol) {
            V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
            String description = propertySymbol.getDescription();
            if ("Symbol.toPrimitive".equals(description)) {
                return new JavetProxySymbolToPrimitiveConverter<Object>(this.v8Runtime, this.targetObject).getV8ValueFunction();
            }
            if ("Symbol.iterator".equals(description) && (this.targetObject instanceof Iterable || this.classDescriptor.getTargetClass().isArray())) {
                return new JavetProxySymbolIterableConverter<Object>(this.v8Runtime, this.targetObject).getV8ValueFunction();
            }
        }
        return null;
    }

    @Override
    public V8ValueBoolean has(V8Value target, V8Value property) throws JavetException {
        boolean isFound = this.hasFromCollection(property);
        isFound = isFound || this.hasFromRegular(property);
        isFound = isFound || this.hasFromGeneric(property);
        return this.v8Runtime.createV8ValueBoolean(isFound);
    }

    protected boolean hasFromCollection(V8Value property) throws JavetException {
        int index;
        String indexString;
        if (this.classDescriptor.isTargetTypeMap()) {
            return ((Map)this.targetObject).containsKey(this.v8Runtime.toObject(property));
        }
        if (this.classDescriptor.isTargetTypeSet()) {
            return ((Set)this.targetObject).contains(this.v8Runtime.toObject(property));
        }
        if (property instanceof V8ValueString && JavetStringUtils.isDigital(indexString = ((V8ValueString)property).toPrimitive()) && (index = Integer.parseInt(indexString)) >= 0) {
            if (this.classDescriptor.getTargetClass().isArray()) {
                return index < Array.getLength(this.targetObject);
            }
            if (List.class.isAssignableFrom(this.classDescriptor.getTargetClass())) {
                return index < ((List)this.targetObject).size();
            }
        }
        return false;
    }

    @Override
    protected void initialize() {
        Class<?> targetClass = this.targetObject.getClass();
        this.classDescriptor = classDescriptorMap.get(targetClass);
        if (this.classDescriptor == null) {
            this.classDescriptor = new ClassDescriptor(V8ProxyMode.Object, targetClass);
            if (this.targetObject instanceof Class) {
                this.initializeFieldsAndMethods((Class)this.targetObject, true);
            }
            this.initializeCollection();
            this.initializeFieldsAndMethods(targetClass, false);
            classDescriptorMap.put(targetClass, this.classDescriptor);
        }
    }

    protected void initializeCollection() {
        if (this.classDescriptor.isTargetTypeMap()) {
            ((Map)this.targetObject).keySet().stream().map(Object::toString).filter(Objects::nonNull).forEach(this.classDescriptor.getUniqueKeySet()::add);
        } else if (this.classDescriptor.isTargetTypeSet()) {
            ((Set)this.targetObject).stream().map(Object::toString).filter(Objects::nonNull).forEach(this.classDescriptor.getUniqueKeySet()::add);
        }
    }

    protected void initializeFieldsAndMethods(Class<?> currentClass, boolean staticMode) {
        V8ConversionMode conversionMode = this.classDescriptor.getConversionMode();
        do {
            this.initializePublicFields(currentClass, conversionMode, staticMode);
            this.initializePublicMethods(currentClass, conversionMode, staticMode);
        } while (currentClass != Object.class && (currentClass = currentClass.getSuperclass()) != null);
    }

    @Override
    public V8ValueArray ownKeys(V8Value target) throws JavetException {
        Object[] keys = null;
        if (this.classDescriptor.isTargetTypeMap()) {
            keys = ((Map)this.targetObject).keySet().toArray();
        } else if (this.classDescriptor.isTargetTypeSet()) {
            keys = ((Set)this.targetObject).toArray();
        } else if (this.classDescriptor.getTargetClass().isArray() || Collection.class.isAssignableFrom(this.classDescriptor.getTargetClass())) {
            int length = this.classDescriptor.getTargetClass().isArray() ? Array.getLength(this.targetObject) : ((List)this.targetObject).size();
            keys = new Object[length];
            for (int i = 0; i < length; ++i) {
                keys[i] = i;
            }
        }
        if (keys != null && keys.length > 0) {
            try (V8Scope v8Scope = this.v8Runtime.getV8Scope();){
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                for (Object key : keys) {
                    if (key instanceof String) {
                        v8ValueArray.push(this.v8Runtime.createV8ValueString((String)key));
                        continue;
                    }
                    if (key instanceof V8ValueString || key instanceof V8ValueSymbol) {
                        v8ValueArray.push(key);
                        continue;
                    }
                    if (key == null) continue;
                    v8ValueArray.push(this.v8Runtime.createV8ValueString(key.toString()));
                }
                v8Scope.setEscapable();
                V8ValueArray v8ValueArray2 = v8ValueArray;
                return v8ValueArray2;
            }
        }
        return (V8ValueArray)this.v8Runtime.toV8Value(this.classDescriptor.getUniqueKeySet().toArray());
    }

    @Override
    public V8ValueBoolean set(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException {
        boolean isSet = this.setToCollection(propertyKey, propertyValue);
        isSet = isSet || this.setToField(propertyKey, propertyValue);
        isSet = isSet || this.setToSetter(target, propertyKey, propertyValue);
        return this.v8Runtime.createV8ValueBoolean(isSet);
    }

    protected boolean setToCollection(V8Value propertyKey, V8Value propertyValue) throws JavetException {
        int index;
        String indexString;
        if (propertyKey instanceof V8ValueString && JavetStringUtils.isDigital(indexString = ((V8ValueString)propertyKey).toPrimitive()) && (index = Integer.parseInt(indexString)) >= 0) {
            List list;
            if (this.classDescriptor.getTargetClass().isArray()) {
                if (index < Array.getLength(this.targetObject)) {
                    Array.set(this.targetObject, index, this.v8Runtime.toObject(propertyValue));
                    return true;
                }
            } else if (List.class.isAssignableFrom(this.classDescriptor.getTargetClass()) && index < (list = (List)this.targetObject).size()) {
                list.set(index, this.v8Runtime.toObject(propertyValue));
                return true;
            }
        }
        return false;
    }
}

