/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.interop.proxy.IJavetReflectionObjectFactory;
import com.caoccao.javet.interop.proxy.JavetReflectionProxyObjectHandler;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueArray;

public class JavetReflectionProxyFunctionHandler<T, E extends Exception>
extends JavetReflectionProxyObjectHandler<T, E> {
    protected static final String METHOD_NAME_APPLY = "apply";

    public JavetReflectionProxyFunctionHandler(V8Runtime v8Runtime, IJavetReflectionObjectFactory reflectionObjectFactory, T targetObject) {
        super(v8Runtime, reflectionObjectFactory, targetObject);
    }

    @Override
    public V8Value apply(V8Value target, V8Value thisObject, V8ValueArray arguments) throws JavetException {
        if (!this.classDescriptor.getApplyFunctions().isEmpty()) {
            V8Value[] v8Values = null;
            try {
                v8Values = arguments.toArray();
                Object v = this.v8Runtime.toV8Value(JavetReflectionProxyFunctionHandler.execute(this.reflectionObjectFactory, this.targetObject, null, this.classDescriptor.getApplyFunctions(), V8ValueUtils.convertToVirtualObjects(v8Values)));
                return v;
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", METHOD_NAME_APPLY, "message", t.getMessage()), t);
            }
            finally {
                if (v8Values != null) {
                    JavetResourceUtils.safeClose(v8Values);
                }
            }
        }
        return this.v8Runtime.createV8ValueUndefined();
    }

    @Override
    public JavetCallbackContext[] getCallbackContexts() {
        if (this.callbackContexts == null) {
            this.callbackContexts = new JavetCallbackContext[]{new JavetCallbackContext(METHOD_NAME_APPLY, (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.apply(v8Values[0], v8Values[1], (V8ValueArray)v8Values[2])), new JavetCallbackContext("get", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.get(v8Values[0], v8Values[1], v8Values[2])), new JavetCallbackContext("has", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.has(v8Values[0], v8Values[1])), new JavetCallbackContext("ownKeys", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.ownKeys(v8Values[0])), new JavetCallbackContext("set", (Object)this, JavetCallbackType.DirectCallNoThisAndResult, v8Values -> this.set(v8Values[0], v8Values[1], v8Values[2], v8Values[3]))};
        }
        return this.callbackContexts;
    }
}

