/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.enums.V8ValueSymbolType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetBiFunction;
import com.caoccao.javet.interfaces.IJavetUniFunction;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetCallbackType;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import java.util.Map;

public interface IJavetDirectProxyHandler<E extends Exception> {
    public V8Runtime getV8Runtime();

    default public V8Value proxyApply(V8Value target, V8Value thisObject, V8ValueArray arguments) throws JavetException, E {
        return this.getV8Runtime().createV8ValueUndefined();
    }

    default public V8Value proxyGet(V8Value target, V8Value property, V8Value receiver) throws JavetException, E {
        if (property instanceof V8ValueString) {
            IJavetUniFunction<String, V8Value, E> getter;
            String propertyString = ((V8ValueString)property).toPrimitive();
            Map<String, IJavetUniFunction<String, V8Value, E>> stringGetterMap = this.proxyGetStringGetterMap();
            if (stringGetterMap != null && !stringGetterMap.isEmpty() && (getter = stringGetterMap.get(propertyString)) != null) {
                return getter.apply(propertyString);
            }
            if ("toV8Value".equals(propertyString)) {
                return this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext("Symbol.toPrimitive", V8ValueSymbolType.BuiltIn, JavetCallbackType.DirectCallNoThisAndResult, this::symbolToPrimitive));
            }
        } else if (property instanceof V8ValueSymbol) {
            IJavetUniFunction<V8ValueSymbol, V8Value, E> getter;
            V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
            String description = propertySymbol.getDescription();
            Map<String, IJavetUniFunction<V8ValueSymbol, V8Value, E>> symbolGetterMap = this.proxyGetSymbolGetterMap();
            if (symbolGetterMap != null && !symbolGetterMap.isEmpty() && (getter = symbolGetterMap.get(description)) != null) {
                return getter.apply(propertySymbol);
            }
            if ("Symbol.toPrimitive".equals(description)) {
                return this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext("Symbol.toPrimitive", V8ValueSymbolType.BuiltIn, JavetCallbackType.DirectCallNoThisAndResult, this::symbolToPrimitive));
            }
            if ("Symbol.iterator".equals(description)) {
                return this.getV8Runtime().createV8ValueFunction(new JavetCallbackContext("Symbol.iterator", V8ValueSymbolType.BuiltIn, JavetCallbackType.DirectCallNoThisAndResult, this::symbolIterator));
            }
        }
        return this.getV8Runtime().createV8ValueUndefined();
    }

    default public Map<String, IJavetUniFunction<String, ? extends V8Value, E>> proxyGetStringGetterMap() {
        return null;
    }

    default public Map<String, IJavetBiFunction<String, V8Value, Boolean, E>> proxyGetStringSetterMap() {
        return null;
    }

    default public Map<String, IJavetUniFunction<V8ValueSymbol, ? extends V8Value, E>> proxyGetSymbolGetterMap() {
        return null;
    }

    default public Map<String, IJavetBiFunction<V8ValueSymbol, V8Value, Boolean, E>> proxyGetSymbolSetterMap() {
        return null;
    }

    default public V8ValueBoolean proxyHas(V8Value target, V8Value property) throws JavetException, E {
        boolean hasProperty = false;
        if (property instanceof V8ValueString) {
            String propertyString = ((V8ValueString)property).toPrimitive();
            Map<String, IJavetUniFunction<String, V8Value, E>> stringGetterMap = this.proxyGetStringGetterMap();
            if (stringGetterMap != null && !stringGetterMap.isEmpty()) {
                hasProperty = stringGetterMap.containsKey(propertyString);
            }
        }
        if (!hasProperty && property instanceof V8ValueSymbol) {
            V8ValueSymbol propertySymbol = (V8ValueSymbol)property;
            String description = propertySymbol.getDescription();
            Map<String, IJavetUniFunction<V8ValueSymbol, V8Value, E>> symbolGetterMap = this.proxyGetSymbolGetterMap();
            if (symbolGetterMap != null && !symbolGetterMap.isEmpty()) {
                hasProperty = symbolGetterMap.containsKey(description);
            }
        }
        return this.getV8Runtime().createV8ValueBoolean(hasProperty);
    }

    default public V8ValueArray proxyOwnKeys(V8Value target) throws JavetException, E {
        try (V8Scope v8Scope = this.getV8Runtime().getV8Scope();){
            V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
            Map<String, IJavetUniFunction<String, V8Value, E>> stringGetterMap = this.proxyGetStringGetterMap();
            if (stringGetterMap != null && !stringGetterMap.isEmpty()) {
                V8ValueString[] v8ValueStrings = new V8ValueString[stringGetterMap.size()];
                int index = 0;
                for (String key : stringGetterMap.keySet()) {
                    v8ValueStrings[index++] = this.getV8Runtime().createV8ValueString(key);
                }
                v8ValueArray.push(v8ValueStrings);
            }
            v8Scope.setEscapable();
            V8ValueArray v8ValueArray2 = v8ValueArray;
            return v8ValueArray2;
        }
    }

    default public V8ValueBoolean proxySet(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException, E {
        boolean isSet = false;
        if (propertyKey instanceof V8ValueString) {
            IJavetBiFunction<String, V8Value, Boolean, E> setter;
            String propertyKeyString = ((V8ValueString)propertyKey).toPrimitive();
            Map<String, IJavetBiFunction<String, V8Value, Boolean, E>> stringSetterMap = this.proxyGetStringSetterMap();
            if (stringSetterMap != null && !stringSetterMap.isEmpty() && (setter = stringSetterMap.get(propertyKeyString)) != null) {
                isSet = setter.apply(propertyKeyString, propertyValue);
            }
        }
        if (!isSet && propertyKey instanceof V8ValueSymbol) {
            IJavetBiFunction<V8ValueSymbol, V8Value, Boolean, E> setter;
            V8ValueSymbol propertyKeySymbol = (V8ValueSymbol)propertyKey;
            String description = propertyKeySymbol.getDescription();
            Map<String, IJavetBiFunction<V8ValueSymbol, V8Value, Boolean, E>> symbolSetterMap = this.proxyGetSymbolSetterMap();
            if (symbolSetterMap != null && !symbolSetterMap.isEmpty() && (setter = symbolSetterMap.get(description)) != null) {
                isSet = setter.apply(propertyKeySymbol, propertyValue);
            }
        }
        return this.getV8Runtime().createV8ValueBoolean(isSet);
    }

    default public void setV8Runtime(V8Runtime v8Runtime) {
    }

    default public V8Value symbolIterator(V8Value ... v8Values) throws JavetException, E {
        return this.getV8Runtime().createV8ValueUndefined();
    }

    default public V8Value symbolToPrimitive(V8Value ... v8Values) throws JavetException, E {
        return this.getV8Runtime().createV8ValueNull();
    }
}

