/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import com.caoccao.javet.interfaces.IJavaFunction;
import com.caoccao.javet.interfaces.IJavaSupplier;
import com.caoccao.javet.interop.options.NodeRuntimeOptions;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.interop.options.V8RuntimeOptions;
import java.util.Objects;

public enum JSRuntimeType {
    Node("node", "10.2.154.26-node.26", NodeRuntimeOptions::new, o -> o instanceof NodeRuntimeOptions),
    V8("v8", "11.4.183.14", V8RuntimeOptions::new, o -> o instanceof V8RuntimeOptions);

    private final String name;
    private final IJavaSupplier<? extends RuntimeOptions<?>> runtimeOptionsConstructor;
    private final IJavaFunction<RuntimeOptions<?>, Boolean> runtimeOptionsValidator;
    private final String version;

    private JSRuntimeType(String name, String version, IJavaSupplier<RuntimeOptions<?>> runtimeOptionsConstructor, IJavaFunction<RuntimeOptions<?>, Boolean> runtimeOptionsValidator) {
        this.runtimeOptionsConstructor = Objects.requireNonNull(runtimeOptionsConstructor);
        this.runtimeOptionsValidator = Objects.requireNonNull(runtimeOptionsValidator);
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public <Options extends RuntimeOptions<?>> Options getRuntimeOptions() {
        return (Options)this.runtimeOptionsConstructor.get();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isNode() {
        return this == Node;
    }

    public boolean isRuntimeOptionsValid(RuntimeOptions<?> runtimeOptions) {
        return this.runtimeOptionsValidator.apply(runtimeOptions);
    }

    public boolean isV8() {
        return this == V8;
    }

    public String toString() {
        return this.name + " v" + this.version;
    }
}

