/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.proxy.JavetDynamicProxyV8ValueFunctionInvocationHandler;
import com.caoccao.javet.interop.proxy.JavetDynamicProxyV8ValueObjectInvocationHandler;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public final class JavetDynamicProxyFactory {
    private static final JavetDynamicProxyFactory instance = new JavetDynamicProxyFactory();

    private JavetDynamicProxyFactory() {
    }

    public static JavetDynamicProxyFactory getInstance() {
        return instance;
    }

    public boolean isSupportedFunction(Class<?> type, V8Value v8Value) {
        return type.isInterface() && v8Value instanceof V8ValueFunction;
    }

    public boolean isSupportedObject(Class<?> type, V8Value v8Value) {
        return type.isInterface() && v8Value instanceof V8ValueObject && !(v8Value instanceof V8ValueProxy) && !(v8Value instanceof V8ValueFunction);
    }

    public Object toObject(Class<?> type, V8Value v8Value) throws JavetException {
        if (type.isInterface()) {
            if (v8Value instanceof V8ValueFunction) {
                JavetDynamicProxyV8ValueFunctionInvocationHandler invocationHandler = new JavetDynamicProxyV8ValueFunctionInvocationHandler((V8ValueFunction)v8Value.toClone());
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type, AutoCloseable.class}, (InvocationHandler)invocationHandler);
            }
            if (v8Value instanceof V8ValueObject && !(v8Value instanceof V8ValueProxy)) {
                JavetDynamicProxyV8ValueObjectInvocationHandler invocationHandler = new JavetDynamicProxyV8ValueObjectInvocationHandler((V8ValueObject)v8Value.toClone());
                return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type, AutoCloseable.class}, (InvocationHandler)invocationHandler);
            }
        }
        return null;
    }
}

