/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetBiConsumer;
import com.caoccao.javet.interfaces.IJavetBiIndexedConsumer;
import com.caoccao.javet.interfaces.IJavetUniConsumer;
import com.caoccao.javet.interfaces.IJavetUniIndexedConsumer;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueIterator;
import com.caoccao.javet.values.reference.IV8ValueMap;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.Objects;

public class V8ValueMap
extends V8ValueObject
implements IV8ValueMap {
    protected static final String FUNCTION_ENTRIES = "entries";
    protected static final String FUNCTION_KEYS = "keys";
    protected static final String FUNCTION_VALUES = "values";

    V8ValueMap(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    @Override
    public <Key extends V8Value, E extends Throwable> int forEach(IJavetUniConsumer<Key, E> consumer) throws JavetException, E {
        Objects.requireNonNull(consumer);
        int count = 0;
        try (IV8ValueIterator<? extends V8Value> iterator = this.getKeys();){
            while (true) {
                try (V8Value key = iterator.getNext();){
                    if (key == null) break;
                    consumer.accept(key);
                }
                ++count;
            }
        }
        return count;
    }

    @Override
    public <Key extends V8Value, E extends Throwable> int forEach(IJavetUniIndexedConsumer<Key, E> consumer) throws JavetException, E {
        Objects.requireNonNull(consumer);
        int count = 0;
        try (IV8ValueIterator<? extends V8Value> iterator = this.getKeys();){
            while (true) {
                try (V8Value key = iterator.getNext();){
                    if (key == null) break;
                    consumer.accept(count, key);
                }
                ++count;
            }
        }
        return count;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <Key extends V8Value, Value extends V8Value, E extends Throwable> int forEach(IJavetBiConsumer<Key, Value, E> consumer) throws JavetException, E {
        Objects.requireNonNull(consumer);
        int count = 0;
        try (IV8ValueIterator<V8ValueArray> iterator = this.getEntries();){
            Throwable throwable;
            V8ValueArray entry;
            while (true) {
                block52: {
                    block49: {
                        block50: {
                            entry = iterator.getNext();
                            throwable = null;
                            if (entry != null) break block49;
                            if (entry == null) return count;
                            if (throwable == null) break block50;
                            try {
                                entry.close();
                                return count;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return count;
                            }
                        }
                        entry.close();
                        return count;
                    }
                    try (Object key = entry.get(0);
                         Object value = entry.get(1);){
                        consumer.accept(key, value);
                    }
                    ++count;
                    if (entry == null) continue;
                    if (throwable == null) break block52;
                    try {
                        entry.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                entry.close();
            }
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (entry == null) throw throwable5;
                    if (throwable != null) {
                        try {
                            entry.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                    entry.close();
                    throw throwable5;
                }
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <Key extends V8Value, Value extends V8Value, E extends Throwable> int forEach(IJavetBiIndexedConsumer<Key, Value, E> consumer) throws JavetException, E {
        Objects.requireNonNull(consumer);
        int count = 0;
        try (IV8ValueIterator<V8ValueArray> iterator = this.getEntries();){
            Throwable throwable;
            V8ValueArray entry;
            while (true) {
                block52: {
                    block49: {
                        block50: {
                            entry = iterator.getNext();
                            throwable = null;
                            if (entry != null) break block49;
                            if (entry == null) return count;
                            if (throwable == null) break block50;
                            try {
                                entry.close();
                                return count;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return count;
                            }
                        }
                        entry.close();
                        return count;
                    }
                    try (Object key = entry.get(0);
                         Object value = entry.get(1);){
                        consumer.accept(count, key, value);
                    }
                    ++count;
                    if (entry == null) continue;
                    if (throwable == null) break block52;
                    try {
                        entry.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                entry.close();
            }
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (entry == null) throw throwable5;
                    if (throwable != null) {
                        try {
                            entry.close();
                            throw throwable5;
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                            throw throwable5;
                        }
                    }
                    entry.close();
                    throw throwable5;
                }
            }
        }
    }

    @Override
    public IV8ValueIterator<V8ValueArray> getEntries() throws JavetException {
        return (IV8ValueIterator)this.invoke(FUNCTION_ENTRIES, new V8Value[0]);
    }

    @Override
    public IV8ValueIterator<? extends V8Value> getKeys() throws JavetException {
        return (IV8ValueIterator)this.invoke(FUNCTION_KEYS, new V8Value[0]);
    }

    @Override
    public int getSize() throws JavetException {
        return this.checkV8Runtime().getV8Internal().getSize(this);
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.Map;
    }

    @Override
    public IV8ValueIterator<? extends V8Value> getValues() throws JavetException {
        return (IV8ValueIterator)this.invoke(FUNCTION_VALUES, new V8Value[0]);
    }
}

