/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetUniConsumer;
import com.caoccao.javet.interfaces.IJavetUniIndexedConsumer;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V8ValueArray
extends V8ValueObject
implements IV8ValueArray {
    protected static final String FUNCTION_KEYS = "keys";
    protected static final String FUNCTION_NEXT = "next";
    protected static final String FUNCTION_POP = "pop";
    protected static final String FUNCTION_PUSH = "push";
    protected static final String PROPERTY_DONE = "done";
    protected static final String PROPERTY_VALUE = "value";

    V8ValueArray(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    public <Value extends V8Value, E extends Throwable> int forEach(IJavetUniConsumer<Value, E> consumer) throws JavetException, E {
        Objects.requireNonNull(consumer);
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            try (Object value = this.get(i);){
                consumer.accept(value);
                continue;
            }
        }
        return length;
    }

    public <Value extends V8Value, E extends Throwable> int forEach(IJavetUniIndexedConsumer<Value, E> consumer) throws JavetException, E {
        Objects.requireNonNull(consumer);
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            try (Object value = this.get(i);){
                consumer.accept(i, value);
                continue;
            }
        }
        return length;
    }

    @Override
    public <T extends V8Value> T get(int index) throws JavetException {
        return this.checkV8Runtime().getV8Internal().get(this, this.v8Runtime.createV8ValueInteger(index));
    }

    @Override
    public List<Integer> getKeys() throws JavetException {
        try (V8ValueObject iterator = (V8ValueObject)this.invoke(FUNCTION_KEYS, new V8Value[0]);){
            ArrayList<Integer> keys = new ArrayList<Integer>();
            while (true) {
                V8ValueObject next = (V8ValueObject)iterator.invoke(FUNCTION_NEXT, new V8Value[0]);
                Throwable throwable = null;
                try {
                    if (next.getBoolean(PROPERTY_DONE).booleanValue()) break;
                    keys.add(next.getInteger(PROPERTY_VALUE));
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (next == null) continue;
                    if (throwable != null) {
                        try {
                            next.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    next.close();
                    continue;
                }
                break;
            }
            ArrayList<Integer> arrayList = keys;
            return arrayList;
        }
    }

    @Override
    public int getLength() throws JavetException {
        return this.checkV8Runtime().getV8Internal().getLength(this);
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.Array;
    }

    @Override
    public <T extends V8Value> T pop() throws JavetException {
        return this.invoke(FUNCTION_POP, new V8Value[0]);
    }

    @Override
    public int push(Object value) throws JavetException {
        return this.invokeInteger(FUNCTION_PUSH, value);
    }
}

