/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.reference.V8ValueFunction;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public final class JavetDynamicProxyV8ValueFunctionInvocationHandler
implements InvocationHandler,
IJavetClosable {
    private static final String METHOD_NAME_CLOSE = "close";
    private V8ValueFunction v8ValueFunction;

    public JavetDynamicProxyV8ValueFunctionInvocationHandler(V8ValueFunction v8ValueFunction) {
        this.v8ValueFunction = v8ValueFunction;
    }

    @Override
    public void close() throws JavetException {
        JavetResourceUtils.safeClose((Object)this.v8ValueFunction);
        this.v8ValueFunction = null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        Object result = null;
        if (args == null) {
            args = new Object[]{};
        }
        if ((methodName = method.getName()).equals(METHOD_NAME_CLOSE) && args.length == 0) {
            this.close();
        } else if (this.v8ValueFunction != null && !this.v8ValueFunction.isClosed()) {
            result = this.v8ValueFunction.callObject(null, args);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.v8ValueFunction == null || this.v8ValueFunction.isClosed();
    }
}

