/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.annotations.V8Function;
import com.caoccao.javet.enums.V8ConversionMode;
import com.caoccao.javet.enums.V8ProxyMode;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.binding.ClassDescriptor;
import com.caoccao.javet.interop.proxy.BaseJavetProxyHandler;
import com.caoccao.javet.interop.proxy.IJavetDynamicObjectFactory;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.ThreadSafeMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;

public class JavetDynamicProxyClassHandler<T extends Class<?>>
extends BaseJavetProxyHandler<T> {
    protected static final String METHOD_NAME_CONSTRUCTOR = "constructor";
    protected static final ThreadSafeMap<Class<?>, ClassDescriptor> classDescriptorMap = new ThreadSafeMap();

    public JavetDynamicProxyClassHandler(V8Runtime v8Runtime, IJavetDynamicObjectFactory dynamicObjectFactory, T targetObject) {
        super(v8Runtime, dynamicObjectFactory, targetObject);
    }

    @Override
    @V8Function
    public V8Value construct(V8Value target, V8ValueArray arguments, V8Value newTarget) throws JavetException {
        if (!this.classDescriptor.getConstructors().isEmpty()) {
            V8Value[] v8Values = null;
            try {
                v8Values = arguments.toArray();
                Object v = this.v8Runtime.toV8Value(JavetDynamicProxyClassHandler.execute(this.dynamicObjectFactory, null, (V8ValueObject)target, this.classDescriptor.getConstructors(), V8ValueUtils.convertToVirtualObjects(v8Values)));
                return v;
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", METHOD_NAME_CONSTRUCTOR, "message", t.getMessage()), t);
            }
            finally {
                if (v8Values != null) {
                    JavetResourceUtils.safeClose(v8Values);
                }
            }
        }
        return this.v8Runtime.createV8ValueUndefined();
    }

    @Override
    @V8Function
    public V8Value get(V8Value target, V8Value property, V8Value receiver) throws JavetException {
        V8Value result = this.getFromField(property);
        result = result == null ? this.getFromMethod(target, property) : result;
        result = result == null ? this.getFromGetter(property) : result;
        return result == null ? this.v8Runtime.createV8ValueUndefined() : result;
    }

    @Override
    public ThreadSafeMap<Class<?>, ClassDescriptor> getClassDescriptorCache() {
        return classDescriptorMap;
    }

    @Override
    @V8Function
    public V8ValueBoolean has(V8Value target, V8Value property) throws JavetException {
        boolean isFound = this.hasFromRegular(property);
        isFound = isFound || this.hasFromGeneric(property);
        return this.v8Runtime.createV8ValueBoolean(isFound);
    }

    @Override
    protected void initialize() {
        this.classDescriptor = classDescriptorMap.get((Class<?>)this.targetObject);
        if (this.classDescriptor == null) {
            this.classDescriptor = new ClassDescriptor(V8ProxyMode.Class, (Class)this.targetObject);
            Class<?> targetClass = ((Class)this.targetObject).getClass();
            this.initializeFieldsAndMethods((Class)this.targetObject, true);
            this.initializeFieldsAndMethods(targetClass, false);
            classDescriptorMap.put((Class<?>)this.targetObject, this.classDescriptor);
        }
    }

    protected void initializeFieldsAndMethods(Class<?> currentClass, boolean staticMode) {
        V8ConversionMode conversionMode = this.classDescriptor.getConversionMode();
        if (staticMode) {
            this.initializeConstructors(currentClass, conversionMode);
        }
        do {
            this.initializePublicFields(currentClass, conversionMode, staticMode);
            this.initializePublicMethods(currentClass, conversionMode, staticMode);
        } while (currentClass != Object.class && (currentClass = currentClass.getSuperclass()) != null);
    }

    @Override
    @V8Function
    public V8Value ownKeys(V8Value target) throws JavetException {
        return this.v8Runtime.toV8Value(this.classDescriptor.getUniqueKeySet().toArray());
    }

    @Override
    @V8Function
    public V8ValueBoolean set(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException {
        boolean isSet = this.setToField(propertyKey, propertyValue);
        isSet = isSet || this.setToSetter(target, propertyKey, propertyValue);
        return this.v8Runtime.createV8ValueBoolean(isSet);
    }
}

