/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine.observers;

import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.observers.IV8RuntimeObserver;
import java.util.ArrayList;
import java.util.List;

public class V8RuntimeObserverAverageV8ModuleCount
implements IV8RuntimeObserver<Integer> {
    protected final List<Integer> v8ModuleCountList;

    public V8RuntimeObserverAverageV8ModuleCount() {
        this(256);
    }

    public V8RuntimeObserverAverageV8ModuleCount(int capacity) {
        this.v8ModuleCountList = new ArrayList<Integer>(capacity);
    }

    @Override
    public Integer getResult() {
        int averageV8ModuleCount = 0;
        if (!this.v8ModuleCountList.isEmpty()) {
            int totalV8ModuleCount = 0;
            for (int referenceCount : this.v8ModuleCountList) {
                totalV8ModuleCount += referenceCount;
            }
            int v8RuntimeCount = this.v8ModuleCountList.size();
            averageV8ModuleCount = totalV8ModuleCount / v8RuntimeCount;
        }
        return averageV8ModuleCount;
    }

    @Override
    public boolean observe(V8Runtime v8Runtime) {
        this.v8ModuleCountList.add(v8Runtime.getV8ModuleCount());
        return true;
    }

    @Override
    public void reset() {
        this.v8ModuleCountList.clear();
    }
}

