/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.enums.JSFunctionType;
import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.enums.JSScopeType;
import com.caoccao.javet.enums.JavetPromiseRejectEvent;
import com.caoccao.javet.enums.V8AllocationSpace;
import com.caoccao.javet.enums.V8AwaitMode;
import com.caoccao.javet.enums.V8GCCallbackFlags;
import com.caoccao.javet.enums.V8GCType;
import com.caoccao.javet.enums.V8ValueInternalType;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IEnumBitset;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interfaces.IV8ModuleResolver;
import com.caoccao.javet.interop.IV8Convertible;
import com.caoccao.javet.interop.IV8Creatable;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Inspector;
import com.caoccao.javet.interop.V8Internal;
import com.caoccao.javet.interop.V8Locker;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.interop.V8ScriptOrigin;
import com.caoccao.javet.interop.callback.IJavetGCCallback;
import com.caoccao.javet.interop.callback.IJavetPromiseRejectCallback;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.callback.JavetPromiseRejectCallback;
import com.caoccao.javet.interop.converters.IJavetConverter;
import com.caoccao.javet.interop.converters.JavetObjectConverter;
import com.caoccao.javet.interop.executors.IV8Executor;
import com.caoccao.javet.interop.executors.V8FileExecutor;
import com.caoccao.javet.interop.executors.V8PathExecutor;
import com.caoccao.javet.interop.executors.V8StringExecutor;
import com.caoccao.javet.interop.monitoring.V8HeapSpaceStatistics;
import com.caoccao.javet.interop.monitoring.V8HeapStatistics;
import com.caoccao.javet.interop.monitoring.V8SharedMemoryStatistics;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.utils.JavetDefaultLogger;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBigInteger;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueDouble;
import com.caoccao.javet.values.primitive.V8ValueInteger;
import com.caoccao.javet.values.primitive.V8ValueLong;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.primitive.V8ValueZonedDateTime;
import com.caoccao.javet.values.reference.IV8Context;
import com.caoccao.javet.values.reference.IV8Module;
import com.caoccao.javet.values.reference.IV8Script;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.IV8ValueFunction;
import com.caoccao.javet.values.reference.IV8ValueKeyContainer;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.IV8ValuePromise;
import com.caoccao.javet.values.reference.IV8ValueProxy;
import com.caoccao.javet.values.reference.IV8ValueReference;
import com.caoccao.javet.values.reference.IV8ValueSet;
import com.caoccao.javet.values.reference.IV8ValueTypedArray;
import com.caoccao.javet.values.reference.V8Context;
import com.caoccao.javet.values.reference.V8Module;
import com.caoccao.javet.values.reference.V8Script;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueArrayBuffer;
import com.caoccao.javet.values.reference.V8ValueDataView;
import com.caoccao.javet.values.reference.V8ValueError;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueGlobalObject;
import com.caoccao.javet.values.reference.V8ValueMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValuePromise;
import com.caoccao.javet.values.reference.V8ValueProxy;
import com.caoccao.javet.values.reference.V8ValueSet;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import com.caoccao.javet.values.reference.V8ValueTypedArray;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInSymbol;
import java.io.File;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class V8Runtime
implements IJavetClosable,
IV8Creatable,
IV8Convertible {
    static final IJavetConverter DEFAULT_CONVERTER = new JavetObjectConverter();
    static final String DEFAULT_MESSAGE_FORMAT_JAVET_INSPECTOR = "Javet Inspector {0}";
    static final long INVALID_HANDLE = 0L;
    static final String PROPERTY_DATA_VIEW = "DataView";
    static final int V8_VALUE_BOOLEAN_FALSE_INDEX = 0;
    static final int V8_VALUE_BOOLEAN_TRUE_INDEX = 1;
    static final int V8_VALUE_NUMBER_LOWER_BOUND = -128;
    static final int V8_VALUE_NUMBER_UPPER_BOUND = 128;
    final Object callbackContextLock;
    final Map<Long, JavetCallbackContext> callbackContextMap;
    final List<IJavetGCCallback> gcEpilogueCallbacks;
    final List<IJavetGCCallback> gcPrologueCallbacks;
    final Object referenceLock;
    final Map<Long, IV8ValueReference> referenceMap;
    final RuntimeOptions<?> runtimeOptions;
    final V8Host v8Host;
    final V8Internal v8Internal;
    final Object v8ModuleLock;
    final Map<String, IV8Module> v8ModuleMap;
    V8ValueBoolean[] cachedV8ValueBooleans;
    V8ValueInteger[] cachedV8ValueIntegers;
    V8ValueLong[] cachedV8ValueLongs;
    V8ValueNull cachedV8ValueNull;
    V8ValueUndefined cachedV8ValueUndefined;
    IJavetConverter converter;
    boolean gcScheduled;
    long handle;
    IJavetLogger logger;
    boolean pooled;
    IJavetPromiseRejectCallback promiseRejectCallback;
    V8Inspector v8Inspector;
    IV8ModuleResolver v8ModuleResolver;
    IV8Native v8Native;

    V8Runtime(V8Host v8Host, long handle, boolean pooled, IV8Native v8Native, RuntimeOptions<?> runtimeOptions) {
        assert (handle != 0L);
        this.callbackContextLock = new Object();
        this.callbackContextMap = new HashMap<Long, JavetCallbackContext>();
        this.converter = DEFAULT_CONVERTER;
        this.gcEpilogueCallbacks = new CopyOnWriteArrayList<IJavetGCCallback>();
        this.gcPrologueCallbacks = new CopyOnWriteArrayList<IJavetGCCallback>();
        this.gcScheduled = false;
        this.runtimeOptions = Objects.requireNonNull(runtimeOptions);
        this.handle = handle;
        this.logger = new JavetDefaultLogger(this.getClass().getName());
        this.pooled = pooled;
        this.promiseRejectCallback = new JavetPromiseRejectCallback(this.logger);
        this.referenceLock = new Object();
        this.referenceMap = new HashMap<Long, IV8ValueReference>();
        this.v8Host = Objects.requireNonNull(v8Host);
        this.v8Inspector = null;
        this.v8Native = Objects.requireNonNull(v8Native);
        this.v8ModuleLock = new Object();
        this.v8ModuleMap = new HashMap<String, IV8Module>();
        this.v8ModuleResolver = null;
        this.v8Internal = new V8Internal(this);
        this.initializeV8ValueCache();
    }

    void add(IV8ValueSet iV8ValueSet, V8Value value) throws JavetException {
        this.v8Native.add(this.handle, iV8ValueSet.getHandle(), iV8ValueSet.getType().getId(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGCEpilogueCallback(IJavetGCCallback iJavetGCCallback) {
        List<IJavetGCCallback> list = this.gcEpilogueCallbacks;
        synchronized (list) {
            boolean registered = !this.gcEpilogueCallbacks.isEmpty();
            this.gcEpilogueCallbacks.add(Objects.requireNonNull(iJavetGCCallback));
            if (!registered) {
                this.v8Native.registerGCEpilogueCallback(this.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGCPrologueCallback(IJavetGCCallback iJavetGCCallback) {
        List<IJavetGCCallback> list = this.gcPrologueCallbacks;
        synchronized (list) {
            boolean registered = !this.gcPrologueCallbacks.isEmpty();
            this.gcPrologueCallbacks.add(Objects.requireNonNull(iJavetGCCallback));
            if (!registered) {
                this.v8Native.registerGCPrologueCallback(this.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReference(IV8ValueReference iV8ValueReference) {
        Object object = this.referenceLock;
        synchronized (object) {
            this.referenceMap.put(iV8ValueReference.getHandle(), iV8ValueReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addV8Module(IV8Module iV8Module) {
        Object object = this.v8ModuleLock;
        synchronized (object) {
            this.v8ModuleMap.put(iV8Module.getResourceName(), iV8Module);
        }
    }

    public void allowEval(boolean allow) {
        this.v8Native.allowCodeGenerationFromStrings(this.handle, allow);
    }

    public boolean await() {
        return this.await(V8AwaitMode.RunTillNoMoreTasks);
    }

    public boolean await(V8AwaitMode v8AwaitMode) {
        return this.v8Native.await(this.handle, Objects.requireNonNull(v8AwaitMode).getId());
    }

    <T extends V8Value> T call(IV8ValueObject iV8ValueObject, IV8ValueObject receiver, boolean returnResult, V8Value ... v8Values) throws JavetException {
        return (T)((V8Value)this.v8Native.call(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), receiver, returnResult, v8Values));
    }

    <T extends V8Value> T callAsConstructor(IV8ValueObject iV8ValueObject, V8Value ... v8Values) throws JavetException {
        return (T)((V8Value)this.v8Native.callAsConstructor(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), v8Values));
    }

    void clearWeak(IV8ValueReference iV8ValueReference) throws JavetException {
        this.v8Native.clearWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    <T extends V8Value> T cloneV8Value(IV8ValueReference iV8ValueReference, boolean referenceCopy) throws JavetException {
        return (T)((V8Value)this.v8Native.cloneV8Value(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId(), referenceCopy));
    }

    @Override
    public void close() throws JavetException {
        this.close(!this.pooled);
    }

    public void close(boolean forceClose) throws JavetException {
        if (!this.isClosed() && forceClose) {
            this.removeAllReferences();
            this.v8Host.closeV8Runtime(this);
            this.handle = 0L;
            this.v8Native = null;
        }
    }

    public V8Module compileV8Module(String scriptString, byte[] cachedData, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        v8ScriptOrigin.setModule(true);
        if (v8ScriptOrigin.getResourceName() == null || v8ScriptOrigin.getResourceName().length() == 0) {
            throw new JavetException(JavetError.ModuleNameEmpty);
        }
        Object result = this.v8Native.compile(this.handle, scriptString, cachedData, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), v8ScriptOrigin.isModule());
        V8Module v8Module = null;
        if (resultRequired && result instanceof V8Module) {
            v8Module = (V8Module)result;
            v8Module.setResourceName(v8ScriptOrigin.getResourceName());
            this.addV8Module(v8Module);
        }
        return v8Module;
    }

    public V8Script compileV8Script(String scriptString, byte[] cachedData, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        v8ScriptOrigin.setModule(false);
        return (V8Script)this.v8Native.compile(this.handle, scriptString, cachedData, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), v8ScriptOrigin.isModule());
    }

    public V8ValueFunction compileV8ValueFunction(String scriptString, byte[] cachedData, V8ScriptOrigin v8ScriptOrigin, String[] arguments, V8ValueObject[] contextExtensions) throws JavetException {
        return (V8ValueFunction)this.v8Native.compileFunction(this.handle, scriptString, cachedData, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), arguments, contextExtensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsV8Module(String resourceName) {
        Object object = this.v8ModuleLock;
        synchronized (object) {
            return this.v8ModuleMap.containsKey(resourceName);
        }
    }

    <T extends V8Value> T contextGet(IV8Context iV8Context, int index) throws JavetException {
        return (T)((V8Value)this.v8Native.contextGet(this.handle, iV8Context.getHandle(), iV8Context.getType().getId(), index));
    }

    int contextGetLength(IV8Context iV8Context) throws JavetException {
        return this.v8Native.contextGetLength(this.handle, iV8Context.getHandle(), iV8Context.getType().getId());
    }

    boolean contextIsContextType(IV8Context iV8Context, int contextTypeId) throws JavetException {
        return this.v8Native.contextIsContextType(this.handle, iV8Context.getHandle(), iV8Context.getType().getId(), contextTypeId);
    }

    boolean contextSetLength(IV8Context iV8Context, int length) throws JavetException {
        return this.v8Native.contextSetLength(this.handle, iV8Context.getHandle(), iV8Context.getType().getId(), length);
    }

    @Override
    public V8ValueArray createV8ValueArray() throws JavetException {
        return (V8ValueArray)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Array.getId(), null);
    }

    @Override
    public V8ValueArrayBuffer createV8ValueArrayBuffer(int length) throws JavetException {
        return (V8ValueArrayBuffer)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.ArrayBuffer.getId(), this.createV8ValueInteger(length));
    }

    @Override
    public V8ValueArrayBuffer createV8ValueArrayBuffer(ByteBuffer byteBuffer) throws JavetException {
        Objects.requireNonNull(byteBuffer);
        assert (byteBuffer.isDirect()) : "Byte buffer must be direct.";
        return (V8ValueArrayBuffer)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.ArrayBuffer.getId(), byteBuffer);
    }

    @Override
    public V8ValueBigInteger createV8ValueBigInteger(BigInteger bigInteger) throws JavetException {
        return new V8ValueBigInteger(this, bigInteger);
    }

    @Override
    public V8ValueBigInteger createV8ValueBigInteger(String bigIntegerValue) throws JavetException {
        return new V8ValueBigInteger(this, bigIntegerValue);
    }

    @Override
    public V8ValueBoolean createV8ValueBoolean(boolean booleanValue) throws JavetException {
        return booleanValue ? this.cachedV8ValueBooleans[1] : this.cachedV8ValueBooleans[0];
    }

    @Override
    public V8ValueDataView createV8ValueDataView(V8ValueArrayBuffer v8ValueArrayBuffer) throws JavetException {
        Objects.requireNonNull(v8ValueArrayBuffer);
        try (Object v8Value = this.getExecutor(PROPERTY_DATA_VIEW).execute();){
            if (v8Value instanceof V8ValueFunction) {
                V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Value;
                V8ValueDataView v8ValueDataView = (V8ValueDataView)v8ValueFunction.callAsConstructor(v8ValueArrayBuffer);
                return v8ValueDataView;
            }
        }
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", PROPERTY_DATA_VIEW));
    }

    @Override
    public V8ValueDouble createV8ValueDouble(double doubleValue) throws JavetException {
        return new V8ValueDouble(this, doubleValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V8ValueFunction createV8ValueFunction(JavetCallbackContext javetCallbackContext) throws JavetException {
        V8ValueFunction v8ValueFunction = (V8ValueFunction)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Function.getId(), Objects.requireNonNull(javetCallbackContext));
        Object object = this.callbackContextLock;
        synchronized (object) {
            this.callbackContextMap.put(javetCallbackContext.getHandle(), javetCallbackContext);
        }
        return v8ValueFunction;
    }

    @Override
    public V8ValueFunction createV8ValueFunction(String codeString) throws JavetException {
        return (V8ValueFunction)this.getExecutor(codeString).execute();
    }

    @Override
    public V8ValueInteger createV8ValueInteger(int integerValue) throws JavetException {
        if (integerValue >= -128 && integerValue < 128) {
            return this.cachedV8ValueIntegers[integerValue - -128];
        }
        return new V8ValueInteger(this, integerValue);
    }

    @Override
    public V8ValueLong createV8ValueLong(long longValue) throws JavetException {
        if (longValue >= -128L && longValue < 128L) {
            return this.cachedV8ValueLongs[(int)longValue - -128];
        }
        return new V8ValueLong(this, longValue);
    }

    @Override
    public V8ValueMap createV8ValueMap() throws JavetException {
        return (V8ValueMap)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Map.getId(), null);
    }

    @Override
    public V8ValueNull createV8ValueNull() {
        return this.cachedV8ValueNull;
    }

    @Override
    public V8ValueObject createV8ValueObject() throws JavetException {
        return (V8ValueObject)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Object.getId(), null);
    }

    @Override
    public V8ValuePromise createV8ValuePromise() throws JavetException {
        return (V8ValuePromise)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Promise.getId(), null);
    }

    @Override
    public V8ValueProxy createV8ValueProxy(V8ValueObject v8ValueObject) throws JavetException {
        return (V8ValueProxy)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Proxy.getId(), v8ValueObject);
    }

    @Override
    public V8ValueSet createV8ValueSet() throws JavetException {
        return (V8ValueSet)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Set.getId(), null);
    }

    @Override
    public V8ValueString createV8ValueString(String str) throws JavetException {
        return new V8ValueString(this, str);
    }

    @Override
    public V8ValueSymbol createV8ValueSymbol(String description, boolean global) throws JavetException {
        Objects.requireNonNull(description);
        assert (description.length() > 0);
        if (global) {
            try (V8ValueBuiltInSymbol v8ValueBuiltInSymbol = this.getGlobalObject().getBuiltInSymbol();){
                V8ValueSymbol v8ValueSymbol = v8ValueBuiltInSymbol._for(description);
                return v8ValueSymbol;
            }
        }
        return (V8ValueSymbol)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Symbol.getId(), description);
    }

    @Override
    public V8ValueTypedArray createV8ValueTypedArray(V8ValueReferenceType type, int length) throws JavetException {
        try (Object v8Value = this.getExecutor(type.getName()).execute();){
            if (v8Value instanceof V8ValueFunction) {
                V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Value;
                V8ValueTypedArray v8ValueTypedArray = (V8ValueTypedArray)v8ValueFunction.callAsConstructor(this.createV8ValueInteger(length));
                return v8ValueTypedArray;
            }
        }
        throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", type.getName()));
    }

    @Override
    public V8ValueUndefined createV8ValueUndefined() {
        return this.cachedV8ValueUndefined;
    }

    @Override
    public V8ValueZonedDateTime createV8ValueZonedDateTime(long jsTimestamp) throws JavetException {
        return new V8ValueZonedDateTime(this, jsTimestamp);
    }

    @Override
    public V8ValueZonedDateTime createV8ValueZonedDateTime(ZonedDateTime zonedDateTime) throws JavetException {
        return new V8ValueZonedDateTime(this, zonedDateTime);
    }

    boolean delete(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return this.v8Native.delete(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    boolean deletePrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return this.v8Native.deletePrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName);
    }

    boolean equals(IV8ValueReference iV8ValueReference1, IV8ValueReference iV8ValueReference2) throws JavetException {
        return this.v8Native.equals(this.handle, iV8ValueReference1.getHandle(), iV8ValueReference2.getHandle());
    }

    public <T extends V8Value> T execute(String scriptString, byte[] cachedData, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        return (T)((V8Value)this.v8Native.execute(this.handle, scriptString, cachedData, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), v8ScriptOrigin.isModule()));
    }

    boolean functionCanDiscardCompiled(IV8ValueFunction iV8ValueFunction) {
        return this.v8Native.functionCanDiscardCompiled(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    boolean functionCopyScopeInfoFrom(IV8ValueFunction targetIV8ValueFunction, IV8ValueFunction sourceIV8ValueFunction) throws JavetException {
        return this.v8Native.functionCopyScopeInfoFrom(this.handle, targetIV8ValueFunction.getHandle(), targetIV8ValueFunction.getType().getId(), sourceIV8ValueFunction.getHandle(), sourceIV8ValueFunction.getType().getId());
    }

    boolean functionDiscardCompiled(IV8ValueFunction iV8ValueFunction) {
        return this.v8Native.functionDiscardCompiled(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    String[] functionGetArguments(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return this.v8Native.functionGetArguments(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    V8Context functionGetContext(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return (V8Context)this.v8Native.functionGetContext(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    IV8ValueArray functionGetScopeInfos(IV8ValueFunction iV8ValueFunction, IV8ValueFunction.GetScopeInfosOptions options) throws JavetException {
        return (IV8ValueArray)this.v8Native.functionGetScopeInfos(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), options.isIncludeGlobalVariables(), options.isIncludeScopeTypeGlobal());
    }

    IV8ValueFunction.ScriptSource functionGetScriptSource(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return (IV8ValueFunction.ScriptSource)this.v8Native.functionGetScriptSource(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    String functionGetSourceCode(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return this.v8Native.functionGetSourceCode(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    boolean functionIsCompiled(IV8ValueFunction iV8ValueFunction) {
        return this.v8Native.functionIsCompiled(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    boolean functionIsWrapped(IV8ValueFunction iV8ValueFunction) {
        return this.v8Native.functionIsWrapped(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    boolean functionSetContext(IV8ValueFunction iV8ValueFunction, V8Context v8Context) throws JavetException {
        return this.v8Native.functionSetContext(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), v8Context);
    }

    boolean functionSetScriptSource(IV8ValueFunction iV8ValueFunction, IV8ValueFunction.ScriptSource scriptSource, boolean cloneScript) throws JavetException {
        return this.v8Native.functionSetScriptSource(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), scriptSource, cloneScript);
    }

    boolean functionSetSourceCode(IV8ValueFunction iV8ValueFunction, String sourceCode, boolean cloneScript) throws JavetException {
        return this.v8Native.functionSetSourceCode(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), sourceCode, cloneScript);
    }

    <T extends V8Value> T get(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return (T)((V8Value)this.v8Native.get(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key));
    }

    byte[] getCachedData(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return this.v8Native.getCachedData(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    byte[] getCachedData(IV8Module iV8Module) throws JavetException {
        return this.v8Native.getCachedData(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    byte[] getCachedData(IV8Script iV8Script) throws JavetException {
        return this.v8Native.getCachedData(this.handle, iV8Script.getHandle(), iV8Script.getType().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavetCallbackContext getCallbackContext(long handle) {
        Object object = this.callbackContextLock;
        synchronized (object) {
            return this.callbackContextMap.get(handle);
        }
    }

    public int getCallbackContextCount() {
        return this.callbackContextMap.size();
    }

    public IJavetConverter getConverter() {
        return this.converter;
    }

    public IV8Executor getExecutor(File scriptFile) throws JavetException {
        return new V8FileExecutor(this, scriptFile);
    }

    public IV8Executor getExecutor(Path scriptPath) throws JavetException {
        return new V8PathExecutor(this, scriptPath);
    }

    public IV8Executor getExecutor(String scriptString) {
        return new V8StringExecutor(this, scriptString);
    }

    public IV8Executor getExecutor(String scriptString, byte[] cachedData) {
        return new V8StringExecutor(this, scriptString, cachedData);
    }

    public V8ValueGlobalObject getGlobalObject() throws JavetException {
        return (V8ValueGlobalObject)this.v8Native.getGlobalObject(this.handle);
    }

    public long getHandle() {
        return this.handle;
    }

    int getIdentityHash(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.getIdentityHash(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    IV8ValueArray getInternalProperties(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return (V8ValueArray)this.v8Native.getInternalProperties(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    JSFunctionType getJSFunctionType(IV8ValueFunction iV8ValueFunction) {
        return JSFunctionType.parse(this.v8Native.getJSFunctionType(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId()));
    }

    public JSRuntimeType getJSRuntimeType() {
        return JSRuntimeType.V8;
    }

    JSScopeType getJSScopeType(IV8ValueFunction iV8ValueFunction) {
        return JSScopeType.parse(this.v8Native.getJSScopeType(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId()));
    }

    int getLength(IV8ValueArray iV8ValueArray) throws JavetException {
        return this.v8Native.getLength(this.handle, iV8ValueArray.getHandle(), iV8ValueArray.getType().getId());
    }

    int getLength(IV8ValueTypedArray iV8ValueTypedArray) throws JavetException {
        return this.v8Native.getLength(this.handle, iV8ValueTypedArray.getHandle(), iV8ValueTypedArray.getType().getId());
    }

    public IJavetLogger getLogger() {
        return this.logger;
    }

    IV8ValueArray getOwnPropertyNames(IV8ValueObject iV8ValueObject) throws JavetException {
        return (V8ValueArray)this.v8Native.getOwnPropertyNames(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId());
    }

    <T extends V8Value> T getPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return (T)((V8Value)this.v8Native.getPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName));
    }

    public IJavetPromiseRejectCallback getPromiseRejectCallback() {
        return this.promiseRejectCallback;
    }

    <T extends V8Value> T getProperty(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return (T)((V8Value)this.v8Native.getProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key));
    }

    IV8ValueArray getPropertyNames(IV8ValueObject iV8ValueObject) throws JavetException {
        return (V8ValueArray)this.v8Native.getPropertyNames(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId());
    }

    <T extends IV8ValueObject> T getPrototype(IV8ValueObject iV8ValueObject) throws JavetException {
        return (T)((IV8ValueObject)this.v8Native.getPrototype(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId()));
    }

    public int getReferenceCount() {
        return this.referenceMap.size();
    }

    public RuntimeOptions<?> getRuntimeOptions() {
        return this.runtimeOptions;
    }

    int getSize(IV8ValueKeyContainer iV8ValueKeyContainer) throws JavetException {
        return this.v8Native.getSize(this.handle, iV8ValueKeyContainer.getHandle(), iV8ValueKeyContainer.getType().getId());
    }

    public V8HeapSpaceStatistics getV8HeapSpaceStatistics(V8AllocationSpace v8AllocationSpace) {
        Objects.requireNonNull(v8AllocationSpace);
        return ((V8HeapSpaceStatistics)this.v8Native.getV8HeapSpaceStatistics(this.handle, v8AllocationSpace.getIndex())).setAllocationSpace(v8AllocationSpace);
    }

    public V8HeapStatistics getV8HeapStatistics() {
        return (V8HeapStatistics)this.v8Native.getV8HeapStatistics(this.handle);
    }

    public V8Inspector getV8Inspector() {
        return this.getV8Inspector(MessageFormat.format(DEFAULT_MESSAGE_FORMAT_JAVET_INSPECTOR, Long.toString(this.handle)));
    }

    public V8Inspector getV8Inspector(String name) {
        if (this.v8Inspector == null) {
            this.v8Inspector = new V8Inspector(this, name, this.v8Native);
        }
        return this.v8Inspector;
    }

    public V8Internal getV8Internal() {
        return this.v8Internal;
    }

    public V8Locker getV8Locker() throws JavetException {
        return new V8Locker(this, this.v8Native);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IV8Module getV8Module(String resourceName, IV8Module v8ModuleReferrer) throws JavetException {
        if (resourceName != null && resourceName.length() > 0) {
            Object object = this.v8ModuleLock;
            synchronized (object) {
                if (this.v8ModuleMap.containsKey(resourceName)) {
                    return this.v8ModuleMap.get(resourceName);
                }
            }
            if (this.v8ModuleResolver != null) {
                return this.v8ModuleResolver.resolve(this, resourceName, v8ModuleReferrer);
            }
        }
        return null;
    }

    public int getV8ModuleCount() {
        return this.v8ModuleMap.size();
    }

    public IV8ModuleResolver getV8ModuleResolver() {
        return this.v8ModuleResolver;
    }

    public V8Scope getV8Scope() {
        return new V8Scope(this);
    }

    public V8SharedMemoryStatistics getV8SharedMemoryStatistics() {
        return this.v8Host.getV8SharedMemoryStatistics();
    }

    public String getVersion() {
        return this.v8Native.getVersion();
    }

    boolean has(IV8ValueObject iV8ValueObject, V8Value value) throws JavetException {
        return this.v8Native.has(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), value);
    }

    boolean hasInternalType(IV8ValueObject iV8ValueObject, V8ValueInternalType internalType) {
        return this.v8Native.hasInternalType(this.handle, iV8ValueObject.getHandle(), Objects.requireNonNull(internalType).getId());
    }

    boolean hasOwnProperty(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return this.v8Native.hasOwnProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    public boolean hasPendingException() throws JavetException {
        return this.v8Native.hasPendingException(this.handle);
    }

    public boolean hasPendingMessage() throws JavetException {
        return this.v8Native.hasPendingMessage(this.handle);
    }

    boolean hasPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return this.v8Native.hasPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName);
    }

    public boolean hasScheduledException() throws JavetException {
        return this.v8Native.hasScheduledException(this.handle);
    }

    public void idleNotificationDeadline(long deadlineInMillis) {
        if (!this.isClosed() && deadlineInMillis > 0L) {
            this.v8Native.idleNotificationDeadline(this.handle, deadlineInMillis);
        }
    }

    void initializeV8ValueCache() {
        try {
            this.cachedV8ValueNull = new V8ValueNull(this);
            this.cachedV8ValueUndefined = new V8ValueUndefined(this);
            this.cachedV8ValueBooleans = new V8ValueBoolean[]{new V8ValueBoolean(this, false), new V8ValueBoolean(this, true)};
            this.cachedV8ValueIntegers = new V8ValueInteger[256];
            this.cachedV8ValueLongs = new V8ValueLong[256];
            for (int i = -128; i < 128; ++i) {
                try {
                    this.cachedV8ValueIntegers[i - -128] = new V8ValueInteger(this, i);
                    this.cachedV8ValueLongs[i - -128] = new V8ValueLong(this, i);
                    continue;
                }
                catch (JavetException e) {
                    this.logger.logError(e, e.getMessage(), new Object[0]);
                }
            }
        }
        catch (JavetException e) {
            this.logger.logError(e, e.getMessage(), new Object[0]);
        }
    }

    <T extends V8Value> T invoke(IV8ValueObject iV8ValueObject, String functionName, boolean returnResult, V8Value ... v8Values) throws JavetException {
        return (T)((V8Value)this.v8Native.invoke(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), functionName, returnResult, v8Values));
    }

    @Override
    public boolean isClosed() {
        return this.handle == 0L;
    }

    public boolean isDead() {
        return this.v8Native.isDead(this.handle);
    }

    public boolean isGCScheduled() {
        return this.gcScheduled;
    }

    public boolean isInUse() {
        return this.v8Native.isInUse(this.handle);
    }

    public boolean isPooled() {
        return this.pooled;
    }

    boolean isWeak(IV8ValueReference iV8ValueReference) {
        return this.v8Native.isWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    public void lowMemoryNotification() {
        if (!this.isClosed()) {
            this.v8Native.lowMemoryNotification(this.handle);
        }
    }

    <T extends V8Value> T moduleEvaluate(IV8Module iV8Module, boolean resultRequired) throws JavetException {
        return (T)((V8Value)this.v8Native.moduleEvaluate(this.handle, iV8Module.getHandle(), iV8Module.getType().getId(), resultRequired));
    }

    V8ValueError moduleGetException(IV8Module iV8Module) throws JavetException {
        return (V8ValueError)this.v8Native.moduleGetException(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    V8ValueObject moduleGetNamespace(IV8Module iV8Module) throws JavetException {
        return (V8ValueObject)this.v8Native.moduleGetNamespace(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    int moduleGetScriptId(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetScriptId(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    int moduleGetStatus(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetStatus(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    boolean moduleInstantiate(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleInstantiate(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    <T extends V8ValuePromise> T promiseCatch(IV8ValuePromise iV8ValuePromise, IV8ValueFunction functionHandle) throws JavetException {
        return (T)((V8ValuePromise)this.v8Native.promiseCatch(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId(), functionHandle.getHandle()));
    }

    V8ValuePromise promiseGetPromise(IV8ValuePromise iV8ValuePromise) throws JavetException {
        return (V8ValuePromise)this.v8Native.promiseGetPromise(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    <T extends V8Value> T promiseGetResult(IV8ValuePromise iV8ValuePromise) throws JavetException {
        return (T)((V8Value)this.v8Native.promiseGetResult(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId()));
    }

    int promiseGetState(IV8ValuePromise iV8ValuePromise) {
        return this.v8Native.promiseGetState(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    boolean promiseHasHandler(IV8ValuePromise iV8ValuePromise) {
        return this.v8Native.promiseHasHandler(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    void promiseMarkAsHandled(IV8ValuePromise iV8ValuePromise) {
        this.v8Native.promiseMarkAsHandled(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    boolean promiseReject(V8ValuePromise v8ValuePromise, V8Value v8Value) {
        return this.v8Native.promiseReject(this.handle, v8ValuePromise.getHandle(), v8ValuePromise.getType().getId(), v8Value);
    }

    boolean promiseResolve(V8ValuePromise v8ValuePromise, V8Value v8Value) {
        return this.v8Native.promiseResolve(this.handle, v8ValuePromise.getHandle(), v8ValuePromise.getType().getId(), v8Value);
    }

    <T extends V8ValuePromise> T promiseThen(IV8ValuePromise iV8ValuePromise, IV8ValueFunction functionFulfilledHandle, IV8ValueFunction functionRejectedHandle) throws JavetException {
        return (T)((V8ValuePromise)this.v8Native.promiseThen(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId(), functionFulfilledHandle.getHandle(), functionRejectedHandle == null ? 0L : functionRejectedHandle.getHandle()));
    }

    public boolean promoteScheduledException() throws JavetException {
        return this.v8Native.promoteScheduledException(this.handle);
    }

    V8ValueObject proxyGetHandler(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return (V8ValueObject)this.v8Native.proxyGetHandler(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    V8ValueObject proxyGetTarget(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return (V8ValueObject)this.v8Native.proxyGetTarget(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    boolean proxyIsRevoked(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return this.v8Native.proxyIsRevoked(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    void proxyRevoke(IV8ValueProxy iV8ValueProxy) throws JavetException {
        this.v8Native.proxyRevoke(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    void receiveGCEpilogueCallback(int v8GCTypeValue, int v8GCCallbackFlagsValue) {
        EnumSet<V8GCType> enumSetV8GCType = IEnumBitset.getEnumSet(v8GCTypeValue, V8GCType.class);
        EnumSet<V8GCCallbackFlags> enumSetV8GCCallbackFlags = IEnumBitset.getEnumSet(v8GCCallbackFlagsValue, V8GCCallbackFlags.class, V8GCCallbackFlags.NoGCCallbackFlags);
        for (IJavetGCCallback iJavetGCCallback : this.gcEpilogueCallbacks) {
            iJavetGCCallback.callback(enumSetV8GCType, enumSetV8GCCallbackFlags);
        }
    }

    void receiveGCPrologueCallback(int v8GCTypeValue, int v8GCCallbackFlagsValue) {
        EnumSet<V8GCType> enumSetV8GCType = IEnumBitset.getEnumSet(v8GCTypeValue, V8GCType.class);
        EnumSet<V8GCCallbackFlags> enumSetV8GCCallbackFlags = IEnumBitset.getEnumSet(v8GCCallbackFlagsValue, V8GCCallbackFlags.class, V8GCCallbackFlags.NoGCCallbackFlags);
        for (IJavetGCCallback iJavetGCCallback : this.gcPrologueCallbacks) {
            iJavetGCCallback.callback(enumSetV8GCType, enumSetV8GCCallbackFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivePromiseRejectCallback(int event, V8ValuePromise promise, V8Value value) {
        try {
            this.promiseRejectCallback.callback(JavetPromiseRejectEvent.parse(event), promise, value);
        }
        catch (Throwable t) {
            try {
                this.logger.logError(t, "Failed to process promise reject callback {0}.", event);
            }
            catch (Throwable throwable) {
                JavetResourceUtils.safeClose(promise, value);
                throw throwable;
            }
            JavetResourceUtils.safeClose(promise, value);
        }
        JavetResourceUtils.safeClose(promise, value);
    }

    void removeAllReferences() throws JavetException {
        this.removeReferences();
        this.removeCallbackContexts();
        this.removeV8Modules();
        this.v8Inspector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallbackContext(long handle) {
        Object object = this.callbackContextLock;
        synchronized (object) {
            this.callbackContextMap.remove(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbackContexts() {
        Object object = this.callbackContextLock;
        synchronized (object) {
            if (!this.callbackContextMap.isEmpty()) {
                int callbackContextCount = this.callbackContextMap.size();
                for (long handle : this.callbackContextMap.keySet()) {
                    this.removeJNIGlobalRef(handle);
                }
                this.logger.logWarn("{0} V8 callback context object(s) not recycled.", Integer.toString(callbackContextCount));
                this.callbackContextMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGCEpilogueCallback(IJavetGCCallback iJavetGCCallback) {
        List<IJavetGCCallback> list = this.gcEpilogueCallbacks;
        synchronized (list) {
            this.gcEpilogueCallbacks.remove(Objects.requireNonNull(iJavetGCCallback));
            if (this.gcEpilogueCallbacks.isEmpty()) {
                this.v8Native.unregisterGCEpilogueCallback(this.handle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGCPrologueCallback(IJavetGCCallback iJavetGCCallback) {
        List<IJavetGCCallback> list = this.gcPrologueCallbacks;
        synchronized (list) {
            this.gcPrologueCallbacks.remove(Objects.requireNonNull(iJavetGCCallback));
            if (this.gcPrologueCallbacks.isEmpty()) {
                this.v8Native.unregisterGCPrologueCallback(this.handle);
            }
        }
    }

    void removeJNIGlobalRef(long handle) {
        if (!this.isClosed()) {
            this.v8Native.removeJNIGlobalRef(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReference(IV8ValueReference iV8ValueReference) throws JavetException {
        long referenceHandle = iV8ValueReference.getHandle();
        Object object = this.referenceLock;
        synchronized (object) {
            if (this.referenceMap.containsKey(referenceHandle)) {
                int referenceType = iV8ValueReference.getType().getId();
                if (referenceType == V8ValueReferenceType.Module.getId()) {
                    this.removeV8Module((IV8Module)iV8ValueReference);
                }
                this.v8Native.removeReferenceHandle(referenceHandle, referenceType);
                this.referenceMap.remove(referenceHandle);
            }
        }
        if (this.gcScheduled) {
            this.lowMemoryNotification();
            this.gcScheduled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReferences() throws JavetException {
        Object object = this.referenceLock;
        synchronized (object) {
            if (!this.referenceMap.isEmpty()) {
                int referenceCount = this.getReferenceCount();
                int v8ModuleCount = this.getV8ModuleCount();
                int weakReferenceCount = 0;
                for (IV8ValueReference iV8ValueReference : new ArrayList<IV8ValueReference>(this.referenceMap.values())) {
                    IV8ValueObject iV8ValueObject;
                    if (iV8ValueReference instanceof IV8ValueObject && (iV8ValueObject = (IV8ValueObject)iV8ValueReference).isWeak()) {
                        ++weakReferenceCount;
                    }
                    iV8ValueReference.close(true);
                }
                if (v8ModuleCount + weakReferenceCount < referenceCount) {
                    this.logger.logWarn("{0} V8 object(s) not recycled, {1} weak, {2} module(s).", Integer.toString(referenceCount), Integer.toString(weakReferenceCount), Integer.toString(v8ModuleCount));
                } else {
                    this.logger.logDebug("{0} V8 object(s) not recycled, {1} weak, {2} module(s).", Integer.toString(referenceCount), Integer.toString(weakReferenceCount), Integer.toString(v8ModuleCount));
                }
                this.referenceMap.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeV8Module(String resourceName, boolean forceClose) throws JavetException {
        IV8Module iV8Module;
        Object object = this.v8ModuleLock;
        synchronized (object) {
            iV8Module = this.v8ModuleMap.remove(resourceName);
        }
        if (forceClose && iV8Module != null) {
            iV8Module.close(true);
        }
    }

    public void removeV8Module(String resourceName) throws JavetException {
        this.removeV8Module(resourceName, false);
    }

    public void removeV8Module(IV8Module iV8Module) throws JavetException {
        this.removeV8Module(iV8Module, false);
    }

    public void removeV8Module(IV8Module iV8Module, boolean forceClose) throws JavetException {
        this.removeV8Module(iV8Module.getResourceName(), forceClose);
    }

    public void removeV8Modules() throws JavetException {
        this.removeV8Modules(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeV8Modules(boolean forceClose) throws JavetException {
        Object object = this.v8ModuleLock;
        synchronized (object) {
            if (!this.v8ModuleMap.isEmpty()) {
                this.logger.logWarn("{0} V8 module(s) not recycled.", Integer.toString(this.v8ModuleMap.size()));
                for (IV8Module iV8Module : this.v8ModuleMap.values()) {
                    this.logger.logWarn("  V8 module: {0}", iV8Module.getResourceName());
                    if (!forceClose) continue;
                    iV8Module.close(true);
                }
                this.v8ModuleMap.clear();
            }
        }
    }

    public boolean reportPendingMessages() throws JavetException {
        return this.v8Native.reportPendingMessages(this.handle);
    }

    public void requestGarbageCollectionForTesting(boolean fullGC) {
        this.v8Native.requestGarbageCollectionForTesting(this.handle, fullGC);
    }

    public void resetContext() throws JavetException {
        this.removeAllReferences();
        this.v8Native.resetV8Context(this.handle, this.runtimeOptions);
    }

    public void resetIsolate() throws JavetException {
        this.removeAllReferences();
        this.v8Native.resetV8Isolate(this.handle, this.runtimeOptions);
    }

    boolean sameValue(IV8ValueObject iV8ValueObject1, IV8ValueObject iV8ValueObject2) {
        return this.v8Native.sameValue(this.handle, iV8ValueObject1.getHandle(), iV8ValueObject2.getHandle());
    }

    <T extends V8Value> T scriptRun(IV8Script iV8Script, boolean resultRequired) throws JavetException {
        return (T)((V8Value)this.v8Native.scriptRun(this.handle, iV8Script.getHandle(), iV8Script.getType().getId(), resultRequired));
    }

    boolean set(IV8ValueObject iV8ValueObject, V8Value key, V8Value value) throws JavetException {
        return this.v8Native.set(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setAccessor(IV8ValueObject iV8ValueObject, V8Value propertyName, JavetCallbackContext javetCallbackContextGetter, JavetCallbackContext javetCallbackContextSetter) throws JavetException {
        assert (propertyName instanceof V8ValueString || propertyName instanceof V8ValueSymbol);
        boolean isAccessorSet = this.v8Native.setAccessor(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName, javetCallbackContextGetter, javetCallbackContextSetter);
        Object object = this.callbackContextLock;
        synchronized (object) {
            if (javetCallbackContextGetter != null && javetCallbackContextGetter.isValid()) {
                this.callbackContextMap.put(javetCallbackContextGetter.getHandle(), javetCallbackContextGetter);
            }
            if (javetCallbackContextSetter != null && javetCallbackContextSetter.isValid()) {
                this.callbackContextMap.put(javetCallbackContextSetter.getHandle(), javetCallbackContextSetter);
            }
        }
        return isAccessorSet;
    }

    public void setConverter(IJavetConverter converter) {
        Objects.requireNonNull(converter);
        this.converter = converter;
    }

    public void setGCScheduled(boolean gcScheduled) {
        this.gcScheduled = gcScheduled;
    }

    public void setLogger(IJavetLogger logger) {
        this.logger = logger;
    }

    boolean setPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName, V8Value propertyValue) throws JavetException {
        return this.v8Native.setPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName, propertyValue);
    }

    public void setPromiseRejectCallback(IJavetPromiseRejectCallback promiseRejectCallback) {
        Objects.requireNonNull(promiseRejectCallback);
        this.promiseRejectCallback = promiseRejectCallback;
    }

    boolean setProperty(IV8ValueObject iV8ValueObject, V8Value key, V8Value value) throws JavetException {
        return this.v8Native.setProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    boolean setPrototype(IV8ValueObject iV8ValueObject, IV8ValueObject iV8ValueObjectPrototype) throws JavetException {
        return this.v8Native.setPrototype(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), iV8ValueObjectPrototype.getHandle());
    }

    public void setV8ModuleResolver(IV8ModuleResolver v8ModuleResolver) {
        this.v8ModuleResolver = v8ModuleResolver;
    }

    void setWeak(IV8ValueReference iV8ValueReference) {
        this.v8Native.setWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId(), iV8ValueReference);
    }

    boolean strictEquals(IV8ValueObject iV8ValueObject1, IV8ValueObject iV8ValueObject2) {
        return this.v8Native.strictEquals(this.handle, iV8ValueObject1.getHandle(), iV8ValueObject2.getHandle());
    }

    public void terminateExecution() {
        this.v8Native.terminateExecution(this.handle);
    }

    @Override
    public <T, V extends V8Value> T toObject(V v8Value) throws JavetException {
        return this.converter.toObject(v8Value);
    }

    String toProtoString(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.toProtoString(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    String toString(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.toString(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    @Override
    public <T, V extends V8Value> V toV8Value(T object) throws JavetException {
        return (V)this.converter.toV8Value(this, object);
    }
}

