/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.JSFunctionType;
import com.caoccao.javet.enums.JSScopeType;
import com.caoccao.javet.enums.V8ScopeType;
import com.caoccao.javet.enums.V8ValueInternalType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8Context;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public interface IV8ValueFunction
extends IV8ValueObject {
    default public <T extends V8Value> T call(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return this.callExtended(receiver, true, objects);
    }

    default public <T extends V8Value> T call(IV8ValueObject receiver, V8Value ... v8Values) throws JavetException {
        return this.callExtended(receiver, true, v8Values);
    }

    public <T extends V8Value> T callAsConstructor(Object ... var1) throws JavetException;

    public <T extends V8Value> T callAsConstructor(V8Value ... var1) throws JavetException;

    default public BigInteger callBigInteger(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (BigInteger)this.callPrimitive(receiver, objects);
    }

    default public Boolean callBoolean(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (Boolean)this.callPrimitive(receiver, objects);
    }

    default public Double callDouble(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (Double)this.callPrimitive(receiver, objects);
    }

    public <T extends V8Value> T callExtended(IV8ValueObject var1, boolean var2, Object ... var3) throws JavetException;

    public <T extends V8Value> T callExtended(IV8ValueObject var1, boolean var2, V8Value ... var3) throws JavetException;

    default public Float callFloat(IV8ValueObject receiver, Object ... objects) throws JavetException {
        Double result = this.callDouble(receiver, objects);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    default public Integer callInteger(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (Integer)this.callPrimitive(receiver, objects);
    }

    default public Long callLong(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (Long)this.callPrimitive(receiver, objects);
    }

    default public <T> T callObject(IV8ValueObject receiver, Object ... objects) throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.callExtended(receiver, true, objects), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R callPrimitive(IV8ValueObject receiver, Object ... objects) throws JavetException {
        try (T v8Value = this.callExtended(receiver, true, objects);){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    default public String callString(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (String)this.callPrimitive(receiver, objects);
    }

    default public void callVoid(IV8ValueObject receiver, Object ... objects) throws JavetException {
        this.callExtended(receiver, false, objects);
    }

    default public void callVoid(IV8ValueObject receiver, V8Value ... v8Values) throws JavetException {
        this.callExtended(receiver, false, v8Values);
    }

    public boolean canDiscardCompiled() throws JavetException;

    default public boolean copyContextFrom(IV8ValueFunction sourceIV8ValueFunction) throws JavetException {
        try (V8Context v8Context = sourceIV8ValueFunction.getContext();){
            boolean bl = this.setContext(v8Context);
            return bl;
        }
    }

    public boolean copyScopeInfoFrom(IV8ValueFunction var1) throws JavetException;

    public boolean discardCompiled() throws JavetException;

    public V8Context getContext() throws JavetException;

    public IV8ValueArray getInternalProperties() throws JavetException;

    public JSFunctionType getJSFunctionType() throws JavetException;

    public JSScopeType getJSScopeType() throws JavetException;

    default public ScopeInfos getScopeInfos() throws JavetException {
        return this.getScopeInfos(GetScopeInfosOptions.Default);
    }

    public ScopeInfos getScopeInfos(GetScopeInfosOptions var1) throws JavetException;

    public ScriptSource getScriptSource() throws JavetException;

    public String getSourceCode() throws JavetException;

    default public boolean isAsyncFunction() throws JavetException {
        return this.hasInternalType(V8ValueInternalType.AsyncFunction);
    }

    public boolean isCompiled() throws JavetException;

    default public boolean isGeneratorFunction() throws JavetException {
        return this.hasInternalType(V8ValueInternalType.GeneratorFunction);
    }

    public boolean setContext(V8Context var1) throws JavetException;

    default public boolean setScriptSource(ScriptSource scriptSource) throws JavetException {
        return this.setScriptSource(scriptSource, false);
    }

    public boolean setScriptSource(ScriptSource var1, boolean var2) throws JavetException;

    default public boolean setSourceCode(String sourceCodeString) throws JavetException {
        return this.setSourceCode(sourceCodeString, SetSourceCodeOptions.DEFAULT);
    }

    public boolean setSourceCode(String var1, SetSourceCodeOptions var2) throws JavetException;

    public static final class SetSourceCodeOptions
    implements Cloneable {
        public static final SetSourceCodeOptions DEFAULT = new SetSourceCodeOptions();
        public static final SetSourceCodeOptions GC = new SetSourceCodeOptions().setPreGC(true).setPostGC(true);
        public static final SetSourceCodeOptions NATIVE_GC = new SetSourceCodeOptions().setPreGC(true).setPostGC(true).setNativeCalculation(true);
        private boolean cloneScript;
        private boolean nativeCalculation;
        private boolean postGC;
        private boolean preGC;
        private boolean trimTailingCharacters;

        private SetSourceCodeOptions() {
            this.setCloneScript(false).setPreGC(false).setPostGC(false);
            this.setNativeCalculation(false).setTrimTailingCharacters(false);
        }

        protected SetSourceCodeOptions clone() {
            return new SetSourceCodeOptions().setCloneScript(this.isCloneScript()).setNativeCalculation(this.isNativeCalculation()).setPreGC(this.isPreGC()).setPostGC(this.isPostGC()).setTrimTailingCharacters(this.isTrimTailingCharacters());
        }

        public boolean isCloneScript() {
            return this.cloneScript;
        }

        public boolean isNativeCalculation() {
            return this.nativeCalculation;
        }

        public boolean isPostGC() {
            return this.postGC;
        }

        public boolean isPreGC() {
            return this.preGC;
        }

        public boolean isTrimTailingCharacters() {
            return this.trimTailingCharacters;
        }

        private SetSourceCodeOptions setCloneScript(boolean cloneScript) {
            this.cloneScript = cloneScript;
            return this;
        }

        private SetSourceCodeOptions setNativeCalculation(boolean nativeCalculation) {
            this.nativeCalculation = nativeCalculation;
            return this;
        }

        private SetSourceCodeOptions setPostGC(boolean postGC) {
            this.postGC = postGC;
            return this;
        }

        private SetSourceCodeOptions setPreGC(boolean preGC) {
            this.preGC = preGC;
            return this;
        }

        private SetSourceCodeOptions setTrimTailingCharacters(boolean trimTailingCharacters) {
            this.trimTailingCharacters = trimTailingCharacters;
            return this;
        }

        public SetSourceCodeOptions withCloneScript(boolean cloneScript) {
            return this.clone().setCloneScript(cloneScript);
        }

        public SetSourceCodeOptions withNativeCalculation(boolean nativeCalculation) {
            return this.clone().setNativeCalculation(nativeCalculation);
        }

        public SetSourceCodeOptions withPostGC(boolean postGC) {
            return this.clone().setPostGC(postGC);
        }

        public SetSourceCodeOptions withPreGC(boolean preGC) {
            return this.clone().setPreGC(preGC);
        }

        public SetSourceCodeOptions withTrimTailingCharacters(boolean trimTrailingCharacters) {
            return this.clone().setTrimTailingCharacters(trimTrailingCharacters);
        }
    }

    public static final class ScriptSource {
        private final String code;
        private final int endPosition;
        private final int startPosition;

        public ScriptSource(String code, int startPosition, int endPosition) {
            Objects.requireNonNull(code, "Code cannot be null.");
            assert (startPosition >= 0) : "Start position must be no less than 0.";
            assert (endPosition > startPosition) : "End position must be greater than start position.";
            assert (endPosition <= code.length()) : "End position must be no greater than the length of the code.";
            this.code = code;
            this.startPosition = startPosition;
            this.endPosition = endPosition;
        }

        public ScriptSource(String code) {
            this(Objects.requireNonNull(code), 0, code.length());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScriptSource that = (ScriptSource)o;
            return this.getEndPosition() == that.getEndPosition() && this.getStartPosition() == that.getStartPosition() && this.getCode().equals(that.getCode());
        }

        public String getCode() {
            return this.code;
        }

        public String getCodeSnippet() {
            return this.code.substring(this.startPosition, this.endPosition);
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int hashCode() {
            return Objects.hash(this.getCode(), this.getEndPosition(), this.getStartPosition());
        }

        public ScriptSource setCodeSnippet(String codeSnippet) {
            if (codeSnippet != null && codeSnippet.length() > 0) {
                int originalCodeLength = this.code.length();
                int codeSnippetLength = codeSnippet.length();
                int newCodeLength = originalCodeLength - (this.endPosition - this.startPosition) + codeSnippetLength;
                StringBuilder sb = new StringBuilder(newCodeLength);
                sb.append(this.code, 0, this.startPosition);
                sb.append(codeSnippet);
                sb.append(this.code, this.endPosition, originalCodeLength);
                return new ScriptSource(sb.toString(), this.startPosition, this.startPosition + codeSnippetLength);
            }
            return this;
        }
    }

    public static final class ScopeInfos
    implements IJavetClosable {
        private static final int INDEX_SCOPE_END_POSITION = 4;
        private static final int INDEX_SCOPE_HAS_CONTEXT = 2;
        private static final int INDEX_SCOPE_OBJECT = 1;
        private static final int INDEX_SCOPE_START_POSITION = 3;
        private static final int INDEX_SCOPE_TYPE = 0;
        private final List<ScopeInfo> scopeInfos;

        ScopeInfos(IV8ValueArray iV8ValueArray) throws JavetException {
            this.scopeInfos = ScopeInfos.createFrom(iV8ValueArray);
        }

        private static List<ScopeInfo> createFrom(IV8ValueArray iV8ValueArray) throws JavetException {
            ArrayList<ScopeInfo> values = new ArrayList<ScopeInfo>();
            if (iV8ValueArray != null) {
                iV8ValueArray.forEach(v8Value -> {
                    if (v8Value instanceof V8ValueArray) {
                        V8ValueArray innerV8ValueArray = (V8ValueArray)v8Value;
                        ScopeInfo scopeInfo = new ScopeInfo(V8ScopeType.parse(innerV8ValueArray.getInteger(0)), (V8ValueObject)innerV8ValueArray.get(1), innerV8ValueArray.getBoolean(2), innerV8ValueArray.getInteger(3), innerV8ValueArray.getInteger(4));
                        values.add(scopeInfo);
                    }
                });
            }
            return values;
        }

        @Override
        public void close() throws JavetException {
            for (ScopeInfo value : this.scopeInfos) {
                value.close();
            }
        }

        public ScopeInfo get(int index) {
            return this.scopeInfos.get(index);
        }

        public List<List<String>> getVariablesInClosure() throws JavetException {
            ArrayList<List<String>> variablesList = new ArrayList<List<String>>();
            for (ScopeInfo scopeInfo : this.scopeInfos) {
                variablesList.add(scopeInfo.getScopeObject().getOwnPropertyNameStrings());
            }
            return variablesList;
        }

        public boolean hasVariablesInClosure() throws JavetException {
            for (V8ValueObject v8ValueObject : this.scopeInfos.stream().filter(scopeInfo -> scopeInfo.getType() == V8ScopeType.Closure).map(ScopeInfo::getScopeObject).collect(Collectors.toList())) {
                IV8ValueArray iV8ValueArray = v8ValueObject.getOwnPropertyNames();
                Throwable throwable = null;
                try {
                    if (iV8ValueArray.getLength() <= 0) continue;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iV8ValueArray == null) continue;
                    if (throwable != null) {
                        try {
                            iV8ValueArray.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iV8ValueArray.close();
                }
            }
            return false;
        }

        @Override
        public boolean isClosed() {
            return this.scopeInfos.stream().allMatch(ScopeInfo::isClosed);
        }

        public int size() {
            return this.scopeInfos.size();
        }
    }

    public static final class ScopeInfo
    implements IJavetClosable {
        private final boolean context;
        private final int endPosition;
        private final V8ValueObject scopeObject;
        private final int startPosition;
        private final V8ScopeType type;

        ScopeInfo(V8ScopeType type, V8ValueObject scopeObject, boolean context, int startPosition, int endPosition) {
            this.context = context;
            this.endPosition = endPosition;
            this.scopeObject = scopeObject;
            this.startPosition = startPosition;
            this.type = type;
        }

        @Override
        public void close() throws JavetException {
            this.scopeObject.close();
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public V8ValueObject getScopeObject() {
            return this.scopeObject;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public V8ScopeType getType() {
            return this.type;
        }

        public boolean hasContext() {
            return this.context;
        }

        @Override
        public boolean isClosed() {
            return this.scopeObject.isClosed();
        }
    }

    public static final class GetScopeInfosOptions
    implements Cloneable {
        public static final GetScopeInfosOptions Default = new GetScopeInfosOptions();
        private boolean includeGlobalVariables;
        private boolean includeScopeTypeGlobal;

        public GetScopeInfosOptions() {
            this.setIncludeGlobalVariables(false);
            this.setIncludeScopeTypeGlobal(false);
        }

        protected GetScopeInfosOptions clone() {
            return new GetScopeInfosOptions().setIncludeGlobalVariables(this.isIncludeGlobalVariables()).setIncludeScopeTypeGlobal(this.isIncludeScopeTypeGlobal());
        }

        public boolean isIncludeGlobalVariables() {
            return this.includeGlobalVariables;
        }

        public boolean isIncludeScopeTypeGlobal() {
            return this.includeScopeTypeGlobal;
        }

        private GetScopeInfosOptions setIncludeGlobalVariables(boolean includeGlobalVariables) {
            this.includeGlobalVariables = includeGlobalVariables;
            return this;
        }

        private GetScopeInfosOptions setIncludeScopeTypeGlobal(boolean includeScopeTypeGlobal) {
            this.includeScopeTypeGlobal = includeScopeTypeGlobal;
            return this;
        }

        public GetScopeInfosOptions withIncludeGlobalVariables(boolean includeGlobalVariables) {
            return this.clone().setIncludeGlobalVariables(includeGlobalVariables);
        }

        public GetScopeInfosOptions withIncludeScopeTypeGlobal(boolean includeScopeTypeGlobal) {
            return this.clone().setIncludeScopeTypeGlobal(includeScopeTypeGlobal);
        }
    }
}

