/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.proxy.BaseJavetProxyHandler;
import com.caoccao.javet.interop.proxy.IJavetDynamicObjectFactory;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

final class JavetDynamicProxyInterceptor {
    private static final String METHOD_NAME_INVOKE = "invoke";
    private final IJavetDynamicObjectFactory dynamicObjectFactory;
    private final String jsMethodName;
    private final List<Method> methods;
    private final Object targetObject;

    public JavetDynamicProxyInterceptor(IJavetDynamicObjectFactory dynamicObjectFactory, Object targetObject, String jsMethodName, List<Method> methods) {
        this.dynamicObjectFactory = dynamicObjectFactory;
        this.jsMethodName = jsMethodName;
        this.methods = methods;
        this.targetObject = targetObject;
    }

    public JavetCallbackContext getCallbackContext() {
        try {
            return new JavetCallbackContext(this, this.getClass().getMethod(METHOD_NAME_INVOKE, V8ValueObject.class, V8Value[].class), true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public String getJSMethodName() {
        return this.jsMethodName;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public Object invoke(V8ValueObject thisObject, V8Value ... v8Values) throws JavetException {
        try {
            return BaseJavetProxyHandler.execute(this.dynamicObjectFactory, this.targetObject, thisObject, this.methods, V8ValueUtils.convertToVirtualObjects(v8Values));
        }
        catch (JavetException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", this.jsMethodName, "message", e.getTargetException().getMessage()), e.getTargetException());
        }
        catch (Throwable t) {
            throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", this.jsMethodName, "message", t.getMessage()), t);
        }
    }
}

