/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.executors;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.executors.V8StringExecutor;
import com.caoccao.javet.utils.SimpleMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class V8FileExecutor
extends V8StringExecutor {
    protected File scriptFile;

    public V8FileExecutor(V8Runtime v8Runtime, File scriptFile) throws JavetException {
        super(v8Runtime);
        this.scriptFile = scriptFile;
        this.setResourceName(scriptFile.getAbsolutePath());
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    @Override
    public String getScriptString() throws JavetException {
        if (this.scriptString == null) {
            try (FileInputStream fileInputStream = new FileInputStream(this.scriptFile);){
                byte[] buffer = new byte[fileInputStream.available()];
                fileInputStream.read(buffer);
                this.scriptString = new String(buffer, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new JavetException(JavetError.FailedToReadPath, SimpleMap.of("path", this.scriptFile), e);
            }
        }
        return this.scriptString;
    }
}

