/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.JSFunctionType;
import com.caoccao.javet.enums.JSScopeType;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.IV8ValueFunction;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.virtual.V8VirtualValueList;

public class V8ValueFunction
extends V8ValueObject
implements IV8ValueFunction {
    protected JSFunctionType jsFunctionType = null;

    protected V8ValueFunction(V8Runtime v8Runtime, long handle) throws JavetException {
        super(v8Runtime, handle);
    }

    @Override
    public <T extends V8Value> T callAsConstructor(Object ... objects) throws JavetException {
        try (V8VirtualValueList virtualValueList = new V8VirtualValueList(this.checkV8Runtime(), null, objects);){
            Object t = this.v8Runtime.getV8Internal().callAsConstructor(this, virtualValueList.get());
            return t;
        }
    }

    @Override
    public <T extends V8Value> T callAsConstructor(V8Value ... v8Values) throws JavetException {
        return this.checkV8Runtime().getV8Internal().callAsConstructor(this, v8Values);
    }

    @Override
    public <T extends V8Value> T callExtended(IV8ValueObject receiver, boolean returnResult, Object ... objects) throws JavetException {
        try (V8VirtualValueList virtualValueList = new V8VirtualValueList(this.checkV8Runtime(), null, objects);){
            Object t = this.v8Runtime.getV8Internal().call(this, receiver, returnResult, virtualValueList.get());
            return t;
        }
    }

    @Override
    public <T extends V8Value> T callExtended(IV8ValueObject receiver, boolean returnResult, V8Value ... v8Values) throws JavetException {
        return this.checkV8Runtime().getV8Internal().call(this, receiver, returnResult, v8Values);
    }

    @Override
    public IV8ValueArray getInternalProperties() throws JavetException {
        return this.checkV8Runtime().getV8Internal().getInternalProperties(this);
    }

    @Override
    public JSFunctionType getJSFunctionType() throws JavetException {
        if (this.jsFunctionType == null) {
            this.jsFunctionType = this.checkV8Runtime().getV8Internal().getJSFunctionType(this);
        }
        return this.jsFunctionType;
    }

    @Override
    public JSScopeType getJSScopeType() throws JavetException {
        return this.checkV8Runtime().getV8Internal().getJSScopeType(this);
    }

    @Override
    public String getSourceCode() throws JavetException {
        if (this.getJSFunctionType().isUserDefined()) {
            return this.checkV8Runtime().getV8Internal().getSourceCode(this);
        }
        return null;
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.Function;
    }

    @Override
    public boolean setSourceCode(String sourceCodeString) throws JavetException {
        boolean success = false;
        if (this.getJSFunctionType().isUserDefined() && sourceCodeString != null && sourceCodeString.length() > 0) {
            this.checkV8Runtime();
            this.v8Runtime.lowMemoryNotification();
            success = this.v8Runtime.getV8Internal().setSourceCode(this, sourceCodeString);
            this.v8Runtime.lowMemoryNotification();
        }
        return success;
    }
}

