/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.annotations.V8Function;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.proxy.DynamicProxyV8ValueFunctionInvocationHandler;
import com.caoccao.javet.interop.proxy.DynamicProxyV8ValueObjectInvocationHandler;
import com.caoccao.javet.utils.JavetTypeUtils;
import com.caoccao.javet.utils.JavetVirtualObject;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueProxy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

final class ScoredExecutable<E extends AccessibleObject> {
    private static final Class<?> V8_VALUE_CLASS = V8Value.class;
    private static final Class<?> V8_VALUE_FUNCTION_CLASS = V8ValueFunction.class;
    private static final Class<?> V8_VALUE_OBJECT_CLASS = V8ValueObject.class;
    private static final Class<?> V8_VALUE_PROXY_CLASS = V8ValueProxy.class;
    private final E executable;
    private final Object targetObject;
    private final V8ValueObject thisObject;
    private JavetVirtualObject[] javetVirtualObjects;
    private double score;

    public ScoredExecutable(Object targetObject, V8ValueObject thisObject, E executable, JavetVirtualObject[] javetVirtualObjects) {
        this.executable = executable;
        this.javetVirtualObjects = javetVirtualObjects;
        this.score = 0.0;
        this.targetObject = targetObject;
        this.thisObject = thisObject;
    }

    public void calculateScore() throws JavetException {
        Method method;
        boolean isConstructor = this.executable instanceof Constructor;
        Class<?>[] parameterTypes = isConstructor ? ((Constructor)this.executable).getParameterTypes() : ((Method)this.executable).getParameterTypes();
        boolean isExecutableVarArgs = isConstructor ? ((Constructor)this.executable).isVarArgs() : ((Method)this.executable).isVarArgs();
        boolean thisObjectRequired = false;
        if (!isConstructor && (method = (Method)this.executable).isAnnotationPresent(V8Function.class)) {
            V8Function v8Function = method.getAnnotation(V8Function.class);
            thisObjectRequired = v8Function.thisObjectRequired();
        }
        if (thisObjectRequired) {
            JavetVirtualObject[] javetVirtualObjectsWithThis = new JavetVirtualObject[this.javetVirtualObjects.length + 1];
            javetVirtualObjectsWithThis[0] = new JavetVirtualObject(this.thisObject);
            System.arraycopy(this.javetVirtualObjects, 0, javetVirtualObjectsWithThis, 1, this.javetVirtualObjects.length);
            this.javetVirtualObjects = javetVirtualObjectsWithThis;
        }
        int parameterCount = parameterTypes.length;
        this.score = 0.0;
        int length = this.javetVirtualObjects.length;
        if (length == 0) {
            if (isExecutableVarArgs) {
                if (parameterCount == 1) {
                    this.score = 0.99;
                }
            } else if (parameterCount == 0) {
                this.score = 1.0;
            }
        } else {
            boolean isFixedArgs;
            boolean isVarArgs = isExecutableVarArgs && length >= parameterCount - 1;
            boolean bl = isFixedArgs = !isExecutableVarArgs && length == parameterCount;
            if (isVarArgs || isFixedArgs) {
                Object object;
                V8Value v8Value;
                double totalScore = 0.0;
                int fixedParameterCount = isExecutableVarArgs ? parameterCount - 1 : parameterCount;
                for (int i = 0; i < fixedParameterCount; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    v8Value = this.javetVirtualObjects[i].getV8Value();
                    if (v8Value != null) {
                        if (V8_VALUE_CLASS.isAssignableFrom(parameterType) && parameterType.isAssignableFrom(v8Value.getClass())) {
                            totalScore += 1.0;
                            continue;
                        }
                        if (parameterType.isInterface()) {
                            if (V8_VALUE_FUNCTION_CLASS.isAssignableFrom(v8Value.getClass())) {
                                totalScore += 0.95;
                                continue;
                            }
                            if (!V8_VALUE_PROXY_CLASS.isAssignableFrom(v8Value.getClass()) && V8_VALUE_OBJECT_CLASS.isAssignableFrom(v8Value.getClass())) {
                                totalScore += 0.85;
                                continue;
                            }
                        }
                    }
                    if ((object = this.javetVirtualObjects[i].getObject()) == null) {
                        if (parameterType.isPrimitive()) {
                            totalScore = 0.0;
                            break;
                        }
                        totalScore += 0.9;
                        continue;
                    }
                    if (parameterType.isAssignableFrom(object.getClass())) {
                        totalScore += 0.9;
                        continue;
                    }
                    if (parameterType.isPrimitive() && JavetTypeUtils.toExactPrimitive(parameterType, object) != null) {
                        totalScore += 0.8;
                        continue;
                    }
                    if (JavetTypeUtils.toApproximatePrimitive(parameterType, object) != null) {
                        totalScore += 0.7;
                        continue;
                    }
                    totalScore = 0.0;
                    break;
                }
                if ((fixedParameterCount == 0 || fixedParameterCount > 0 && totalScore > 0.0) && isVarArgs) {
                    Class<?> componentType = parameterTypes[fixedParameterCount].getComponentType();
                    for (int i = fixedParameterCount; i < length; ++i) {
                        v8Value = this.javetVirtualObjects[i].getV8Value();
                        if (v8Value != null) {
                            if (V8_VALUE_CLASS.isAssignableFrom(componentType) && componentType.isAssignableFrom(v8Value.getClass())) {
                                totalScore += 0.95;
                                continue;
                            }
                            if (componentType.isInterface()) {
                                if (V8_VALUE_FUNCTION_CLASS.isAssignableFrom(v8Value.getClass())) {
                                    totalScore += 0.95;
                                    continue;
                                }
                                if (!V8_VALUE_PROXY_CLASS.isAssignableFrom(v8Value.getClass()) && V8_VALUE_OBJECT_CLASS.isAssignableFrom(v8Value.getClass())) {
                                    totalScore += 0.85;
                                    continue;
                                }
                            }
                        }
                        if ((object = this.javetVirtualObjects[i].getObject()) == null) {
                            if (componentType.isPrimitive()) {
                                totalScore = 0.0;
                                break;
                            }
                            totalScore += 0.85;
                            continue;
                        }
                        if (componentType.isAssignableFrom(object.getClass())) {
                            totalScore += 0.85;
                            continue;
                        }
                        if (componentType.isPrimitive() && JavetTypeUtils.toExactPrimitive(componentType, object) != null) {
                            totalScore += 0.75;
                            continue;
                        }
                        if (JavetTypeUtils.toApproximatePrimitive(componentType, object) != null) {
                            totalScore += 0.65;
                            continue;
                        }
                        totalScore = 0.0;
                        break;
                    }
                }
                if (totalScore > 0.0) {
                    this.score = totalScore / (double)length;
                    if (isConstructor) {
                        if (this.targetObject != null && ((Constructor)this.executable).getDeclaringClass() != this.targetObject.getClass()) {
                            this.score *= 0.9;
                        }
                    } else if (this.targetObject != null && ((Method)this.executable).getDeclaringClass() != this.targetObject.getClass()) {
                        this.score *= 0.9;
                    }
                }
            }
        }
    }

    public Object execute() throws Throwable {
        boolean isExecutableVarArgs;
        int length = this.javetVirtualObjects.length;
        Object callee = Modifier.isStatic(((Member)this.executable).getModifiers()) ? null : this.targetObject;
        Class<?>[] parameterTypes = this.executable instanceof Constructor ? ((Constructor)this.executable).getParameterTypes() : ((Method)this.executable).getParameterTypes();
        int parameterCount = parameterTypes.length;
        boolean bl = isExecutableVarArgs = this.executable instanceof Constructor ? ((Constructor)this.executable).isVarArgs() : ((Method)this.executable).isVarArgs();
        if (length == 0) {
            if (isExecutableVarArgs) {
                Class<?> componentType = parameterTypes[parameterCount - 1].getComponentType();
                Object varObject = Array.newInstance(componentType, 0);
                if (this.executable instanceof Constructor) {
                    return ((Constructor)this.executable).newInstance(varObject);
                }
                return ((Method)this.executable).invoke(callee, varObject);
            }
            if (this.executable instanceof Constructor) {
                return ((Constructor)this.executable).newInstance(new Object[0]);
            }
            return ((Method)this.executable).invoke(callee, new Object[0]);
        }
        ArrayList<Object> parameters = new ArrayList<Object>();
        int fixedParameterCount = isExecutableVarArgs ? parameterCount - 1 : parameterCount;
        for (int i = 0; i < fixedParameterCount; ++i) {
            Object object;
            Class<?> parameterType = parameterTypes[i];
            V8Value v8Value = this.javetVirtualObjects[i].getV8Value();
            Object parameter = object = this.javetVirtualObjects[i].getObject();
            boolean conversionRequired = true;
            if (v8Value != null) {
                if (V8_VALUE_CLASS.isAssignableFrom(parameterType) && parameterType.isAssignableFrom(v8Value.getClass())) {
                    parameter = v8Value;
                    conversionRequired = false;
                } else if (object != null && parameterType.isAssignableFrom(object.getClass())) {
                    parameter = object;
                    conversionRequired = false;
                } else if (parameterType.isInterface()) {
                    if (V8_VALUE_FUNCTION_CLASS.isAssignableFrom(v8Value.getClass())) {
                        DynamicProxyV8ValueFunctionInvocationHandler invocationHandler = new DynamicProxyV8ValueFunctionInvocationHandler((V8ValueFunction)v8Value.toClone());
                        parameter = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{parameterType, AutoCloseable.class}, (InvocationHandler)invocationHandler);
                        conversionRequired = false;
                    } else if (!V8_VALUE_PROXY_CLASS.isAssignableFrom(v8Value.getClass()) && V8_VALUE_OBJECT_CLASS.isAssignableFrom(v8Value.getClass())) {
                        DynamicProxyV8ValueObjectInvocationHandler invocationHandler = new DynamicProxyV8ValueObjectInvocationHandler((V8ValueObject)v8Value.toClone());
                        parameter = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{parameterType, AutoCloseable.class}, (InvocationHandler)invocationHandler);
                        conversionRequired = false;
                    }
                }
            }
            if (conversionRequired && object != null && !parameterType.isAssignableFrom(object.getClass())) {
                Object approximatePrimitiveValue;
                Object primitiveObject;
                boolean primitiveFound = false;
                if (parameterType.isPrimitive() && (primitiveObject = JavetTypeUtils.toExactPrimitive(parameterType, object)) != null) {
                    parameter = primitiveObject;
                    primitiveFound = true;
                }
                if (!primitiveFound && (approximatePrimitiveValue = JavetTypeUtils.toApproximatePrimitive(parameterType, object)) != null) {
                    parameter = approximatePrimitiveValue;
                }
            }
            parameters.add(parameter);
        }
        if (isExecutableVarArgs) {
            Class<?> componentType = parameterTypes[fixedParameterCount].getComponentType();
            Object varObject = Array.newInstance(componentType, length - fixedParameterCount);
            for (int i = fixedParameterCount; i < length; ++i) {
                Object object;
                V8Value v8Value = this.javetVirtualObjects[i].getV8Value();
                Object parameter = object = this.javetVirtualObjects[i].getObject();
                boolean conversionRequired = true;
                if (v8Value != null) {
                    if (V8_VALUE_CLASS.isAssignableFrom(componentType) && componentType.isAssignableFrom(v8Value.getClass())) {
                        parameter = v8Value;
                        conversionRequired = false;
                    } else if (object != null && componentType.isAssignableFrom(object.getClass())) {
                        conversionRequired = false;
                    } else if (componentType.isInterface()) {
                        if (V8_VALUE_FUNCTION_CLASS.isAssignableFrom(v8Value.getClass())) {
                            DynamicProxyV8ValueFunctionInvocationHandler invocationHandler = new DynamicProxyV8ValueFunctionInvocationHandler((V8ValueFunction)v8Value.toClone());
                            parameter = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{componentType, AutoCloseable.class}, (InvocationHandler)invocationHandler);
                            conversionRequired = false;
                        } else if (!V8_VALUE_PROXY_CLASS.isAssignableFrom(v8Value.getClass()) && V8_VALUE_OBJECT_CLASS.isAssignableFrom(v8Value.getClass())) {
                            DynamicProxyV8ValueObjectInvocationHandler invocationHandler = new DynamicProxyV8ValueObjectInvocationHandler((V8ValueObject)v8Value.toClone());
                            parameter = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{componentType, AutoCloseable.class}, (InvocationHandler)invocationHandler);
                            conversionRequired = false;
                        }
                    }
                }
                if (conversionRequired && object != null && !componentType.isAssignableFrom(object.getClass())) {
                    Object approximatePrimitiveValue;
                    Object primitiveObject;
                    boolean primitiveFound = false;
                    if (componentType.isPrimitive() && (primitiveObject = JavetTypeUtils.toExactPrimitive(componentType, object)) != null) {
                        parameter = primitiveObject;
                        primitiveFound = true;
                    }
                    if (!primitiveFound && (approximatePrimitiveValue = JavetTypeUtils.toApproximatePrimitive(componentType, object)) != null) {
                        parameter = approximatePrimitiveValue;
                    }
                }
                Array.set(varObject, i - fixedParameterCount, parameter);
            }
            parameters.add(varObject);
        }
        if (this.executable instanceof Constructor) {
            return ((Constructor)this.executable).newInstance(parameters.toArray());
        }
        return ((Method)this.executable).invoke(callee, parameters.toArray());
    }

    public double getScore() {
        return this.score;
    }
}

