/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.proxy.BaseJavetProxyHandler;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

final class JavetUniversalInterceptor {
    private static final String METHOD_NAME_INVOKE = "invoke";
    private final String jsMethodName;
    private final List<Method> methods;
    private final Object targetObject;
    private final V8Runtime v8Runtime;

    public JavetUniversalInterceptor(V8Runtime v8Runtime, Object targetObject, String jsMethodName, List<Method> methods) {
        this.jsMethodName = jsMethodName;
        this.methods = methods;
        this.targetObject = targetObject;
        this.v8Runtime = v8Runtime;
    }

    public JavetCallbackContext getCallbackContext() {
        try {
            return new JavetCallbackContext(this, this.getClass().getMethod(METHOD_NAME_INVOKE, V8ValueObject.class, V8Value[].class), true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public String getJSMethodName() {
        return this.jsMethodName;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    public Object getTargetObject() {
        return this.targetObject;
    }

    public Object invoke(V8ValueObject thisObject, V8Value ... v8Values) throws JavetException {
        try {
            return BaseJavetProxyHandler.execute(this.targetObject, thisObject, this.methods, V8ValueUtils.convertToVirtualObjects(v8Values));
        }
        catch (JavetException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", this.jsMethodName, "message", e.getTargetException().getMessage()), e.getTargetException());
        }
        catch (Throwable t) {
            throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", this.jsMethodName, "message", t.getMessage()), t);
        }
    }
}

