/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.proxy.BaseJavetProxySymbolConverter;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueString;

public class JavetProxySymbolToPrimitiveConverter<T>
extends BaseJavetProxySymbolConverter<T> {
    protected static final String HINT_BOOLEAN = "boolean";
    protected static final String HINT_DEFAULT = "default";
    protected static final String HINT_NUMBER = "number";
    protected static final String HINT_STRING = "string";

    public JavetProxySymbolToPrimitiveConverter(V8Runtime v8Runtime, T targetObject) {
        super(v8Runtime, targetObject);
    }

    @Override
    public V8Value toV8Value(V8Value ... v8Values) throws JavetException {
        if (this.targetObject != null && v8Values.length > 0 && v8Values[0] instanceof V8ValueString) {
            String hintString = (String)((V8ValueString)v8Values[0]).getValue();
            if (HINT_NUMBER.equals(hintString)) {
                if (this.targetObject instanceof Integer) {
                    return this.v8Runtime.createV8ValueInteger((Integer)this.targetObject);
                }
                if (this.targetObject instanceof Double) {
                    return this.v8Runtime.createV8ValueDouble((Double)this.targetObject);
                }
                if (this.targetObject instanceof Long) {
                    return this.v8Runtime.createV8ValueInteger(((Long)this.targetObject).intValue());
                }
                if (this.targetObject instanceof Float) {
                    return this.v8Runtime.createV8ValueDouble(((Float)this.targetObject).doubleValue());
                }
                return this.v8Runtime.createV8ValueInteger(0);
            }
            if (HINT_STRING.equals(hintString)) {
                return this.v8Runtime.createV8ValueString(this.targetObject.toString());
            }
            if (HINT_BOOLEAN.equals(hintString)) {
                if (this.targetObject instanceof Boolean) {
                    return this.v8Runtime.createV8ValueBoolean((Boolean)this.targetObject);
                }
                return this.v8Runtime.createV8ValueBoolean(false);
            }
            if (HINT_DEFAULT.equals(hintString)) {
                if (this.targetObject instanceof Integer) {
                    return this.v8Runtime.createV8ValueInteger((Integer)this.targetObject);
                }
                if (this.targetObject instanceof Double) {
                    return this.v8Runtime.createV8ValueDouble((Double)this.targetObject);
                }
                if (this.targetObject instanceof Long) {
                    return this.v8Runtime.createV8ValueLong((Long)this.targetObject);
                }
                if (this.targetObject instanceof Float) {
                    return this.v8Runtime.createV8ValueDouble(((Float)this.targetObject).doubleValue());
                }
                if (this.targetObject instanceof Boolean) {
                    return this.v8Runtime.createV8ValueBoolean((Boolean)this.targetObject);
                }
                return this.v8Runtime.createV8ValueString(this.targetObject.toString());
            }
        }
        return super.toV8Value(v8Values);
    }
}

