/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.annotations.V8Function;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public final class DynamicProxyV8ValueObjectInvocationHandler
implements InvocationHandler,
IJavetClosable {
    private static final String METHOD_NAME_CLOSE = "close";
    private V8ValueObject v8ValueObject;

    public DynamicProxyV8ValueObjectInvocationHandler(V8ValueObject v8ValueObject) {
        this.v8ValueObject = v8ValueObject;
    }

    @Override
    public void close() throws JavetException {
        JavetResourceUtils.safeClose((Object)this.v8ValueObject);
        this.v8ValueObject = null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        Object result = null;
        if (args == null) {
            args = new Object[]{};
        }
        if ((methodName = method.getName()).equals(METHOD_NAME_CLOSE) && args.length == 0) {
            this.close();
        } else if (this.v8ValueObject != null && !this.v8ValueObject.isClosed()) {
            String aliasMethodName;
            if (method.isAnnotationPresent(V8Function.class) && (aliasMethodName = method.getAnnotation(V8Function.class).name()) != null && aliasMethodName.length() > 0) {
                methodName = aliasMethodName;
            }
            result = this.v8ValueObject.invokeObject(methodName, args);
        }
        return result;
    }

    @Override
    public boolean isClosed() {
        return this.v8ValueObject == null || this.v8ValueObject.isClosed();
    }
}

