/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.executors;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.executors.V8StringExecutor;
import com.caoccao.javet.utils.SimpleMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class V8PathExecutor
extends V8StringExecutor {
    protected Path scriptPath;

    public V8PathExecutor(V8Runtime v8Runtime, Path scriptPath) throws JavetException {
        super(v8Runtime);
        this.scriptPath = scriptPath;
        this.setResourceName(scriptPath.toString());
    }

    public Path getScriptPath() {
        return this.scriptPath;
    }

    @Override
    public String getScriptString() throws JavetException {
        if (this.scriptString == null) {
            try (FileInputStream fileInputStream = new FileInputStream(this.scriptPath.toString());){
                byte[] buffer = new byte[fileInputStream.available()];
                fileInputStream.read(buffer);
                this.scriptString = new String(buffer, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new JavetException(JavetError.FailedToReadPath, SimpleMap.of("path", this.scriptPath), e);
            }
        }
        return this.scriptString;
    }
}

