/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine;

import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.engine.JavetEnginePool;
import com.caoccao.javet.utils.JavetDefaultLogger;
import com.caoccao.javet.utils.JavetOSUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public final class JavetEngineConfig {
    public static final int DEFAULT_ENGINE_GUARD_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_ENGINE_GUARD_CHECK_INTERVAL_MILLIS = 1000;
    public static final JSRuntimeType DEFAULT_JS_RUNTIME_TYPE = JSRuntimeType.V8;
    public static final int DEFAULT_POOL_MIN_SIZE = 1;
    public static final int DEFAULT_POOL_IDLE_TIMEOUT_SECONDS = 60;
    public static final int DEFAULT_POOL_DAEMON_CHECK_INTERVAL_MILLIS = 1000;
    public static final int DEFAULT_RESET_ENGINE_TIMEOUT_SECONDS = 3600;
    public static final int DEFAULT_POOL_SHUTDOWN_TIMEOUT_SECONDS = 5;
    public static final int DEFAULT_WAIT_FOR_ENGINE_LOG_INTERVAL_MILLIS = 1000;
    public static final int MAX_POOL_SIZE = 4096;
    public static final int DEFAULT_WAIT_FOR_ENGINE_MAX_RETRY_COUNT = 500;
    protected static final int[] DEFAULT_WAIT_FOR_ENGINE_SLEEP_INTERVAL_MILLIS = new int[]{5, 6, 7, 8, 9, 10};
    public static IJavetLogger DEFAULT_JAVET_LOGGER = new JavetDefaultLogger(JavetEnginePool.class.getName());
    private boolean allowEval;
    private boolean autoSendGCNotification;
    private int defaultEngineGuardTimeoutMillis;
    private int engineGuardCheckIntervalMillis;
    private ExecutorService executorService;
    private boolean gcBeforeEngineClose;
    private String globalName;
    private IJavetLogger javetLogger;
    private JSRuntimeType jsRuntimeType;
    private int poolDaemonCheckIntervalMillis;
    private int poolIdleTimeoutSeconds;
    private int poolMaxSize;
    private int poolMinSize;
    private int poolShutdownTimeoutSeconds;
    private boolean poolSizeFrozen;
    private int resetEngineTimeoutSeconds;
    private int waitForEngineLogIntervalMillis;
    private int waitForEngineMaxRetryCount;
    private int[] waitForEngineSleepIntervalMillis;

    public JavetEngineConfig() {
        this.setJavetLogger(DEFAULT_JAVET_LOGGER);
        this.setGlobalName(null);
        this.setAllowEval(false);
        this.setAutoSendGCNotification(true);
        this.setDefaultEngineGuardTimeoutMillis(30000);
        this.setEngineGuardCheckIntervalMillis(1000);
        this.setGCBeforeEngineClose(false);
        this.setJSRuntimeType(DEFAULT_JS_RUNTIME_TYPE);
        this.poolSizeFrozen = false;
        int cpuCount = JavetOSUtils.getCPUCount();
        this.setPoolMinSize(Math.max(1, cpuCount >> 1));
        this.setPoolMaxSize(Math.max(1, cpuCount));
        this.setPoolIdleTimeoutSeconds(60);
        this.setPoolShutdownTimeoutSeconds(5);
        this.setPoolDaemonCheckIntervalMillis(1000);
        this.setResetEngineTimeoutSeconds(3600);
        this.setWaitForEngineLogIntervalMillis(1000);
        this.setWaitForEngineMaxRetryCount(500);
        this.setWaitForEngineSleepIntervalMillis(DEFAULT_WAIT_FOR_ENGINE_SLEEP_INTERVAL_MILLIS);
    }

    public JavetEngineConfig freezePoolSize() {
        if (!this.poolSizeFrozen) {
            this.poolSizeFrozen = true;
        }
        return this;
    }

    public int getDefaultEngineGuardTimeoutMillis() {
        return this.defaultEngineGuardTimeoutMillis;
    }

    public int getEngineGuardCheckIntervalMillis() {
        return this.engineGuardCheckIntervalMillis;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public JSRuntimeType getJSRuntimeType() {
        return this.jsRuntimeType;
    }

    public IJavetLogger getJavetLogger() {
        return this.javetLogger;
    }

    public int getPoolDaemonCheckIntervalMillis() {
        return this.poolDaemonCheckIntervalMillis;
    }

    public int getPoolIdleTimeoutSeconds() {
        return this.poolIdleTimeoutSeconds;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public int getPoolMinSize() {
        return this.poolMinSize;
    }

    public int getPoolShutdownTimeoutSeconds() {
        return this.poolShutdownTimeoutSeconds;
    }

    public int getResetEngineTimeoutSeconds() {
        return this.resetEngineTimeoutSeconds;
    }

    public int getWaitForEngineLogIntervalMillis() {
        return this.waitForEngineLogIntervalMillis;
    }

    public int getWaitForEngineMaxRetryCount() {
        return this.waitForEngineMaxRetryCount;
    }

    public int[] getWaitForEngineSleepIntervalMillis() {
        return this.waitForEngineSleepIntervalMillis;
    }

    public boolean isAllowEval() {
        return this.allowEval;
    }

    public boolean isAutoSendGCNotification() {
        return this.autoSendGCNotification;
    }

    public boolean isGCBeforeEngineClose() {
        return this.gcBeforeEngineClose;
    }

    public JavetEngineConfig setAllowEval(boolean allowEval) {
        this.allowEval = allowEval;
        return this;
    }

    public JavetEngineConfig setAutoSendGCNotification(boolean autoSendGCNotification) {
        this.autoSendGCNotification = autoSendGCNotification;
        return this;
    }

    public JavetEngineConfig setDefaultEngineGuardTimeoutMillis(int defaultEngineGuardTimeoutMillis) {
        assert (defaultEngineGuardTimeoutMillis > 0) : "The default engine guard timeout millis must be greater than 0.";
        this.defaultEngineGuardTimeoutMillis = defaultEngineGuardTimeoutMillis;
        return this;
    }

    public JavetEngineConfig setEngineGuardCheckIntervalMillis(int engineGuardCheckIntervalMillis) {
        assert (engineGuardCheckIntervalMillis > 0) : "The engine guard check interval millis must be greater than 0.";
        this.engineGuardCheckIntervalMillis = engineGuardCheckIntervalMillis;
        return this;
    }

    JavetEngineConfig setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public JavetEngineConfig setGCBeforeEngineClose(boolean gcBeforeEngineClose) {
        this.gcBeforeEngineClose = gcBeforeEngineClose;
        return this;
    }

    public JavetEngineConfig setGlobalName(String globalName) {
        this.globalName = globalName;
        return this;
    }

    public JavetEngineConfig setJSRuntimeType(JSRuntimeType jsRuntimeType) {
        this.jsRuntimeType = Objects.requireNonNull(jsRuntimeType);
        return this;
    }

    public JavetEngineConfig setJavetLogger(IJavetLogger javetLogger) {
        this.javetLogger = Objects.requireNonNull(javetLogger);
        return this;
    }

    public JavetEngineConfig setPoolDaemonCheckIntervalMillis(int poolDaemonCheckIntervalMillis) {
        assert (poolDaemonCheckIntervalMillis > 0) : "The pool daemon check interval millis must be greater than 0.";
        this.poolDaemonCheckIntervalMillis = poolDaemonCheckIntervalMillis;
        return this;
    }

    public JavetEngineConfig setPoolIdleTimeoutSeconds(int poolIdleTimeoutSeconds) {
        assert (poolIdleTimeoutSeconds > 0) : "The pool idle timeout seconds must be greater than 0.";
        this.poolIdleTimeoutSeconds = poolIdleTimeoutSeconds;
        return this;
    }

    public JavetEngineConfig setPoolMaxSize(int poolMaxSize) {
        assert (poolMaxSize > 0) : "Pool max size must be greater than 0.";
        assert (poolMaxSize <= 4096) : "Pool max size must be no greater than 4096.";
        if (!this.poolSizeFrozen) {
            this.poolMaxSize = poolMaxSize;
        }
        return this;
    }

    public JavetEngineConfig setPoolMinSize(int poolMinSize) {
        assert (poolMinSize > 0) : "Pool min size must be greater than 0.";
        assert (poolMinSize <= 4096) : "Pool min size must be no greater than 4096.";
        if (!this.poolSizeFrozen) {
            this.poolMinSize = poolMinSize;
        }
        return this;
    }

    public JavetEngineConfig setPoolShutdownTimeoutSeconds(int poolShutdownTimeoutSeconds) {
        assert (poolShutdownTimeoutSeconds > 0) : "The pool shutdown timeout seconds must be greater than 0.";
        this.poolShutdownTimeoutSeconds = poolShutdownTimeoutSeconds;
        return this;
    }

    public JavetEngineConfig setResetEngineTimeoutSeconds(int resetEngineTimeoutSeconds) {
        assert (resetEngineTimeoutSeconds > 0) : "The reset engine timeout seconds must be greater than 0.";
        this.resetEngineTimeoutSeconds = resetEngineTimeoutSeconds;
        return this;
    }

    public JavetEngineConfig setWaitForEngineLogIntervalMillis(int waitForEngineLogIntervalMillis) {
        this.waitForEngineLogIntervalMillis = waitForEngineLogIntervalMillis;
        return this;
    }

    public JavetEngineConfig setWaitForEngineMaxRetryCount(int waitForEngineMaxRetryCount) {
        this.waitForEngineMaxRetryCount = waitForEngineMaxRetryCount;
        return this;
    }

    public JavetEngineConfig setWaitForEngineSleepIntervalMillis(int[] waitForEngineSleepIntervalMillis) {
        Objects.requireNonNull(waitForEngineSleepIntervalMillis);
        assert (waitForEngineSleepIntervalMillis.length > 0);
        this.waitForEngineSleepIntervalMillis = Arrays.copyOf(waitForEngineSleepIntervalMillis, waitForEngineSleepIntervalMillis.length);
        return this;
    }
}

