/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.converters;

import com.caoccao.javet.entities.JavetEntityFunction;
import com.caoccao.javet.entities.JavetEntityMap;
import com.caoccao.javet.entities.JavetEntitySymbol;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetEntityFunction;
import com.caoccao.javet.interfaces.IJavetEntityMap;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.converters.JavetPrimitiveConverter;
import com.caoccao.javet.interop.proxy.IJavetProxyHandler;
import com.caoccao.javet.interop.proxy.JavetUniversalProxyObjectHandler;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueProxy;
import com.caoccao.javet.values.reference.V8ValueSet;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import com.caoccao.javet.values.reference.V8ValueTypedArray;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.BaseStream;

public class JavetObjectConverter
extends JavetPrimitiveConverter {
    protected static final int EXECUTABLE_INDEX_DEFAULT_CONSTRUCTOR = 0;
    protected static final int EXECUTABLE_INDEX_FROM_MAP = 1;
    protected static final int EXECUTABLE_INDEX_TO_MAP = 2;
    protected static final String METHOD_NAME_FROM_MAP = "fromMap";
    protected static final String METHOD_NAME_TO_MAP = "toMap";
    protected static final String PRIVATE_PROPERTY_CUSTOM_OBJECT_CLASS_NAME = "JavetObjectConverter#customObjectClassName";
    protected static final String PRIVATE_PROPERTY_PROXY_TARGET = "Javet#proxyTarget";
    protected static final String PROPERTY_NAME = "name";
    protected static final String PUBLIC_PROPERTY_CONSTRUCTOR = "constructor";
    protected Map<String, AccessibleObject[]> customObjectMap = new ConcurrentHashMap<String, AccessibleObject[]>();

    protected IJavetEntityFunction createEntityFunction() {
        return new JavetEntityFunction();
    }

    protected Map<String, Object> createEntityMap() {
        return new JavetEntityMap();
    }

    public boolean registerCustomObject(Class<?> customObjectClass) {
        return this.registerCustomObject(customObjectClass, METHOD_NAME_FROM_MAP, METHOD_NAME_TO_MAP);
    }

    public boolean registerCustomObject(Class<?> customObjectClass, String methodNameFromMap, String methodNameToMap) {
        if (customObjectClass == null || methodNameFromMap == null || methodNameToMap == null || methodNameFromMap.length() == 0 || methodNameToMap.length() == 0 || methodNameFromMap.equals(methodNameToMap)) {
            return false;
        }
        String customObjectClassName = customObjectClass.getName();
        if (this.customObjectMap.containsKey(customObjectClassName)) {
            return false;
        }
        try {
            Constructor<?> defaultConstructor = customObjectClass.getConstructor(new Class[0]);
            Method methodFromMap = customObjectClass.getMethod(methodNameFromMap, Map.class);
            if (Modifier.isStatic(methodFromMap.getModifiers())) {
                return false;
            }
            Method methodToMap = customObjectClass.getMethod(methodNameToMap, new Class[0]);
            if (Modifier.isStatic(methodToMap.getModifiers())) {
                return false;
            }
            AccessibleObject[] executables = new AccessibleObject[]{defaultConstructor, methodFromMap, methodToMap};
            this.customObjectMap.put(customObjectClass.getName(), executables);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return false;
    }

    @Override
    protected <T> T toObject(V8Value v8Value, int depth) throws JavetException {
        Object returnObject = super.toObject(v8Value, depth);
        if (!(returnObject instanceof V8Value)) {
            return returnObject;
        }
        if (v8Value instanceof V8ValueArray) {
            V8ValueArray v8ValueArray = (V8ValueArray)v8Value;
            ArrayList list = new ArrayList();
            v8ValueArray.forEach(value -> list.add(this.toObject(value, depth + 1)));
            return (T)list;
        }
        if (v8Value instanceof V8ValueSet) {
            V8ValueSet v8ValueSet = (V8ValueSet)v8Value;
            HashSet set = new HashSet();
            v8ValueSet.forEach(key -> set.add(this.toObject(key, depth + 1)));
            return (T)set;
        }
        if (v8Value instanceof V8ValueMap) {
            V8ValueMap v8ValueMap = (V8ValueMap)v8Value;
            Map<String, Object> map = this.createEntityMap();
            v8ValueMap.forEach((key, value) -> map.put(key.toString(), this.toObject(value, depth + 1)));
            return (T)map;
        }
        if (v8Value instanceof V8ValueTypedArray) {
            V8ValueTypedArray v8ValueTypedArray = (V8ValueTypedArray)v8Value;
            switch (v8ValueTypedArray.getType()) {
                case Int8Array: 
                case Uint8Array: 
                case Uint8ClampedArray: {
                    return (T)v8ValueTypedArray.toBytes();
                }
                case Int16Array: 
                case Uint16Array: {
                    return (T)v8ValueTypedArray.toShorts();
                }
                case Int32Array: 
                case Uint32Array: {
                    return (T)v8ValueTypedArray.toIntegers();
                }
                case Float32Array: {
                    return (T)v8ValueTypedArray.toFloats();
                }
                case Float64Array: {
                    return (T)v8ValueTypedArray.toDoubles();
                }
                case BigInt64Array: 
                case BigUint64Array: {
                    return (T)v8ValueTypedArray.toLongs();
                }
            }
        } else {
            if (v8Value instanceof V8ValueFunction) {
                IJavetEntityFunction javetEntityFunction = this.createEntityFunction();
                if (this.config.isExtractFunctionSourceCode()) {
                    V8ValueFunction v8ValueFunction = (V8ValueFunction)v8Value;
                    javetEntityFunction.setJSFunctionType(v8ValueFunction.getJSFunctionType());
                    switch (javetEntityFunction.getJSFunctionType()) {
                        case Native: 
                        case API: {
                            javetEntityFunction.setSourceCode(v8ValueFunction.toString());
                            break;
                        }
                        case UserDefined: {
                            javetEntityFunction.setSourceCode(v8ValueFunction.getSourceCode());
                            break;
                        }
                    }
                }
                return (T)javetEntityFunction;
            }
            if (v8Value instanceof V8ValueSymbol) {
                V8ValueSymbol v8ValueSymbol = (V8ValueSymbol)v8Value;
                return (T)new JavetEntitySymbol(v8ValueSymbol.getDescription());
            }
            if (v8Value instanceof V8ValueObject) {
                if (v8Value instanceof V8ValueProxy) {
                    V8ValueProxy v8ValueProxy = (V8ValueProxy)v8Value;
                    try (IV8ValueObject iV8ValueObjectHandler = v8ValueProxy.getHandler();){
                        IJavetProxyHandler iJavetProxyHandler;
                        Object targetObject;
                        JavetCallbackContext javetCallbackContext;
                        Long handle = iV8ValueObjectHandler.getPrivatePropertyLong(PRIVATE_PROPERTY_PROXY_TARGET);
                        if (handle != null && (javetCallbackContext = v8ValueProxy.getV8Runtime().getCallbackContext(handle)) != null && (targetObject = (iJavetProxyHandler = (IJavetProxyHandler)javetCallbackContext.getCallbackReceiver()).getTargetObject()) != null) {
                            Object t = targetObject;
                            return t;
                        }
                    }
                }
                V8ValueObject v8ValueObject = (V8ValueObject)v8Value;
                HashMap map = new HashMap();
                v8ValueObject.forEach((key, value) -> {
                    String keyString = key.toString();
                    if (PUBLIC_PROPERTY_CONSTRUCTOR.equals(keyString)) {
                        map.put(PUBLIC_PROPERTY_CONSTRUCTOR, ((V8ValueObject)value).getString(PROPERTY_NAME));
                    } else if (!(value.isUndefined() || this.config.isSkipFunctionInObject() && value instanceof V8ValueFunction)) {
                        Object object = this.toObject(value, depth + 1);
                        map.put(keyString, object);
                    }
                });
                if (!this.customObjectMap.isEmpty() && v8ValueObject.hasPrivateProperty(PRIVATE_PROPERTY_CUSTOM_OBJECT_CLASS_NAME)) {
                    String customObjectClassName = v8ValueObject.getPrivatePropertyString(PRIVATE_PROPERTY_CUSTOM_OBJECT_CLASS_NAME);
                    Constructor defaultConstructor = null;
                    Method methodFromMap = null;
                    AccessibleObject[] executables = this.customObjectMap.get(customObjectClassName);
                    if (executables != null) {
                        defaultConstructor = (Constructor)executables[0];
                        methodFromMap = (Method)executables[1];
                    }
                    if (defaultConstructor != null) {
                        try {
                            Object customObject = defaultConstructor.newInstance(new Object[0]);
                            methodFromMap.invoke(customObject, map);
                            return customObject;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                return (T)map;
            }
        }
        return (T)v8Value;
    }

    @Override
    protected <T extends V8Value> T toV8Value(V8Runtime v8Runtime, Object object, int depth) throws JavetException {
        Object v8Value = super.toV8Value(v8Runtime, object, depth);
        if (v8Value != null && !v8Value.isUndefined()) {
            return v8Value;
        }
        if (object instanceof IJavetEntityMap) {
            try (V8Scope v8Scope = v8Runtime.getV8Scope();){
                V8ValueMap v8ValueMap = v8Scope.createV8ValueMap();
                Map mapObject = (Map)object;
                for (Object key : mapObject.keySet()) {
                    T childV8Value = this.toV8Value(v8Runtime, mapObject.get(key), depth + 1);
                    Throwable throwable = null;
                    try {
                        String childStringKey = key instanceof String ? (String)key : key.toString();
                        v8ValueMap.set(childStringKey, childV8Value);
                    }
                    catch (Throwable childStringKey) {
                        throwable = childStringKey;
                        throw childStringKey;
                    }
                    finally {
                        if (childV8Value == null) continue;
                        if (throwable != null) {
                            try {
                                ((V8Value)childV8Value).close();
                            }
                            catch (Throwable childStringKey) {
                                throwable.addSuppressed(childStringKey);
                            }
                            continue;
                        }
                        ((V8Value)childV8Value).close();
                    }
                }
                v8Value = v8ValueMap;
                v8Scope.setEscapable();
            }
        }
        if (object instanceof Map) {
            if (this.config.isProxyMapEnabled()) {
                try (V8Scope v8Scope = v8Runtime.getV8Scope();){
                    V8ValueProxy v8ValueProxy = v8Scope.createV8ValueProxy();
                    try (IV8ValueObject iV8ValueObjectHandler = v8ValueProxy.getHandler();){
                        JavetUniversalProxyObjectHandler<Map> javetProxyHandler = new JavetUniversalProxyObjectHandler<Map>(v8Runtime, (Map)object);
                        List<JavetCallbackContext> javetCallbackContexts = iV8ValueObjectHandler.bind(javetProxyHandler);
                        iV8ValueObjectHandler.setPrivateProperty(PRIVATE_PROPERTY_PROXY_TARGET, javetCallbackContexts.get(0).getHandle());
                    }
                    v8Value = v8ValueProxy;
                    v8Scope.setEscapable();
                }
            }
            try (V8Scope v8Scope = v8Runtime.getV8Scope();){
                V8ValueObject v8ValueObject = v8Scope.createV8ValueObject();
                Map mapObject = (Map)object;
                for (Object key : mapObject.keySet()) {
                    T childV8Value = this.toV8Value(v8Runtime, mapObject.get(key), depth + 1);
                    Throwable throwable = null;
                    try {
                        String childStringKey = key instanceof String ? (String)key : key.toString();
                        v8ValueObject.set(childStringKey, childV8Value);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (childV8Value == null) continue;
                        if (throwable != null) {
                            try {
                                ((V8Value)childV8Value).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((V8Value)childV8Value).close();
                    }
                }
                v8Value = v8ValueObject;
                v8Scope.setEscapable();
            }
        }
        if (object instanceof Set) {
            if (this.config.isProxySetEnabled()) {
                try (V8Scope v8Scope = v8Runtime.getV8Scope();){
                    V8ValueProxy v8ValueProxy = v8Scope.createV8ValueProxy();
                    try (IV8ValueObject iV8ValueObjectHandler = v8ValueProxy.getHandler();){
                        JavetUniversalProxyObjectHandler<Set> javetProxyHandler = new JavetUniversalProxyObjectHandler<Set>(v8Runtime, (Set)object);
                        List<JavetCallbackContext> javetCallbackContexts = iV8ValueObjectHandler.bind(javetProxyHandler);
                        iV8ValueObjectHandler.setPrivateProperty(PRIVATE_PROPERTY_PROXY_TARGET, javetCallbackContexts.get(0).getHandle());
                    }
                    v8Value = v8ValueProxy;
                    v8Scope.setEscapable();
                }
            }
            try (V8Scope v8Scope = v8Runtime.getV8Scope();){
                V8ValueSet v8ValueSet = v8Scope.createV8ValueSet();
                Set setObject = (Set)object;
                for (Object item : setObject) {
                    T childV8Value2 = this.toV8Value(v8Runtime, item, depth + 1);
                    Throwable throwable = null;
                    try {
                        v8ValueSet.add(childV8Value2);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (childV8Value2 == null) continue;
                        if (throwable != null) {
                            try {
                                ((V8Value)childV8Value2).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        ((V8Value)childV8Value2).close();
                    }
                }
                v8Value = v8ValueSet;
                v8Scope.setEscapable();
            }
        }
        if (object instanceof Collection) {
            try (V8Scope v8Scope = v8Runtime.getV8Scope();){
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                for (Object item : (Collection)object) {
                    T childV8Value = this.toV8Value(v8Runtime, item, depth + 1);
                    Throwable childV8Value2 = null;
                    try {
                        v8ValueArray.push(childV8Value);
                    }
                    catch (Throwable throwable) {
                        childV8Value2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (childV8Value == null) continue;
                        if (childV8Value2 != null) {
                            try {
                                ((V8Value)childV8Value).close();
                            }
                            catch (Throwable throwable) {
                                childV8Value2.addSuppressed(throwable);
                            }
                            continue;
                        }
                        ((V8Value)childV8Value).close();
                    }
                }
                v8Value = v8ValueArray;
                v8Scope.setEscapable();
            }
        }
        if (object instanceof BaseStream) {
            try (V8Scope v8Scope = v8Runtime.getV8Scope();){
                V8ValueArray v8ValueArray = v8Scope.createV8ValueArray();
                Iterator iterator = ((BaseStream)object).iterator();
                while (iterator.hasNext()) {
                    T childV8Value = this.toV8Value(v8Runtime, iterator.next(), depth + 1);
                    Throwable throwable = null;
                    try {
                        v8ValueArray.push(childV8Value);
                    }
                    catch (Throwable childV8Value2) {
                        throwable = childV8Value2;
                        throw childV8Value2;
                    }
                    finally {
                        if (childV8Value == null) continue;
                        if (throwable != null) {
                            try {
                                ((V8Value)childV8Value).close();
                            }
                            catch (Throwable childV8Value2) {
                                throwable.addSuppressed(childV8Value2);
                            }
                            continue;
                        }
                        ((V8Value)childV8Value).close();
                    }
                }
                v8Value = v8ValueArray;
                v8Scope.setEscapable();
            }
        }
        if (object instanceof IJavetEntityFunction) {
            String sourceCode;
            IJavetEntityFunction javetEntityFunction = (IJavetEntityFunction)object;
            String string = sourceCode = javetEntityFunction.getJSFunctionType().isUserDefined() ? javetEntityFunction.getSourceCode() : null;
            v8Value = sourceCode == null || sourceCode.length() == 0 ? v8Runtime.createV8ValueNull() : v8Runtime.getExecutor(sourceCode).execute();
        } else if (object instanceof JavetEntitySymbol) {
            JavetEntitySymbol javetEntitySymbol = (JavetEntitySymbol)object;
            v8Value = v8Runtime.createV8ValueSymbol(javetEntitySymbol.getDescription(), true);
        } else {
            if (object.getClass().isArray()) {
                try (V8Scope v8Scope = v8Runtime.getV8Scope();){
                    V8ValueArray v8ValueArray;
                    if (object instanceof boolean[]) {
                        v8ValueArray = v8Scope.createV8ValueArray();
                        for (boolean item : (boolean[])object) {
                            v8ValueArray.push(v8Runtime.createV8ValueBoolean(item));
                        }
                        v8Value = v8ValueArray;
                    } else if (object instanceof byte[]) {
                        byte[] bytes = (byte[])object;
                        V8ValueTypedArray v8ValueTypedArray = v8Scope.createV8ValueTypedArray(V8ValueReferenceType.Int8Array, bytes.length);
                        v8ValueTypedArray.fromBytes(bytes);
                        v8Value = v8ValueTypedArray;
                    } else if (object instanceof char[]) {
                        v8ValueArray = v8Scope.createV8ValueArray();
                        for (char c : (char[])object) {
                            v8ValueArray.push(Character.toString(c));
                        }
                        v8Value = v8ValueArray;
                    } else if (object instanceof double[]) {
                        double[] doubles = (double[])object;
                        V8ValueTypedArray v8ValueTypedArray = v8Scope.createV8ValueTypedArray(V8ValueReferenceType.Float64Array, doubles.length);
                        v8ValueTypedArray.fromDoubles(doubles);
                        v8Value = v8ValueTypedArray;
                    } else if (object instanceof float[]) {
                        float[] floats = (float[])object;
                        V8ValueTypedArray v8ValueTypedArray = v8Scope.createV8ValueTypedArray(V8ValueReferenceType.Float32Array, floats.length);
                        v8ValueTypedArray.fromFloats(floats);
                        v8Value = v8ValueTypedArray;
                    } else if (object instanceof int[]) {
                        int[] integers = (int[])object;
                        V8ValueTypedArray v8ValueTypedArray = v8Scope.createV8ValueTypedArray(V8ValueReferenceType.Int32Array, integers.length);
                        v8ValueTypedArray.fromIntegers(integers);
                        v8Value = v8ValueTypedArray;
                    } else if (object instanceof long[]) {
                        long[] longs = (long[])object;
                        V8ValueTypedArray v8ValueTypedArray = v8Scope.createV8ValueTypedArray(V8ValueReferenceType.BigInt64Array, longs.length);
                        v8ValueTypedArray.fromLongs(longs);
                        v8Value = v8ValueTypedArray;
                    } else if (object instanceof short[]) {
                        short[] shorts = (short[])object;
                        V8ValueTypedArray v8ValueTypedArray = v8Scope.createV8ValueTypedArray(V8ValueReferenceType.Int16Array, shorts.length);
                        v8ValueTypedArray.fromShorts(shorts);
                        v8Value = v8ValueTypedArray;
                    } else if (object instanceof String[]) {
                        v8ValueArray = v8Scope.createV8ValueArray();
                        for (String item : (String[])object) {
                            v8ValueArray.push(v8Runtime.createV8ValueString(item));
                        }
                        v8Value = v8ValueArray;
                    } else {
                        v8ValueArray = v8Scope.createV8ValueArray();
                        for (Object item : (Object[])object) {
                            try (T childV8Value = this.toV8Value(v8Runtime, item, depth + 1);){
                                v8ValueArray.push(childV8Value);
                            }
                        }
                        v8Value = v8ValueArray;
                    }
                    v8Scope.setEscapable();
                }
            }
            if (!this.customObjectMap.isEmpty()) {
                String customObjectClassName = object.getClass().getName();
                Method methodToMap = null;
                AccessibleObject[] executables = this.customObjectMap.get(customObjectClassName);
                if (executables != null) {
                    methodToMap = (Method)executables[2];
                }
                if (methodToMap != null) {
                    try {
                        Map map = (Map)methodToMap.invoke(object, new Object[0]);
                        v8Value = this.toV8Value(v8Runtime, map);
                        ((V8ValueObject)v8Value).setPrivateProperty(PRIVATE_PROPERTY_CUSTOM_OBJECT_CLASS_NAME, customObjectClassName);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return v8Value;
    }

    public boolean unregisterCustomObject(Class<?> customObjectClass) {
        if (customObjectClass == null) {
            return false;
        }
        return this.customObjectMap.remove(customObjectClass.getName()) != null;
    }
}

