/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.callback;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public final class JavetCallbackContext {
    public static final long INVALID_HANDLE = 0L;
    private static final String ERROR_CALLBACK_RECEIVER_OR_CALLBACK_METHOD_IS_INVALID = "Callback receiver or callback method is invalid";
    private static final String ERROR_JAVET_CALLBACK_CONTEXT_HANDLE_IS_INVALID = "Javet callback context handle is invalid";
    private final Method callbackMethod;
    private final Object callbackReceiver;
    private final boolean returnResult;
    private final boolean thisObjectRequired;
    private long handle;

    public JavetCallbackContext(Object callbackReceiver, Method callbackMethod) {
        this(callbackReceiver, callbackMethod, false);
    }

    public JavetCallbackContext(Object callbackReceiver, Method callbackMethod, boolean thisObjectRequired) {
        Objects.requireNonNull(callbackMethod);
        assert (callbackReceiver != null && !Modifier.isStatic(callbackMethod.getModifiers()) || callbackReceiver == null && Modifier.isStatic(callbackMethod.getModifiers())) : "Callback receiver or callback method is invalid";
        this.callbackMethod = callbackMethod;
        this.callbackReceiver = callbackReceiver;
        this.handle = 0L;
        this.returnResult = !callbackMethod.getReturnType().equals(Void.TYPE);
        this.thisObjectRequired = thisObjectRequired;
    }

    public Method getCallbackMethod() {
        return this.callbackMethod;
    }

    public Object getCallbackReceiver() {
        return this.callbackReceiver;
    }

    public long getHandle() {
        return this.handle;
    }

    public boolean isReturnResult() {
        return this.returnResult;
    }

    public boolean isThisObjectRequired() {
        return this.thisObjectRequired;
    }

    public boolean isValid() {
        return this.handle != 0L;
    }

    public void setHandle(long handle) {
        assert (!this.isValid()) : "Javet callback context handle is invalid";
        this.handle = handle;
    }
}

