/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interception.logging;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interception.BaseJavetInterceptor;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueObject;

public abstract class BaseJavetConsoleInterceptor
extends BaseJavetInterceptor {
    protected static final String JAVA_CONSOLE_DEBUG = "consoleDebug";
    protected static final String JAVA_CONSOLE_ERROR = "consoleError";
    protected static final String JAVA_CONSOLE_INFO = "consoleInfo";
    protected static final String JAVA_CONSOLE_LOG = "consoleLog";
    protected static final String JAVA_CONSOLE_TRACE = "consoleTrace";
    protected static final String JAVA_CONSOLE_WARN = "consoleWarn";
    protected static final String JS_FUNCTION_DEBUG = "debug";
    protected static final String JS_FUNCTION_ERROR = "error";
    protected static final String JS_FUNCTION_INFO = "info";
    protected static final String JS_FUNCTION_LOG = "log";
    protected static final String JS_FUNCTION_TRACE = "trace";
    protected static final String JS_FUNCTION_WARN = "warn";
    protected static final String PROPERTY_CONSOLE = "console";
    protected static final String SPACE = " ";

    public BaseJavetConsoleInterceptor(V8Runtime v8Runtime) {
        super(v8Runtime);
    }

    public String concat(V8Value ... v8Values) {
        return V8ValueUtils.concat(SPACE, v8Values);
    }

    public abstract void consoleDebug(V8Value ... var1);

    public abstract void consoleError(V8Value ... var1);

    public abstract void consoleInfo(V8Value ... var1);

    public abstract void consoleLog(V8Value ... var1);

    public abstract void consoleTrace(V8Value ... var1);

    public abstract void consoleWarn(V8Value ... var1);

    @Override
    public boolean register(IV8ValueObject ... iV8ValueObjects) throws JavetException {
        try (V8ValueObject console = this.v8Runtime.createV8ValueObject();){
            for (IV8ValueObject iV8ValueObject : iV8ValueObjects) {
                iV8ValueObject.set(PROPERTY_CONSOLE, console);
                this.register((IV8ValueObject)console, JS_FUNCTION_DEBUG, JAVA_CONSOLE_DEBUG);
                this.register((IV8ValueObject)console, JS_FUNCTION_ERROR, JAVA_CONSOLE_ERROR);
                this.register((IV8ValueObject)console, JS_FUNCTION_INFO, JAVA_CONSOLE_INFO);
                this.register((IV8ValueObject)console, JS_FUNCTION_LOG, JAVA_CONSOLE_LOG);
                this.register((IV8ValueObject)console, JS_FUNCTION_TRACE, JAVA_CONSOLE_TRACE);
                this.register((IV8ValueObject)console, JS_FUNCTION_WARN, JAVA_CONSOLE_WARN);
            }
            boolean bl = true;
            return bl;
        }
    }

    protected void register(IV8ValueObject iV8ValueObject, String jsFunctionName, String javaFunctionName) throws JavetException {
        try {
            iV8ValueObject.bindFunction(jsFunctionName, new JavetCallbackContext(this, this.getClass().getMethod(javaFunctionName, V8Value[].class)));
        }
        catch (NoSuchMethodException e) {
            throw new JavetException(JavetError.CallbackRegistrationFailure, SimpleMap.of("methodName", javaFunctionName, "message", e.getMessage()), e);
        }
    }

    @Override
    public boolean unregister(IV8ValueObject ... iV8ValueObjects) throws JavetException {
        boolean successful = true;
        for (IV8ValueObject iV8ValueObject : iV8ValueObjects) {
            try (V8ValueObject console = (V8ValueObject)iV8ValueObject.get(PROPERTY_CONSOLE);){
                console.delete(JS_FUNCTION_DEBUG);
                console.delete(JS_FUNCTION_ERROR);
                console.delete(JS_FUNCTION_INFO);
                console.delete(JS_FUNCTION_LOG);
                console.delete(JS_FUNCTION_TRACE);
                console.delete(JS_FUNCTION_WARN);
            }
            successful &= iV8ValueObject.delete(PROPERTY_CONSOLE);
        }
        return successful;
    }
}

