/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.exceptions;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueError;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class JavetScriptingError {
    private Map<String, Object> context = new LinkedHashMap<String, Object>();
    private String detailedMessage = null;
    private int endColumn;
    private int endPosition;
    private int lineNumber;
    private String message = null;
    private String resourceName;
    private String sourceLine;
    private String stack = null;
    private int startColumn;
    private int startPosition;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavetScriptingError(V8Value v8Value, String resourceName, String sourceLine, int lineNumber, int startColumn, int endColumn, int startPosition, int endPosition) {
        try {
            if (v8Value instanceof V8ValueError) {
                V8ValueError v8ValueError = (V8ValueError)v8Value;
                this.detailedMessage = v8ValueError.getMessage();
                this.message = v8ValueError.toString();
                this.stack = v8ValueError.getStack();
                V8Runtime v8Runtime = v8ValueError.getV8Runtime();
                v8ValueError.forEach((key, value) -> this.context.put(key.toString(), v8Runtime.toObject(value)));
            } else if (v8Value instanceof V8ValueObject) {
                V8ValueObject v8ValueObject = (V8ValueObject)v8Value;
                this.message = this.detailedMessage = v8ValueObject.getString("message");
                this.stack = v8ValueObject.getString("stack");
                V8Runtime v8Runtime = v8ValueObject.getV8Runtime();
                v8ValueObject.forEach((key, value) -> {
                    String keyString = key.toString();
                    if (!"message".equals(keyString) && !"stack".equals(keyString)) {
                        this.context.put(keyString, v8Runtime.toObject(value));
                    }
                });
            }
        }
        catch (JavetException e) {
            e.printStackTrace();
        }
        finally {
            JavetResourceUtils.safeClose((Object)v8Value);
        }
        this.context = Collections.unmodifiableMap(this.context);
        this.resourceName = resourceName;
        this.sourceLine = sourceLine;
        this.lineNumber = lineNumber;
        this.startColumn = startColumn;
        this.endColumn = endColumn;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getSourceLine() {
        return this.sourceLine;
    }

    public String getStack() {
        return this.stack;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.message).append("\n");
        sb.append("Resource: ").append(this.resourceName).append("\n");
        sb.append("Source Code: ").append(this.sourceLine).append("\n");
        sb.append("Line Number: ").append(this.lineNumber).append("\n");
        sb.append("Column: ").append(this.startColumn).append(", ").append(this.endColumn).append("\n");
        sb.append("Position: ").append(this.startPosition).append(", ").append(this.endPosition);
        return sb.toString();
    }
}

