/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.virtual;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.V8Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V8VirtualValueList
implements IJavetClosable {
    protected List<V8Value> toBeClosedValues;
    protected List<V8Value> values;

    public V8VirtualValueList(V8Runtime v8Runtime, Object ... objects) throws JavetException {
        Objects.requireNonNull(v8Runtime);
        if (objects == null || objects.length == 0) {
            this.toBeClosedValues = null;
            this.values = null;
        } else {
            this.toBeClosedValues = new ArrayList<V8Value>(objects.length);
            this.values = new ArrayList<V8Value>(objects.length);
            for (Object object : objects) {
                if (object instanceof V8Value) {
                    this.values.add((V8Value)object);
                    continue;
                }
                Object value = v8Runtime.toV8Value(object);
                this.values.add((V8Value)value);
                this.toBeClosedValues.add((V8Value)value);
            }
        }
    }

    @Override
    public void close() throws JavetException {
        JavetResourceUtils.safeClose(this.toBeClosedValues);
        this.toBeClosedValues = null;
        this.values = null;
    }

    public V8Value[] get() {
        return this.values == null ? new V8Value[]{} : this.values.toArray(new V8Value[0]);
    }

    @Override
    public boolean isClosed() {
        return this.values == null;
    }
}

