/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.util.Objects;

public class V8ValueWeakMap
extends V8ValueObject {
    V8ValueWeakMap(long handle) {
        super(handle);
    }

    @Override
    public boolean delete(Object key) throws JavetException {
        Objects.requireNonNull(key);
        if (!(key instanceof IV8ValueObject)) {
            throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", key.toString()));
        }
        this.invokeVoid("delete", key);
        return true;
    }

    public <T extends V8Value> T get(String key) throws JavetException {
        return this.checkV8Runtime().getV8Internal().get(this, this.v8Runtime.createV8ValueString(key));
    }

    @Override
    public <T extends V8Value> T get(Object key) throws JavetException {
        Objects.requireNonNull(key);
        if (!(key instanceof IV8ValueObject)) {
            throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", key.toString()));
        }
        return this.invoke("get", key);
    }

    @Override
    public V8ValueReferenceType getType() {
        return V8ValueReferenceType.WeakMap;
    }

    @Override
    public boolean has(Object key) throws JavetException {
        Objects.requireNonNull(key);
        if (!(key instanceof IV8ValueObject)) {
            throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", key.toString()));
        }
        return this.invokeBoolean("has", key);
    }

    @Override
    public boolean set(Object key, Object value) throws JavetException {
        Objects.requireNonNull(key);
        if (!(key instanceof IV8ValueObject)) {
            throw new JavetException(JavetError.NotSupported, SimpleMap.of("feature", key.toString()));
        }
        this.invokeVoid("set", key, value);
        return true;
    }
}

