/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueReference;

public abstract class V8ValueReference
extends V8Value
implements IV8ValueReference {
    public static final long INVALID_HANDLE = 0L;
    protected long handle;
    protected boolean weak;

    V8ValueReference(long handle) {
        this.handle = handle;
        this.weak = false;
    }

    protected void addReference() throws JavetException {
        this.checkV8Runtime().getV8Internal().addReference(this);
    }

    @Override
    public V8Runtime checkV8Runtime() throws JavetException {
        if (this.isClosed()) {
            throw new JavetException(JavetError.RuntimeAlreadyClosed);
        }
        return super.checkV8Runtime();
    }

    @Override
    public void clearWeak() throws JavetException {
        this.checkV8Runtime().getV8Internal().clearWeak(this);
        this.weak = false;
    }

    @Override
    public void close() throws JavetException {
        this.close(false);
    }

    @Override
    public void close(boolean forceClose) throws JavetException {
        if (this.isClosed()) {
            throw new JavetException(JavetError.RuntimeAlreadyClosed);
        }
        if (forceClose || !this.isWeak()) {
            this.removeReference();
            this.handle = 0L;
            this.v8Runtime = null;
            this.weak = false;
        }
    }

    @Override
    public boolean equals(V8Value v8Value) throws JavetException {
        if (!(v8Value instanceof V8ValueReference)) {
            return false;
        }
        if (v8Value.getClass() != this.getClass()) {
            return false;
        }
        V8ValueReference v8ValueReference = (V8ValueReference)v8Value;
        if (this.getHandle() == v8ValueReference.getHandle()) {
            return true;
        }
        return this.checkV8Runtime().getV8Internal().equals(this, v8ValueReference);
    }

    @Override
    public long getHandle() {
        return this.handle;
    }

    @Override
    public abstract V8ValueReferenceType getType();

    @Override
    public boolean isClosed() {
        return this.handle == 0L || super.isClosed();
    }

    @Override
    public boolean isWeak() {
        return this.weak;
    }

    @Override
    public boolean isWeak(boolean force) throws JavetException {
        if (force) {
            this.weak = this.checkV8Runtime().getV8Internal().isWeak(this);
        }
        return this.weak;
    }

    protected void removeReference() throws JavetException {
        this.checkV8Runtime().getV8Internal().removeReference(this);
    }

    @Override
    public boolean sameValue(V8Value v8Value) throws JavetException {
        if (!(v8Value instanceof V8ValueReference)) {
            return false;
        }
        return ((V8ValueReference)v8Value).getHandle() == this.getHandle();
    }

    @Override
    public void setV8Runtime(V8Runtime v8Runtime) throws JavetException {
        super.setV8Runtime(v8Runtime);
        this.addReference();
    }

    @Override
    public void setWeak() throws JavetException {
        this.checkV8Runtime().getV8Internal().setWeak(this);
        this.weak = true;
    }

    @Override
    public boolean strictEquals(V8Value v8Value) throws JavetException {
        return this.sameValue(v8Value);
    }

    @Override
    public <T extends V8Value> T toClone() throws JavetException {
        return this.checkV8Runtime().getV8Internal().cloneV8Value(this);
    }

    public String toString() {
        try {
            return this.checkV8Runtime().getV8Internal().toString(this);
        }
        catch (JavetException e) {
            return e.getMessage();
        }
    }
}

