/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.values.reference;

import com.caoccao.javet.enums.JSFunctionType;
import com.caoccao.javet.enums.JSScopeType;
import com.caoccao.javet.enums.V8ValueInternalType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValuePrimitive;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.IV8ValueObject;

public interface IV8ValueFunction
extends IV8ValueObject {
    default public <T extends V8Value> T call(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return this.callExtended(receiver, true, objects);
    }

    default public <T extends V8Value> T call(IV8ValueObject receiver, V8Value ... v8Values) throws JavetException {
        return this.callExtended(receiver, true, v8Values);
    }

    public <T extends V8Value> T callAsConstructor(Object ... var1) throws JavetException;

    public <T extends V8Value> T callAsConstructor(V8Value ... var1) throws JavetException;

    default public Boolean callBoolean(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (Boolean)this.callPrimitive(receiver, objects);
    }

    default public Double callDouble(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (Double)this.callPrimitive(receiver, objects);
    }

    public <T extends V8Value> T callExtended(IV8ValueObject var1, boolean var2, Object ... var3) throws JavetException;

    public <T extends V8Value> T callExtended(IV8ValueObject var1, boolean var2, V8Value ... var3) throws JavetException;

    default public Float callFloat(IV8ValueObject receiver, Object ... objects) throws JavetException {
        Double result = this.callDouble(receiver, objects);
        return result == null ? null : Float.valueOf(result.floatValue());
    }

    default public Integer callInteger(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (Integer)this.callPrimitive(receiver, objects);
    }

    default public Long callLong(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (Long)this.callPrimitive(receiver, objects);
    }

    default public <T> T callObject(IV8ValueObject receiver, Object ... objects) throws JavetException {
        try {
            return this.getV8Runtime().toObject(this.callExtended(receiver, true, objects), true);
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <R, T extends V8ValuePrimitive<R>> R callPrimitive(IV8ValueObject receiver, Object ... objects) throws JavetException {
        try (T v8Value = this.callExtended(receiver, true, objects);){
            Object t = ((V8ValuePrimitive)v8Value).getValue();
            return (R)t;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t2) {
            return null;
        }
    }

    default public String callString(IV8ValueObject receiver, Object ... objects) throws JavetException {
        return (String)this.callPrimitive(receiver, objects);
    }

    default public void callVoid(IV8ValueObject receiver, Object ... objects) throws JavetException {
        this.callExtended(receiver, false, objects);
    }

    default public void callVoid(IV8ValueObject receiver, V8Value ... v8Values) throws JavetException {
        this.callExtended(receiver, false, v8Values);
    }

    public IV8ValueArray getInternalProperties() throws JavetException;

    public JSFunctionType getJSFunctionType() throws JavetException;

    public JSScopeType getJSScopeType() throws JavetException;

    public String getSourceCode() throws JavetException;

    default public boolean isAsyncFunction() throws JavetException {
        return this.hasInternalType(V8ValueInternalType.AsyncFunction);
    }

    default public boolean isGeneratorFunction() throws JavetException {
        return this.hasInternalType(V8ValueInternalType.GeneratorFunction);
    }

    public boolean setSourceCode(String var1) throws JavetException;

    default public boolean setSourceCode(String sourceCodeString, boolean trimTailingCharacters) throws JavetException {
        if (trimTailingCharacters) {
            sourceCodeString = V8ValueUtils.trimAnonymousFunction(sourceCodeString);
        }
        return this.setSourceCode(sourceCodeString);
    }
}

