/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils.receivers;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.utils.receivers.IJavetCallbackReceiver;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueArray;
import java.util.ArrayList;
import java.util.Objects;

public class JavetCallbackReceiver
implements IJavetCallbackReceiver {
    protected static final String COMMA = ",";
    protected V8Runtime v8Runtime;

    public JavetCallbackReceiver(V8Runtime v8Runtime) {
        Objects.requireNonNull(v8Runtime);
        this.v8Runtime = v8Runtime;
    }

    public V8Value echo(V8Value arg) throws JavetException {
        return arg.toClone();
    }

    public V8ValueArray echo(V8Value ... args) throws JavetException {
        V8ValueArray v8ValueArray = this.v8Runtime.createV8ValueArray();
        for (V8Value arg : args) {
            try (Object clonedArg = arg.toClone();){
                v8ValueArray.push(clonedArg);
            }
        }
        return v8ValueArray;
    }

    public String echoString(String str) {
        return str;
    }

    public String echoString(V8Value arg) {
        return arg == null ? null : arg.toString();
    }

    public String echoString(V8Value ... args) {
        ArrayList<String> stringList = new ArrayList<String>(args.length);
        for (V8Value arg : args) {
            stringList.add(arg == null ? null : arg.toString());
        }
        return String.join((CharSequence)COMMA, stringList);
    }

    @Override
    public V8Runtime getV8Runtime() {
        return this.v8Runtime;
    }
}

