/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.utils;

import com.caoccao.javet.utils.JavetVirtualObject;
import com.caoccao.javet.values.V8Value;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class V8ValueUtils {
    public static final String EMPTY = "";

    private V8ValueUtils() {
    }

    public static String concat(String delimiter, V8Value ... v8Values) {
        if (v8Values == null || v8Values.length == 0) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        return Arrays.stream(v8Values).map(Object::toString).collect(Collectors.joining(delimiter));
    }

    public static JavetVirtualObject[] convertToVirtualObjects(V8Value ... v8Values) {
        int length = v8Values.length;
        JavetVirtualObject[] javetVirtualObjects = new JavetVirtualObject[length];
        for (int i = 0; i < length; ++i) {
            javetVirtualObjects[i] = new JavetVirtualObject(v8Values[i]);
        }
        return javetVirtualObjects;
    }

    public static String trimAnonymousFunction(String sourceCode) {
        int length;
        if (sourceCode != null && (length = sourceCode.length()) > 0) {
            int endPosition = length;
            boolean completed = false;
            block3: while (!completed && endPosition > 0) {
                switch (sourceCode.charAt(endPosition - 1)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case ';': {
                        --endPosition;
                        continue block3;
                    }
                }
                completed = true;
            }
            if (endPosition == length) {
                return sourceCode;
            }
            return sourceCode.substring(0, endPosition);
        }
        return null;
    }
}

