/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.node.modules;

import com.caoccao.javet.annotations.NodeModule;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.node.modules.BaseNodeModule;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.io.File;
import java.nio.file.Path;

@NodeModule(name="process")
public class NodeModuleProcess
extends BaseNodeModule {
    public static final String FUNCTION_CHDIR = "chdir";
    public static final String FUNCTION_CWD = "cwd";
    public static final String FUNCTION_ON = "on";
    public static final String PROPERTY_VERSION = "version";

    public NodeModuleProcess(V8ValueObject moduleObject, String name) {
        super(moduleObject, name);
    }

    public String getVersion() throws JavetException {
        return this.moduleObject.getString(PROPERTY_VERSION);
    }

    public Path getWorkingDirectory() throws JavetException {
        return new File(this.moduleObject.invokeString(FUNCTION_CWD, new Object[0])).toPath();
    }

    public void on(String eventName, V8ValueFunction v8ValueFunction) throws JavetException {
        this.moduleObject.invokeVoid(FUNCTION_ON, new V8ValueString(eventName), v8ValueFunction);
    }

    public void setWorkingDirectory(Path path) throws JavetException {
        this.moduleObject.invokeVoid(FUNCTION_CHDIR, new V8ValueString(path.toAbsolutePath().toString()));
    }
}

