/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.proxy;

import com.caoccao.javet.annotations.V8BindingEnabler;
import com.caoccao.javet.annotations.V8Function;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.proxy.BaseJavetProxyHandler;
import com.caoccao.javet.interop.proxy.DynamicProxyV8ValueFunctionInvocationHandler;
import com.caoccao.javet.interop.proxy.DynamicProxyV8ValueObjectInvocationHandler;
import com.caoccao.javet.utils.JavetReflectionUtils;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.JavetTypeUtils;
import com.caoccao.javet.utils.JavetVirtualObject;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.utils.V8ValueUtils;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValueProxy;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavetUniversalProxyHandler<T>
extends BaseJavetProxyHandler<T> {
    protected static final String[] GETTER_PREFIX_ARRAY = new String[]{"get", "is"};
    protected static final String METHOD_NAME_CONSTRUCT = "construct";
    protected static final String METHOD_NAME_CONSTRUCTOR = "constructor";
    protected static final Pattern PATTERN_CAPITALIZED_PREFIX = Pattern.compile("^[A-Z]+");
    protected static final String[] SETTER_PREFIX_ARRAY = new String[]{"set", "put"};
    protected static final Class<?> V8_VALUE_CLASS = V8Value.class;
    protected static final Class<?> V8_VALUE_FUNCTION_CLASS = V8ValueFunction.class;
    protected static final Class<?> V8_VALUE_OBJECT_CLASS = V8ValueObject.class;
    protected static final Class<?> V8_VALUE_PROXY_CLASS = V8ValueProxy.class;
    protected boolean classMode;
    protected List<Constructor<?>> constructors;
    protected Map<String, Field> fieldMap;
    protected List<Method> genericGetters;
    protected List<Method> genericSetters;
    protected Map<String, List<Method>> gettersMap;
    protected boolean isTargetTypeMap;
    protected boolean isTargetTypeSet;
    protected Map<String, List<Method>> methodsMap;
    protected Map<String, List<Method>> settersMap;
    protected Class<T> targetClass;
    protected Set<String> uniqueKeySet;

    public JavetUniversalProxyHandler(V8Runtime v8Runtime, T targetObject) {
        super(v8Runtime, Objects.requireNonNull(targetObject));
        this.targetClass = targetObject.getClass();
        this.initialize();
    }

    protected static <E extends Executable> Object execute(V8Runtime v8Runtime, Object targetObject, List<E> executables, JavetVirtualObject[] javetVirtualObjects) throws Throwable {
        ArrayList<ScoredExecutable> scoredExecutables = new ArrayList<ScoredExecutable>();
        for (Executable executable : executables) {
            ScoredExecutable scoredExecutable = new ScoredExecutable(v8Runtime, targetObject, executable, javetVirtualObjects);
            scoredExecutable.calculateScore();
            double score = scoredExecutable.getScore();
            if (!(score > 0.0)) continue;
            scoredExecutables.add(scoredExecutable);
        }
        if (!scoredExecutables.isEmpty()) {
            scoredExecutables.sort((o1, o2) -> Double.compare(o2.getScore(), o1.getScore()));
            Throwable lastException = null;
            for (ScoredExecutable scoredExecutable : scoredExecutables) {
                try {
                    return scoredExecutable.execute();
                }
                catch (Throwable t) {
                    lastException = t;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }
        return null;
    }

    public static boolean isClassMode(Class<?> objectClass) {
        return !objectClass.isPrimitive() && !objectClass.isAnnotation() && !objectClass.isInterface() && !objectClass.isArray();
    }

    protected void addMethod(Method method, int startIndex, Map<String, List<Method>> map) {
        String methodName = method.getName();
        String aliasMethodName = methodName.substring(startIndex);
        Matcher matcher = PATTERN_CAPITALIZED_PREFIX.matcher(aliasMethodName);
        if (matcher.find()) {
            int capitalizedPrefixLength = matcher.group().length();
            if (capitalizedPrefixLength == 1) {
                aliasMethodName = methodName.substring(startIndex, startIndex + capitalizedPrefixLength).toLowerCase(Locale.ROOT) + methodName.substring(startIndex + capitalizedPrefixLength);
                map.computeIfAbsent(aliasMethodName, key -> new ArrayList()).add(method);
            } else {
                for (int i = 1; i < capitalizedPrefixLength; ++i) {
                    aliasMethodName = methodName.substring(startIndex, startIndex + i).toLowerCase(Locale.ROOT) + methodName.substring(startIndex + i);
                    map.computeIfAbsent(aliasMethodName, key -> new ArrayList()).add(method);
                }
            }
        } else {
            map.computeIfAbsent(aliasMethodName, key -> new ArrayList()).add(method);
        }
    }

    @Override
    @V8Function
    public V8Value construct(V8Value target, V8ValueArray arguments, V8Value newTarget) throws JavetException {
        V8Value[] v8Values = null;
        try {
            v8Values = arguments.toArray();
            Object v = this.v8Runtime.toV8Value(JavetUniversalProxyHandler.execute(this.v8Runtime, null, this.constructors, V8ValueUtils.convertToVirtualObjects(v8Values)));
            return v;
        }
        catch (JavetException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", METHOD_NAME_CONSTRUCTOR, "message", t.getMessage()), t);
        }
        finally {
            if (v8Values != null) {
                JavetResourceUtils.safeClose(v8Values);
            }
        }
    }

    @Override
    @V8Function
    public V8Value get(V8Value target, V8Value property, V8Value receiver) throws JavetException {
        String propertyName;
        Object field;
        if (!this.fieldMap.isEmpty() && property instanceof V8ValueString && (field = this.fieldMap.get(propertyName = ((V8ValueString)property).toPrimitive())) != null) {
            try {
                Object callee = Modifier.isStatic(((Field)field).getModifiers()) ? null : this.targetObject;
                Object value = ((Field)field).get(callee);
                if (value != null) {
                    return this.v8Runtime.toV8Value(value);
                }
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
            }
        }
        if (!this.genericGetters.isEmpty()) {
            try {
                Object propertyObject = this.v8Runtime.toObject(property);
                if (propertyObject != null && !(propertyObject instanceof V8Value)) {
                    for (Method method : this.genericGetters) {
                        Object callee;
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class<?> parameterType = parameterTypes[0];
                        Object key = propertyObject;
                        boolean isCallable = parameterType.isAssignableFrom(propertyObject.getClass());
                        if (!isCallable && parameterType.isPrimitive()) {
                            key = JavetTypeUtils.toExactPrimitive(parameterType, propertyObject);
                            boolean bl = isCallable = key != null;
                        }
                        if (!isCallable) {
                            key = JavetTypeUtils.toApproximatePrimitive(parameterType, propertyObject);
                            boolean bl = isCallable = key != null;
                        }
                        if (!isCallable) continue;
                        Object object = callee = Modifier.isStatic(method.getModifiers()) ? null : this.targetObject;
                        Object value = method.invoke(callee, key);
                        if (value == null) continue;
                        return this.v8Runtime.toV8Value(value);
                    }
                }
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
            }
        }
        if (property instanceof V8ValueString) {
            JavetUniversalInterceptor javetUniversalInterceptor;
            propertyName = ((V8ValueString)property).toPrimitive();
            List<Method> methods = this.methodsMap.get(propertyName);
            if (methods != null && !methods.isEmpty()) {
                javetUniversalInterceptor = new JavetUniversalInterceptor(this.v8Runtime, this.targetObject, propertyName, methods);
                return this.v8Runtime.createV8ValueFunction(javetUniversalInterceptor.getCallbackContext());
            }
            methods = this.gettersMap.get(propertyName);
            if (methods != null && !methods.isEmpty()) {
                javetUniversalInterceptor = new JavetUniversalInterceptor(this.v8Runtime, this.targetObject, propertyName, methods);
                return this.v8Runtime.toV8Value(javetUniversalInterceptor.invoke(new V8Value[0]));
            }
        }
        return this.v8Runtime.createV8ValueUndefined();
    }

    protected int getGetterPrefixLength(Method method) {
        String methodName = method.getName();
        for (String prefix : GETTER_PREFIX_ARRAY) {
            if (!methodName.startsWith(prefix) || methodName.length() <= prefix.length() || method.getParameterCount() != 0) continue;
            return prefix.length();
        }
        return 0;
    }

    protected int getSetterPrefixLength(Method method) {
        String methodName = method.getName();
        for (String prefix : SETTER_PREFIX_ARRAY) {
            if (!methodName.startsWith(prefix) || methodName.length() <= prefix.length() || method.getParameterCount() != 1) continue;
            return prefix.length();
        }
        return 0;
    }

    @Override
    @V8Function
    public V8ValueBoolean has(V8Value target, V8Value property) throws JavetException {
        boolean isFound;
        block14: {
            isFound = false;
            if (!this.classMode) {
                if (this.isTargetTypeMap) {
                    isFound = ((Map)this.targetObject).containsKey(this.v8Runtime.toObject(property));
                } else if (this.isTargetTypeSet) {
                    isFound = ((Set)this.targetObject).contains(this.v8Runtime.toObject(property));
                }
            }
            if (!isFound && property instanceof V8ValueString) {
                String propertyName = ((V8ValueString)property).toPrimitive();
                boolean bl = isFound = this.fieldMap.containsKey(propertyName) || this.methodsMap.containsKey(propertyName) || this.gettersMap.containsKey(propertyName) || this.settersMap.containsKey(propertyName);
            }
            if (!isFound && !this.genericGetters.isEmpty()) {
                try {
                    Object propertyObject = this.v8Runtime.toObject(property);
                    if (propertyObject == null || propertyObject instanceof V8Value) break block14;
                    for (Method method : this.genericGetters) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class<?> parameterType = parameterTypes[0];
                        Object parameter = propertyObject;
                        boolean isCallable = parameterType.isAssignableFrom(propertyObject.getClass());
                        if (!isCallable && parameterType.isPrimitive()) {
                            parameter = JavetTypeUtils.toExactPrimitive(parameterType, propertyObject);
                            boolean bl = isCallable = parameter != null;
                        }
                        if (!isCallable) {
                            parameter = JavetTypeUtils.toApproximatePrimitive(parameterType, propertyObject);
                            boolean bl = isCallable = parameter != null;
                        }
                        if (!isCallable) continue;
                        Object callee = Modifier.isStatic(method.getModifiers()) ? null : this.targetObject;
                        try {
                            isFound = method.invoke(callee, parameter) != null;
                            if (!isFound) continue;
                            break;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                catch (JavetException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.v8Runtime.createV8ValueBoolean(isFound);
    }

    public boolean hasConstructors() {
        return !this.constructors.isEmpty();
    }

    protected void initialize() {
        this.constructors = new ArrayList();
        this.fieldMap = new LinkedHashMap<String, Field>();
        this.genericGetters = new ArrayList<Method>();
        this.genericSetters = new ArrayList<Method>();
        this.methodsMap = new LinkedHashMap<String, List<Method>>();
        this.gettersMap = new LinkedHashMap<String, List<Method>>();
        this.settersMap = new LinkedHashMap<String, List<Method>>();
        this.uniqueKeySet = new LinkedHashSet<String>();
        this.isTargetTypeMap = Map.class.isAssignableFrom(this.targetClass);
        this.isTargetTypeSet = Set.class.isAssignableFrom(this.targetClass);
        this.classMode = false;
        if (this.targetObject instanceof Class) {
            Class objectClass = (Class)this.targetObject;
            this.classMode = JavetUniversalProxyHandler.isClassMode(objectClass);
            this.initializeFieldsAndMethods(objectClass, true);
        }
        this.initializeFieldsAndMethods(this.targetClass, false);
    }

    protected void initializeFieldsAndMethods(Class<?> currentClass, boolean staticMode) {
        if (!this.classMode) {
            if (this.isTargetTypeMap) {
                this.uniqueKeySet.addAll(((Map)this.targetObject).keySet());
            } else if (this.isTargetTypeSet) {
                this.uniqueKeySet.addAll((Set)this.targetObject);
            }
        }
        do {
            if (this.classMode) {
                this.constructors.addAll(Arrays.asList(currentClass.getConstructors()));
            }
            for (Field field : currentClass.getFields()) {
                String fieldName;
                int fieldModifiers = field.getModifiers();
                if (staticMode && !Modifier.isStatic(fieldModifiers) || !Modifier.isPublic(fieldModifiers) || this.fieldMap.containsKey(fieldName = field.getName())) continue;
                JavetReflectionUtils.safeSetAccessible(field);
                this.fieldMap.put(fieldName, field);
                if (this.isTargetTypeMap || this.isTargetTypeSet) continue;
                this.uniqueKeySet.add(fieldName);
            }
            for (AccessibleObject accessibleObject : currentClass.getMethods()) {
                int methodModifiers = ((Method)accessibleObject).getModifiers();
                if (staticMode && !Modifier.isStatic(methodModifiers) || !Modifier.isPublic(methodModifiers)) continue;
                JavetReflectionUtils.safeSetAccessible(accessibleObject);
                if (this.isGenericGetter((Method)accessibleObject)) {
                    this.genericGetters.add((Method)accessibleObject);
                } else if (this.isGenericSetter((Method)accessibleObject)) {
                    this.genericSetters.add((Method)accessibleObject);
                } else {
                    int getterPrefixLength = this.getGetterPrefixLength((Method)accessibleObject);
                    if (getterPrefixLength > 0) {
                        String aliasMethodName;
                        Matcher matcher;
                        this.addMethod((Method)accessibleObject, getterPrefixLength, this.gettersMap);
                        if (!this.isTargetTypeMap && !this.isTargetTypeSet && (matcher = PATTERN_CAPITALIZED_PREFIX.matcher(aliasMethodName = ((Method)accessibleObject).getName().substring(getterPrefixLength))).find()) {
                            int capitalizedPrefixLength = matcher.group().length();
                            if (capitalizedPrefixLength == 1) {
                                this.uniqueKeySet.add(aliasMethodName.substring(0, capitalizedPrefixLength).toLowerCase(Locale.ROOT) + aliasMethodName.substring(capitalizedPrefixLength));
                            } else {
                                this.uniqueKeySet.add(aliasMethodName.substring(0, capitalizedPrefixLength - 1).toLowerCase(Locale.ROOT) + aliasMethodName.substring(capitalizedPrefixLength - 1));
                            }
                        }
                    } else {
                        int setterPrefixLength = this.getSetterPrefixLength((Method)accessibleObject);
                        if (setterPrefixLength > 0) {
                            this.addMethod((Method)accessibleObject, setterPrefixLength, this.settersMap);
                        }
                    }
                }
                this.addMethod((Method)accessibleObject, 0, this.methodsMap);
            }
        } while (currentClass != Object.class && (currentClass = currentClass.getSuperclass()) != null);
    }

    public boolean isClassMode() {
        return this.classMode;
    }

    protected boolean isGenericGetter(Method method) {
        String methodName = method.getName();
        for (String prefix : GETTER_PREFIX_ARRAY) {
            if (!methodName.equals(prefix) || method.getParameterCount() != 1 || method.isVarArgs()) continue;
            return true;
        }
        return false;
    }

    protected boolean isGenericSetter(Method method) {
        String methodName = method.getName();
        for (String prefix : SETTER_PREFIX_ARRAY) {
            if (!methodName.equals(prefix) || method.getParameterCount() != 2 || method.isVarArgs()) continue;
            return true;
        }
        return false;
    }

    @V8BindingEnabler
    public boolean isV8BindingEnabled(String methodName) {
        if (METHOD_NAME_CONSTRUCT.equals(methodName)) {
            return this.hasConstructors();
        }
        return true;
    }

    @Override
    @V8Function
    public V8Value ownKeys(V8Value target) throws JavetException {
        if (!this.classMode) {
            if (this.isTargetTypeMap) {
                return this.v8Runtime.toV8Value(((Map)this.targetObject).keySet().toArray());
            }
            if (this.isTargetTypeSet) {
                return this.v8Runtime.toV8Value(((Set)this.targetObject).toArray());
            }
        }
        return this.v8Runtime.toV8Value(this.uniqueKeySet.toArray());
    }

    @Override
    @V8Function
    public V8ValueBoolean set(V8Value target, V8Value propertyKey, V8Value propertyValue, V8Value receiver) throws JavetException {
        int fieldModifiers;
        String propertyName;
        Field field;
        boolean isSet = false;
        if (!this.fieldMap.isEmpty() && propertyKey instanceof V8ValueString && (field = this.fieldMap.get(propertyName = ((V8ValueString)propertyKey).toPrimitive())) != null && !Modifier.isFinal(fieldModifiers = field.getModifiers())) {
            try {
                Object callee = Modifier.isStatic(fieldModifiers) ? null : this.targetObject;
                field.set(callee, this.v8Runtime.toObject(propertyValue));
                isSet = true;
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
            }
        }
        if (!(isSet || this.genericSetters.isEmpty() && this.settersMap.isEmpty())) {
            String propertyName2;
            List<Method> methods;
            Object valueObject;
            Object propertyObject;
            try {
                propertyObject = this.v8Runtime.toObject(propertyKey);
                valueObject = this.v8Runtime.toObject(propertyValue);
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
            }
            if (!this.genericSetters.isEmpty() && propertyObject != null && !(propertyObject instanceof V8Value)) {
                try {
                    for (Method method : this.genericSetters) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class<?> keyParameterType = parameterTypes[0];
                        Class<?> valueParameterType = parameterTypes[1];
                        Object key = propertyObject;
                        Object value = valueObject;
                        boolean isCallable = keyParameterType.isAssignableFrom(propertyObject.getClass());
                        if (!isCallable && keyParameterType.isPrimitive()) {
                            key = JavetTypeUtils.toExactPrimitive(keyParameterType, propertyObject);
                            boolean bl = isCallable = key != null;
                        }
                        if (!isCallable) {
                            key = JavetTypeUtils.toApproximatePrimitive(keyParameterType, propertyObject);
                            boolean bl = isCallable = key != null;
                        }
                        if (isCallable) {
                            isCallable = valueParameterType.isAssignableFrom(valueObject.getClass());
                            if (!isCallable && valueParameterType.isPrimitive()) {
                                value = JavetTypeUtils.toExactPrimitive(valueParameterType, valueObject);
                                boolean bl = isCallable = value != null;
                            }
                            if (!isCallable) {
                                value = JavetTypeUtils.toApproximatePrimitive(valueParameterType, propertyObject);
                                boolean bl = isCallable = value != null;
                            }
                        }
                        if (!isCallable) continue;
                        Object callee = Modifier.isStatic(method.getModifiers()) ? null : this.targetObject;
                        method.invoke(callee, key, value);
                        isSet = true;
                        break;
                    }
                }
                catch (Throwable t) {
                    throw new JavetException(JavetError.CallbackUnknownFailure, SimpleMap.of("message", t.getMessage()), t);
                }
            }
            if (!isSet && propertyObject instanceof String && (methods = this.settersMap.get(propertyName2 = (String)propertyObject)) != null) {
                JavetUniversalInterceptor javetUniversalInterceptor = new JavetUniversalInterceptor(this.v8Runtime, this.targetObject, propertyName2, methods);
                javetUniversalInterceptor.invoke(propertyValue);
                isSet = true;
            }
        }
        return this.v8Runtime.createV8ValueBoolean(isSet);
    }

    public static class ScoredExecutable<E extends Executable> {
        private final E executable;
        private final JavetVirtualObject[] javetVirtualObjects;
        private final Object targetObject;
        private double score;

        public ScoredExecutable(V8Runtime v8Runtime, Object targetObject, E executable, JavetVirtualObject[] javetVirtualObjects) {
            this.executable = executable;
            this.javetVirtualObjects = javetVirtualObjects;
            this.score = 0.0;
            this.targetObject = targetObject;
        }

        public void calculateScore() throws JavetException {
            int parameterCount = ((Executable)this.executable).getParameterCount();
            Class<?>[] parameterTypes = ((Executable)this.executable).getParameterTypes();
            boolean isExecutableVarArgs = ((Executable)this.executable).isVarArgs();
            this.score = 0.0;
            int length = this.javetVirtualObjects.length;
            if (length == 0) {
                if (isExecutableVarArgs) {
                    if (parameterCount == 1) {
                        this.score = 0.99;
                    }
                } else if (parameterCount == 0) {
                    this.score = 1.0;
                }
            } else {
                boolean isFixedArgs;
                boolean isVarArgs = isExecutableVarArgs && length >= parameterCount - 1;
                boolean bl = isFixedArgs = !isExecutableVarArgs && length == parameterCount;
                if (isVarArgs || isFixedArgs) {
                    Object object;
                    V8Value v8Value;
                    double totalScore = 0.0;
                    int fixedParameterCount = isExecutableVarArgs ? parameterCount - 1 : parameterCount;
                    for (int i = 0; i < fixedParameterCount; ++i) {
                        Class<?> parameterType = parameterTypes[i];
                        v8Value = this.javetVirtualObjects[i].getV8Value();
                        if (v8Value != null) {
                            if (V8_VALUE_CLASS.isAssignableFrom(parameterType) && parameterType.isAssignableFrom(v8Value.getClass())) {
                                totalScore += 1.0;
                                continue;
                            }
                            if (parameterType.isInterface()) {
                                if (V8_VALUE_FUNCTION_CLASS.isAssignableFrom(v8Value.getClass())) {
                                    totalScore += 0.95;
                                    continue;
                                }
                                if (!V8_VALUE_PROXY_CLASS.isAssignableFrom(v8Value.getClass()) && V8_VALUE_OBJECT_CLASS.isAssignableFrom(v8Value.getClass())) {
                                    totalScore += 0.85;
                                    continue;
                                }
                            }
                        }
                        if ((object = this.javetVirtualObjects[i].getObject()) == null) {
                            if (parameterType.isPrimitive()) {
                                totalScore = 0.0;
                                break;
                            }
                            totalScore += 0.9;
                            continue;
                        }
                        if (parameterType.isAssignableFrom(object.getClass())) {
                            totalScore += 0.9;
                            continue;
                        }
                        if (parameterType.isPrimitive() && JavetTypeUtils.toExactPrimitive(parameterType, object) != null) {
                            totalScore += 0.8;
                            continue;
                        }
                        if (JavetTypeUtils.toApproximatePrimitive(parameterType, object) != null) {
                            totalScore += 0.7;
                            continue;
                        }
                        totalScore = 0.0;
                        break;
                    }
                    if ((fixedParameterCount == 0 || fixedParameterCount > 0 && totalScore > 0.0) && isVarArgs) {
                        Class<?> componentType = parameterTypes[fixedParameterCount].getComponentType();
                        for (int i = fixedParameterCount; i < length; ++i) {
                            v8Value = this.javetVirtualObjects[i].getV8Value();
                            if (v8Value != null) {
                                if (V8_VALUE_CLASS.isAssignableFrom(componentType) && componentType.isAssignableFrom(v8Value.getClass())) {
                                    totalScore += 0.95;
                                    continue;
                                }
                                if (componentType.isInterface()) {
                                    if (V8_VALUE_FUNCTION_CLASS.isAssignableFrom(v8Value.getClass())) {
                                        totalScore += 0.95;
                                        continue;
                                    }
                                    if (!V8_VALUE_PROXY_CLASS.isAssignableFrom(v8Value.getClass()) && V8_VALUE_OBJECT_CLASS.isAssignableFrom(v8Value.getClass())) {
                                        totalScore += 0.85;
                                        continue;
                                    }
                                }
                            }
                            if ((object = this.javetVirtualObjects[i].getObject()) == null) {
                                if (componentType.isPrimitive()) {
                                    totalScore = 0.0;
                                    break;
                                }
                                totalScore += 0.85;
                                continue;
                            }
                            if (componentType.isAssignableFrom(object.getClass())) {
                                totalScore += 0.85;
                                continue;
                            }
                            if (componentType.isPrimitive() && JavetTypeUtils.toExactPrimitive(componentType, object) != null) {
                                totalScore += 0.75;
                                continue;
                            }
                            if (JavetTypeUtils.toApproximatePrimitive(componentType, object) != null) {
                                totalScore += 0.65;
                                continue;
                            }
                            totalScore = 0.0;
                            break;
                        }
                    }
                    if (totalScore > 0.0) {
                        this.score = totalScore / (double)length;
                        if (this.targetObject != null && ((Executable)this.executable).getDeclaringClass() != this.targetObject.getClass()) {
                            this.score *= 0.9;
                        }
                    }
                }
            }
        }

        public Object execute() throws Throwable {
            int length = this.javetVirtualObjects.length;
            Object callee = Modifier.isStatic(((Executable)this.executable).getModifiers()) ? null : this.targetObject;
            int parameterCount = ((Executable)this.executable).getParameterCount();
            Class<?>[] parameterTypes = ((Executable)this.executable).getParameterTypes();
            boolean isExecutableVarArgs = ((Executable)this.executable).isVarArgs();
            if (length == 0) {
                if (isExecutableVarArgs) {
                    Class<?> componentType = parameterTypes[parameterCount - 1];
                    Object varObject = Array.newInstance(componentType, 0);
                    if (this.executable instanceof Constructor) {
                        return ((Constructor)this.executable).newInstance(varObject);
                    }
                    return ((Method)this.executable).invoke(callee, varObject);
                }
                if (this.executable instanceof Constructor) {
                    return ((Constructor)this.executable).newInstance(new Object[0]);
                }
                return ((Method)this.executable).invoke(callee, new Object[0]);
            }
            ArrayList<Object> parameters = new ArrayList<Object>();
            int fixedParameterCount = isExecutableVarArgs ? parameterCount - 1 : parameterCount;
            for (int i = 0; i < fixedParameterCount; ++i) {
                Object object;
                Class<?> parameterType = parameterTypes[i];
                V8Value v8Value = this.javetVirtualObjects[i].getV8Value();
                Object parameter = object = this.javetVirtualObjects[i].getObject();
                boolean conversionRequired = true;
                if (v8Value != null) {
                    if (V8_VALUE_CLASS.isAssignableFrom(parameterType) && parameterType.isAssignableFrom(v8Value.getClass())) {
                        parameter = v8Value;
                        conversionRequired = false;
                    } else if (parameterType.isInterface()) {
                        if (V8_VALUE_FUNCTION_CLASS.isAssignableFrom(v8Value.getClass())) {
                            DynamicProxyV8ValueFunctionInvocationHandler invocationHandler = new DynamicProxyV8ValueFunctionInvocationHandler((V8ValueFunction)v8Value.toClone());
                            parameter = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{parameterType, AutoCloseable.class}, (InvocationHandler)invocationHandler);
                            conversionRequired = false;
                        } else if (!V8_VALUE_PROXY_CLASS.isAssignableFrom(v8Value.getClass()) && V8_VALUE_OBJECT_CLASS.isAssignableFrom(v8Value.getClass())) {
                            DynamicProxyV8ValueObjectInvocationHandler invocationHandler = new DynamicProxyV8ValueObjectInvocationHandler((V8ValueObject)v8Value.toClone());
                            parameter = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{parameterType, AutoCloseable.class}, (InvocationHandler)invocationHandler);
                            conversionRequired = false;
                        }
                    }
                }
                if (conversionRequired && object != null && !parameterType.isAssignableFrom(object.getClass())) {
                    Object approximatePrimitiveValue;
                    Object primitiveObject;
                    boolean primitiveFound = false;
                    if (parameterType.isPrimitive() && (primitiveObject = JavetTypeUtils.toExactPrimitive(parameterType, object)) != null) {
                        parameter = primitiveObject;
                        primitiveFound = true;
                    }
                    if (!primitiveFound && (approximatePrimitiveValue = JavetTypeUtils.toApproximatePrimitive(parameterType, object)) != null) {
                        parameter = approximatePrimitiveValue;
                    }
                }
                parameters.add(parameter);
            }
            if (isExecutableVarArgs) {
                Class<?> componentType = parameterTypes[fixedParameterCount].getComponentType();
                Object varObject = Array.newInstance(componentType, length - fixedParameterCount);
                for (int i = fixedParameterCount; i < length; ++i) {
                    Object object;
                    V8Value v8Value = this.javetVirtualObjects[i].getV8Value();
                    Object parameter = object = this.javetVirtualObjects[i].getObject();
                    boolean conversionRequired = true;
                    if (v8Value != null) {
                        if (V8_VALUE_CLASS.isAssignableFrom(componentType) && componentType.isAssignableFrom(v8Value.getClass())) {
                            parameter = v8Value;
                            conversionRequired = false;
                        } else if (componentType.isInterface()) {
                            if (V8_VALUE_FUNCTION_CLASS.isAssignableFrom(v8Value.getClass())) {
                                DynamicProxyV8ValueFunctionInvocationHandler invocationHandler = new DynamicProxyV8ValueFunctionInvocationHandler((V8ValueFunction)v8Value.toClone());
                                parameter = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{componentType, AutoCloseable.class}, (InvocationHandler)invocationHandler);
                                conversionRequired = false;
                            } else if (!V8_VALUE_PROXY_CLASS.isAssignableFrom(v8Value.getClass()) && V8_VALUE_OBJECT_CLASS.isAssignableFrom(v8Value.getClass())) {
                                DynamicProxyV8ValueObjectInvocationHandler invocationHandler = new DynamicProxyV8ValueObjectInvocationHandler((V8ValueObject)v8Value.toClone());
                                parameter = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{componentType, AutoCloseable.class}, (InvocationHandler)invocationHandler);
                                conversionRequired = false;
                            }
                        }
                    }
                    if (conversionRequired && object != null && !componentType.isAssignableFrom(object.getClass())) {
                        Object approximatePrimitiveValue;
                        Object primitiveObject;
                        boolean primitiveFound = false;
                        if (componentType.isPrimitive() && (primitiveObject = JavetTypeUtils.toExactPrimitive(componentType, object)) != null) {
                            parameter = primitiveObject;
                            primitiveFound = true;
                        }
                        if (!primitiveFound && (approximatePrimitiveValue = JavetTypeUtils.toApproximatePrimitive(componentType, object)) != null) {
                            parameter = approximatePrimitiveValue;
                        }
                    }
                    Array.set(varObject, i - fixedParameterCount, parameter);
                }
                parameters.add(varObject);
            }
            if (this.executable instanceof Constructor) {
                return ((Constructor)this.executable).newInstance(parameters.toArray());
            }
            return ((Method)this.executable).invoke(callee, parameters.toArray());
        }

        public double getScore() {
            return this.score;
        }
    }

    public static class JavetUniversalInterceptor {
        private static final String METHOD_NAME_INVOKE = "invoke";
        private final String jsMethodName;
        private final List<Method> methods;
        private final Object targetObject;
        private final V8Runtime v8Runtime;

        public JavetUniversalInterceptor(V8Runtime v8Runtime, Object targetObject, String jsMethodName, List<Method> methods) {
            this.jsMethodName = jsMethodName;
            this.methods = methods;
            this.targetObject = targetObject;
            this.v8Runtime = v8Runtime;
        }

        public JavetCallbackContext getCallbackContext() {
            try {
                return new JavetCallbackContext(this, this.getClass().getMethod(METHOD_NAME_INVOKE, V8Value[].class));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }

        public String getJSMethodName() {
            return this.jsMethodName;
        }

        public List<Method> getMethods() {
            return this.methods;
        }

        public Object getTargetObject() {
            return this.targetObject;
        }

        public Object invoke(V8Value ... v8Values) throws JavetException {
            try {
                return JavetUniversalProxyHandler.execute(this.v8Runtime, this.targetObject, this.methods, V8ValueUtils.convertToVirtualObjects(v8Values));
            }
            catch (JavetException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new JavetException(JavetError.CallbackMethodFailure, SimpleMap.of("methodName", this.jsMethodName, "message", t.getMessage()), t);
            }
        }
    }
}

