/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.monitoring;

import java.util.Objects;

public final class V8HeapSpaceStatistics {
    private AllocationSpace allocationSpace;
    private int physicalSpaceSize;
    private int spaceAvailableSize;
    private String spaceName;
    private int spaceSize;
    private int spaceUsedSize;

    V8HeapSpaceStatistics(String spaceName, int physicalSpaceSize, int spaceAvailableSize, int spaceSize, int spaceUsedSize) {
        this.spaceName = spaceName;
        this.physicalSpaceSize = physicalSpaceSize;
        this.spaceAvailableSize = spaceAvailableSize;
        this.spaceSize = spaceSize;
        this.spaceUsedSize = spaceUsedSize;
    }

    public AllocationSpace getAllocationSpace() {
        return this.allocationSpace;
    }

    public int getPhysicalSpaceSize() {
        return this.physicalSpaceSize;
    }

    public int getSpaceAvailableSize() {
        return this.spaceAvailableSize;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public int getSpaceSize() {
        return this.spaceSize;
    }

    public int getSpaceUsedSize() {
        return this.spaceUsedSize;
    }

    public V8HeapSpaceStatistics setAllocationSpace(AllocationSpace allocationSpace) {
        this.allocationSpace = Objects.requireNonNull(allocationSpace);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name = ").append(this.getClass().getSimpleName());
        sb.append(", ").append("spaceName = ").append(this.spaceName);
        sb.append(", ").append("physicalSpaceSize = ").append(this.physicalSpaceSize);
        sb.append(", ").append("spaceAvailableSize = ").append(this.spaceAvailableSize);
        sb.append(", ").append("spaceSize = ").append(this.spaceSize);
        sb.append(", ").append("spaceUsedSize = ").append(this.spaceUsedSize);
        return sb.toString();
    }

    public static enum AllocationSpace {
        RO_SPACE(0),
        OLD_SPACE(1),
        CODE_SPACE(2),
        MAP_SPACE(3),
        LO_SPACE(4),
        CODE_LO_SPACE(5),
        NEW_LO_SPACE(6),
        NEW_SPACE(7),
        FIRST_SPACE(RO_SPACE.getIndex()),
        LAST_SPACE(NEW_SPACE.getIndex()),
        FIRST_MUTABLE_SPACE(OLD_SPACE.getIndex()),
        LAST_MUTABLE_SPACE(NEW_SPACE.getIndex()),
        FIRST_GROWABLE_PAGED_SPACE(OLD_SPACE.getIndex()),
        LAST_GROWABLE_PAGED_SPACE(MAP_SPACE.getIndex());

        private int index;

        private AllocationSpace(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

