/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.executors;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.executors.V8StringExecutor;
import com.caoccao.javet.utils.SimpleMap;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class V8PathExecutor
extends V8StringExecutor {
    protected Path scriptPath;

    public V8PathExecutor(V8Runtime v8Runtime, Path scriptPath) throws JavetException {
        super(v8Runtime);
        this.scriptPath = scriptPath;
        this.setResourceName(scriptPath.toFile().getAbsolutePath());
    }

    public Path getScriptPath() {
        return this.scriptPath;
    }

    @Override
    public String getScriptString() throws JavetException {
        if (this.scriptString == null) {
            try {
                this.scriptString = new String(Files.readAllBytes(this.scriptPath), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new JavetException(JavetError.FailedToReadPath, SimpleMap.of("path", this.scriptPath), e);
            }
        }
        return this.scriptString;
    }
}

