/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.engine.IJavetEngine;
import com.caoccao.javet.interop.engine.IJavetEnginePool;
import com.caoccao.javet.interop.engine.JavetEngine;
import com.caoccao.javet.interop.engine.JavetEngineConfig;
import com.caoccao.javet.interop.engine.JavetEngineUsage;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.interop.options.V8RuntimeOptions;
import com.caoccao.javet.utils.JavetDateTimeUtils;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class JavetEnginePool<R extends V8Runtime>
implements IJavetEnginePool<R>,
Runnable {
    protected static final String JAVET_DAEMON_THREAD_NAME = "Javet Daemon";
    protected final ConcurrentLinkedQueue<JavetEngine<R>> activeEngineList;
    protected final Object externalLock;
    protected final ConcurrentLinkedQueue<JavetEngine<R>> idleEngineList;
    protected volatile boolean active;
    protected JavetEngineConfig config;
    protected Thread daemonThread;
    protected volatile boolean quitting;

    public JavetEnginePool() {
        this(new JavetEngineConfig());
    }

    public JavetEnginePool(JavetEngineConfig config) {
        Objects.requireNonNull(config);
        this.config = config;
        this.activeEngineList = new ConcurrentLinkedQueue();
        this.idleEngineList = new ConcurrentLinkedQueue();
        this.externalLock = new Object();
        this.active = false;
        this.quitting = false;
        this.startDaemon();
    }

    @Override
    public void close() throws JavetException {
        this.stopDaemon();
    }

    protected JavetEngine<R> createEngine() throws JavetException {
        V8Host v8Host = V8Host.getInstance(this.config.getJSRuntimeType());
        Object runtimeOptions = this.config.getJSRuntimeType().getRuntimeOptions();
        if (runtimeOptions instanceof V8RuntimeOptions) {
            V8RuntimeOptions v8RuntimeOptions = (V8RuntimeOptions)runtimeOptions;
            v8RuntimeOptions.setGlobalName(this.config.getGlobalName());
        }
        Object v8Runtime = v8Host.createV8Runtime(true, (RuntimeOptions<?>)runtimeOptions);
        ((V8Runtime)v8Runtime).allowEval(this.config.isAllowEval());
        ((V8Runtime)v8Runtime).setLogger(this.config.getJavetLogger());
        return new JavetEngine(this, v8Runtime);
    }

    @Override
    public int getActiveEngineCount() {
        return this.activeEngineList.size();
    }

    @Override
    public JavetEngineConfig getConfig() {
        return this.config;
    }

    @Override
    public IJavetEngine<R> getEngine() throws JavetException {
        IJavetLogger logger = this.config.getJavetLogger();
        logger.debug("JavetEnginePool.getEngine() begins.");
        JavetEngine<R> engine = null;
        while (!this.quitting) {
            engine = this.idleEngineList.poll();
            if (engine == null && this.getActiveEngineCount() < this.config.getPoolMaxSize()) {
                engine = this.createEngine();
            }
            if (engine != null) {
                engine.setActive(true);
                this.activeEngineList.add(engine);
                break;
            }
            try {
                TimeUnit.MILLISECONDS.sleep(this.config.getPoolDaemonCheckIntervalMillis());
            }
            catch (InterruptedException e) {
                logger.logError(e, "Failed to sleep a while to wait for an idle engine.", new Object[0]);
            }
        }
        JavetEngineUsage usage = engine.getUsage();
        usage.increaseUsedCount();
        logger.debug("JavetEnginePool.getEngine() ends.");
        return engine;
    }

    @Override
    public int getIdleEngineCount() {
        return this.idleEngineList.size();
    }

    protected ZonedDateTime getUTCNow() {
        return JavetDateTimeUtils.getUTCNow();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isClosed() {
        return !this.active;
    }

    @Override
    public boolean isQuitting() {
        return this.quitting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseEngine(IJavetEngine<R> engine) {
        IJavetLogger logger = this.config.getJavetLogger();
        logger.debug("JavetEnginePool.releaseEngine() begins.");
        Object object = this.externalLock;
        synchronized (object) {
            this.externalLock.notify();
        }
        logger.debug("JavetEnginePool.releaseEngine() ends.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JavetEngine<R> engine;
        IJavetLogger logger = this.config.getJavetLogger();
        logger.debug("JavetEnginePool.run() begins.");
        while (!this.quitting) {
            JavetEngine<R> engine2;
            int activeEngineCount = this.getActiveEngineCount();
            for (int i = 0; i < activeEngineCount && (engine2 = this.activeEngineList.poll()) != null; ++i) {
                if (engine2.isActive()) {
                    this.activeEngineList.add(engine2);
                    continue;
                }
                if (this.config.isAutoSendGCNotification()) {
                    engine2.sendGCNotification();
                }
                this.idleEngineList.add(engine2);
            }
            int idleEngineCount = this.getIdleEngineCount();
            for (int i = this.config.getPoolMinSize(); i < idleEngineCount; ++i) {
                ZonedDateTime resetEngineZonedDateTime;
                int immediateIdleEngineCount = this.getIdleEngineCount();
                JavetEngine<R> engine3 = this.idleEngineList.poll();
                if (engine3 == null) break;
                JavetEngineUsage usage = engine3.getUsage();
                ZonedDateTime expirationZonedDateTime = usage.getLastActiveZonedDatetime().plus(this.config.getPoolIdleTimeoutSeconds(), ChronoUnit.SECONDS);
                if (immediateIdleEngineCount > this.config.getPoolMaxSize() || expirationZonedDateTime.isBefore(this.getUTCNow())) {
                    try {
                        engine3.close(true);
                    }
                    catch (Throwable t) {
                        logger.logError(t, "Failed to release idle engine.", new Object[0]);
                    }
                    continue;
                }
                if (this.config.getResetEngineTimeoutSeconds() > 0 && (resetEngineZonedDateTime = usage.getLastActiveZonedDatetime().plus(this.config.getResetEngineTimeoutSeconds(), ChronoUnit.SECONDS)).isBefore(this.getUTCNow())) {
                    try {
                        logger.debug("JavetEnginePool reset engine begins.");
                        engine3.resetContext();
                        logger.debug("JavetEnginePool reset engine ends.");
                    }
                    catch (Exception e) {
                        logger.logError(e, "Failed to reset idle engine.", new Object[0]);
                    }
                }
                this.idleEngineList.add(engine3);
            }
            Object object = this.externalLock;
            synchronized (object) {
                try {
                    this.externalLock.wait(this.config.getPoolDaemonCheckIntervalMillis());
                }
                catch (InterruptedException e) {
                    logger.logError(e, "Failed to sleep a while to wait for next round in Javet engine pool daemon.", new Object[0]);
                }
            }
        }
        logger.debug("JavetEnginePool daemon is quitting.");
        while ((engine = this.idleEngineList.poll()) != null) {
            try {
                engine.close(true);
            }
            catch (Throwable t) {
                logger.logError(t, "Failed to release idle engine.", new Object[0]);
            }
        }
        while ((engine = this.activeEngineList.poll()) != null) {
            try {
                engine.close(true);
            }
            catch (Throwable t) {
                logger.logError(t, "Failed to release active engine.", new Object[0]);
            }
        }
        logger.debug("JavetEnginePool.run() ends.");
    }

    protected void startDaemon() {
        IJavetLogger logger = this.config.getJavetLogger();
        logger.debug("JavetEnginePool.startDaemon() begins.");
        this.activeEngineList.clear();
        this.idleEngineList.clear();
        this.quitting = false;
        this.config.setExecutorService(Executors.newCachedThreadPool());
        this.daemonThread = new Thread(this);
        this.daemonThread.setDaemon(true);
        this.daemonThread.setName(JAVET_DAEMON_THREAD_NAME);
        this.daemonThread.start();
        this.active = true;
        logger.debug("JavetEnginePool.startDaemon() ends.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopDaemon() {
        IJavetLogger logger = this.config.getJavetLogger();
        logger.debug("JavetEnginePool.stopDaemon() begins.");
        this.quitting = true;
        try {
            this.config.getExecutorService().shutdown();
            this.config.getExecutorService().awaitTermination(this.config.getPoolShutdownTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            logger.logError(e, e.getMessage(), new Object[0]);
        }
        finally {
            this.config.setExecutorService(null);
        }
        try {
            if (this.daemonThread != null) {
                this.daemonThread.join();
            }
        }
        catch (Exception e) {
            logger.logError(e, e.getMessage(), new Object[0]);
        }
        finally {
            this.daemonThread = null;
        }
        this.active = false;
        this.quitting = false;
        logger.debug("JavetEnginePool.stopDaemon() ends.");
    }
}

